/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;

public final class CollectionUtils {
    public static <T> List<T> reverse(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list);
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static <T> List<T> reverse(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static <K, V> Map newMap(Object ... objectArray) {
        if (objectArray == null) {
            return Collections.emptyMap();
        }
        if (objectArray.length % 2 == 1) {
            throw new IllegalArgumentException("Must have an even number of keys and values");
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < objectArray.length; i += 2) {
            hashMap.put(objectArray[i], objectArray[i + 1]);
        }
        return hashMap;
    }

    @SafeVarargs
    public static <T> Set<T> newSet(T ... TArray) {
        if (TArray == null) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(TArray));
    }

    @SafeVarargs
    public static <T> List<T> newList(T ... TArray) {
        if (TArray == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(Arrays.asList(TArray));
    }

    public static <K, V> MapBuilder<K, V> map() {
        return CollectionUtils.map(new LinkedHashMap());
    }

    public static <K, V> MapBuilder<K, V> map(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <E> ListBuilder<E> list() {
        return CollectionUtils.list(new ArrayList());
    }

    public static <E> ListBuilder<E> list(List<E> list) {
        return new ListBuilder<E>(list);
    }

    public static <E> SetBuilder<E> set() {
        return CollectionUtils.set(new HashSet());
    }

    public static <E> SetBuilder<E> set(Set<E> set) {
        return new SetBuilder<E>(set);
    }

    @Nonnull
    public static Properties toProperties(@Nonnull Map<String, Object> map) {
        Objects.requireNonNull(map, "Argument 'map' must not be null");
        return new MapToPropertiesAdapter(map);
    }

    private static class MapToPropertiesAdapter
    extends Properties {
        private final Map<String, Object> map;

        private MapToPropertiesAdapter(@Nonnull Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public synchronized Object setProperty(String string, String string2) {
            return this.map.put(string, string2);
        }

        @Override
        public String getProperty(String string) {
            Object object = this.map.get(string);
            return object != null ? String.valueOf(object) : null;
        }

        @Override
        public String getProperty(String string, String string2) {
            Object object = this.map.get(string);
            return object != null ? String.valueOf(object) : string2;
        }

        @Override
        public Enumeration<?> propertyNames() {
            return this.keys();
        }

        @Override
        public Set<String> stringPropertyNames() {
            return this.map.keySet();
        }

        @Override
        public synchronized int size() {
            return this.map.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return new Enumeration<Object>(){
                private Iterator<String> keys;
                {
                    this.keys = new ArrayList(MapToPropertiesAdapter.this.map.keySet()).iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.keys.hasNext();
                }

                @Override
                public String nextElement() {
                    return this.keys.next();
                }
            };
        }

        @Override
        public synchronized Enumeration<Object> elements() {
            return new Enumeration<Object>(){
                private Iterator<Object> values;
                {
                    this.values = new ArrayList(MapToPropertiesAdapter.this.map.values()).iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.values.hasNext();
                }

                @Override
                public Object nextElement() {
                    return this.values.next();
                }
            };
        }

        @Override
        public synchronized boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public synchronized boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public synchronized Object get(Object object) {
            return this.map.get(object);
        }

        @Override
        public synchronized Object put(Object object, Object object2) {
            return this.map.put(String.valueOf(object), object2);
        }

        @Override
        public synchronized Object remove(Object object) {
            return this.map.remove(object);
        }

        @Override
        public synchronized void putAll(Map<?, ?> map) {
            this.map.putAll(map);
        }

        @Override
        public synchronized void clear() {
            this.map.clear();
        }

        @Override
        public Set<Object> keySet() {
            return new LinkedHashSet<Object>(this.map.keySet());
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            LinkedHashSet<Map.Entry<String, Object>> linkedHashSet = new LinkedHashSet<Map.Entry<String, Object>>(this.map.entrySet());
            return new LinkedHashSet<Map.Entry<Object, Object>>(linkedHashSet);
        }

        @Override
        public Collection<Object> values() {
            return this.map.values();
        }

        @Override
        public synchronized Object clone() {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(this.map);
            return new MapToPropertiesAdapter((Map<String, Object>)linkedHashMap);
        }
    }

    public static class SetBuilder<E>
    implements Set<E> {
        private final Set<E> delegate;

        public SetBuilder(Set<E> set) {
            this.delegate = set;
        }

        public SetBuilder<E> e(E e) {
            this.delegate.add(e);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.delegate.contains(object);
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.delegate.toArray(TArray);
        }

        @Override
        public boolean add(E e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean remove(Object object) {
            return this.delegate.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.delegate.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return this.delegate.addAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.delegate.retainAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.delegate.removeAll(collection);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class ListBuilder<E>
    implements List<E> {
        private final List<E> delegate;

        public ListBuilder(List<E> list) {
            this.delegate = list;
        }

        public ListBuilder<E> e(E e) {
            this.delegate.add(e);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.delegate.contains(object);
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.delegate.toArray(TArray);
        }

        @Override
        public boolean add(E e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean remove(Object object) {
            return this.delegate.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.delegate.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return this.delegate.addAll(collection);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            return this.delegate.addAll(n, collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.delegate.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.delegate.retainAll(collection);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public E get(int n) {
            return this.delegate.get(n);
        }

        @Override
        public E set(int n, E e) {
            return this.delegate.set(n, e);
        }

        @Override
        public void add(int n, E e) {
            this.delegate.add(n, e);
        }

        @Override
        public E remove(int n) {
            return this.delegate.remove(n);
        }

        @Override
        public int indexOf(Object object) {
            return this.delegate.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.delegate.lastIndexOf(object);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.delegate.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            return this.delegate.listIterator(n);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return this.delegate.subList(n, n2);
        }
    }

    public static class MapBuilder<K, V>
    implements Map<K, V> {
        private final Map<K, V> delegate;

        public MapBuilder(Map<K, V> map) {
            this.delegate = map;
        }

        public MapBuilder<K, V> e(K k, V v) {
            this.delegate.put(k, v);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.delegate.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.delegate.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.delegate.get(object);
        }

        @Override
        public V put(K k, V v) {
            return this.delegate.put(k, v);
        }

        @Override
        public V remove(Object object) {
            return this.delegate.remove(object);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.delegate.putAll(map);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

