/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.ExpandableResourceBundle;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeResourceBundle
extends ResourceBundle {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeResourceBundle.class);
    private final ResourceBundle[] bundles;
    private final List<String> keys = new ArrayList<String>();

    public CompositeResourceBundle(@Nonnull Collection<ResourceBundle> collection) {
        this(CompositeResourceBundle.toResourceBundleArray(collection));
    }

    public CompositeResourceBundle(@Nonnull ResourceBundle[] resourceBundleArray) {
        Objects.requireNonNull(resourceBundleArray, "Argument 'bundles' must not be null");
        GriffonClassUtils.requireState(resourceBundleArray.length > 0, "Argument 'bundles' must not be empty");
        this.bundles = new ResourceBundle[resourceBundleArray.length];
        for (int i = 0; i < resourceBundleArray.length; ++i) {
            this.bundles[i] = ExpandableResourceBundle.wrapResourceBundle(resourceBundleArray[i]);
        }
        for (ResourceBundle resourceBundle : this.bundles) {
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (this.keys.contains(string)) continue;
                this.keys.add(string);
            }
        }
    }

    @Override
    @Nullable
    protected Object handleGetObject(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Arguments 'key' must not be blank");
        LOG.trace("Searching key={}", (Object)string);
        for (ResourceBundle resourceBundle : this.bundles) {
            try {
                Object object = resourceBundle.getObject(string);
                LOG.trace("Bundle {}; key={}; value='{}'", new Object[]{resourceBundle, string, object});
                if (object == null) continue;
                return object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public Enumeration<String> getKeys() {
        return new IteratorAsEnumeration<String>(this.keys.iterator());
    }

    @Nonnull
    private static ResourceBundle[] toResourceBundleArray(@Nonnull Collection<ResourceBundle> collection) {
        Objects.requireNonNull(collection, "Argument 'bundles' must not be null");
        if (collection.isEmpty()) {
            return new ResourceBundle[0];
        }
        return collection.toArray(new ResourceBundle[collection.size()]);
    }

    private static class IteratorAsEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<E> iterator;

        public IteratorAsEnumeration(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }
}

