/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.GriffonNameUtils;
import griffon.util.TypeUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConfigUtils {
    private static final String ERROR_CONFIG_NULL = "Argument 'config' must not be null";
    private static final String ERROR_KEY_BLANK = "Argument 'key' must not be blank";

    private ConfigUtils() {
    }

    public static boolean containsKey(@Nonnull Map<String, Object> map, @Nonnull String string) {
        Objects.requireNonNull(map, ERROR_CONFIG_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        if (map.containsKey(string)) {
            return true;
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            Object object;
            if (map != null) {
                object = map.get(stringArray[i]);
                if (!(object instanceof Map)) {
                    return false;
                }
            } else {
                return false;
            }
            map = (Map)object;
        }
        return map != null && map.containsKey(stringArray[stringArray.length - 1]);
    }

    public static boolean containsKey(@Nonnull ResourceBundle resourceBundle, @Nonnull String string) {
        Objects.requireNonNull(resourceBundle, ERROR_CONFIG_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        String[] stringArray = string.split("\\.");
        try {
            if (resourceBundle.containsKey(string)) {
                return true;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (stringArray.length == 1) {
            return resourceBundle.containsKey(stringArray[0]);
        }
        Object object = resourceBundle.getObject(stringArray[0]);
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        for (int i = 1; i < stringArray.length - 1; ++i) {
            if (map != null) {
                object = map.get(stringArray[i]);
                if (!(object instanceof Map)) {
                    return false;
                }
            } else {
                return false;
            }
            map = (Map)object;
        }
        return map != null && map.containsKey(stringArray[stringArray.length - 1]);
    }

    public static boolean isValueDefined(@Nonnull Map<String, Object> map, @Nonnull String string) {
        Objects.requireNonNull(map, ERROR_CONFIG_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        if (map.containsKey(string)) {
            return true;
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            Object object;
            if (map != null) {
                object = map.get(stringArray[i]);
                if (!(object instanceof Map)) {
                    return false;
                }
            } else {
                return false;
            }
            map = (Map)object;
        }
        if (map == null) {
            return false;
        }
        Object object = map.get(stringArray[stringArray.length - 1]);
        return object != null;
    }

    public static boolean isValueDefined(@Nonnull ResourceBundle resourceBundle, @Nonnull String string) {
        Object object;
        Objects.requireNonNull(resourceBundle, ERROR_CONFIG_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        String[] stringArray = string.split("\\.");
        try {
            object = resourceBundle.getObject(string);
            if (object != null) {
                return true;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (stringArray.length == 1) {
            try {
                object = resourceBundle.getObject(stringArray[0]);
                return object != null;
            }
            catch (MissingResourceException missingResourceException) {
                return false;
            }
        }
        object = resourceBundle.getObject(stringArray[0]);
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        for (int i = 1; i < stringArray.length - 1; ++i) {
            if (map != null) {
                object = map.get(stringArray[i]);
                if (!(object instanceof Map)) {
                    return false;
                }
            } else {
                return false;
            }
            map = (Map)object;
        }
        if (map == null) {
            return false;
        }
        Object v = map.get(stringArray[stringArray.length - 1]);
        return v != null;
    }

    @Nullable
    public static <T> T getConfigValue(@Nonnull Map<String, Object> map, @Nonnull String string, @Nullable T t) {
        Objects.requireNonNull(map, ERROR_CONFIG_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        if (map.containsKey(string)) {
            return (T)map.get(string);
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            Object object;
            if (map != null) {
                object = map.get(stringArray[i]);
                if (!(object instanceof Map)) {
                    return t;
                }
            } else {
                return t;
            }
            map = (Map)object;
        }
        if (map == null) {
            return t;
        }
        Object object = map.get(stringArray[stringArray.length - 1]);
        return (T)(object != null ? object : t);
    }

    @Nullable
    public static <T> T getConfigValue(@Nonnull ResourceBundle resourceBundle, @Nonnull String string, @Nullable T t) {
        Object object;
        Objects.requireNonNull(resourceBundle, ERROR_CONFIG_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        String[] stringArray = string.split("\\.");
        try {
            object = resourceBundle.getObject(string);
            if (object != null) {
                return (T)object;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (stringArray.length == 1) {
            object = resourceBundle.getObject(stringArray[0]);
            return (T)(object != null ? object : t);
        }
        object = resourceBundle.getObject(stringArray[0]);
        if (!(object instanceof Map)) {
            return t;
        }
        Map map = (Map)object;
        for (int i = 1; i < stringArray.length - 1; ++i) {
            if (map != null) {
                object = map.get(stringArray[i]);
                if (!(object instanceof Map)) {
                    return t;
                }
            } else {
                return t;
            }
            map = (Map)object;
        }
        if (map == null) {
            return t;
        }
        Object v = map.get(stringArray[stringArray.length - 1]);
        return (T)(v != null ? v : t);
    }

    @Nullable
    public static <T> T getConfigValue(@Nonnull Map<String, Object> map, @Nonnull String string) throws MissingResourceException {
        Objects.requireNonNull(map, ERROR_CONFIG_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        String string2 = map.getClass().getName();
        if (map.containsKey(string)) {
            return (T)map.get(string);
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            Object object;
            if (map != null) {
                object = map.get(stringArray[i]);
                if (!(object instanceof Map)) {
                    throw ConfigUtils.missingResource(string2, string);
                }
            } else {
                throw ConfigUtils.missingResource(string2, string);
            }
            map = (Map)object;
        }
        if (map == null) {
            throw ConfigUtils.missingResource(string2, string);
        }
        Object object = map.get(stringArray[stringArray.length - 1]);
        if (object != null) {
            return (T)object;
        }
        throw ConfigUtils.missingResource(string2, string);
    }

    @Nullable
    public static <T> T getConfigValue(@Nonnull ResourceBundle resourceBundle, @Nonnull String string) throws MissingResourceException {
        Object object;
        Objects.requireNonNull(resourceBundle, ERROR_CONFIG_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        String string2 = resourceBundle.getClass().getName();
        String[] stringArray = string.split("\\.");
        try {
            object = resourceBundle.getObject(string);
            if (object != null) {
                return (T)object;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (stringArray.length == 1) {
            object = resourceBundle.getObject(stringArray[0]);
            if (object != null) {
                return (T)object;
            }
            throw ConfigUtils.missingResource(string2, string);
        }
        object = resourceBundle.getObject(stringArray[0]);
        if (!(object instanceof Map)) {
            throw ConfigUtils.missingResource(string2, string);
        }
        Map map = (Map)object;
        for (int i = 1; i < stringArray.length - 1; ++i) {
            if (map != null) {
                object = map.get(stringArray[i]);
                if (!(object instanceof Map)) {
                    throw ConfigUtils.missingResource(string2, string);
                }
            } else {
                throw ConfigUtils.missingResource(string2, string);
            }
            map = (Map)object;
        }
        if (map == null) {
            throw ConfigUtils.missingResource(string2, string);
        }
        Object v = map.get(stringArray[stringArray.length - 1]);
        if (v != null) {
            return (T)v;
        }
        throw ConfigUtils.missingResource(string2, string);
    }

    private static MissingResourceException missingResource(String string, String string2) throws MissingResourceException {
        return new MissingResourceException("Can't find resource for bundle " + string + ", key " + string2, string, string2);
    }

    public static boolean getConfigValueAsBoolean(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return ConfigUtils.getConfigValueAsBoolean(map, string, false);
    }

    public static boolean getConfigValueAsBoolean(@Nonnull Map<String, Object> map, @Nonnull String string, boolean bl) {
        Boolean bl2 = ConfigUtils.getConfigValue(map, string, Boolean.valueOf(bl));
        return TypeUtils.castToBoolean(bl2);
    }

    public static int getConfigValueAsInt(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return ConfigUtils.getConfigValueAsInt(map, string, 0);
    }

    public static int getConfigValueAsInt(@Nonnull Map<String, Object> map, @Nonnull String string, int n) {
        Integer n2 = ConfigUtils.getConfigValue(map, string, Integer.valueOf(n));
        return TypeUtils.castToInt(n2);
    }

    public static long getConfigValueAsLong(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return ConfigUtils.getConfigValueAsLong(map, string, 0L);
    }

    public static long getConfigValueAsLong(@Nonnull Map<String, Object> map, @Nonnull String string, long l) {
        Long l2 = ConfigUtils.getConfigValue(map, string, Long.valueOf(l));
        return TypeUtils.castToLong(l2);
    }

    public static double getConfigValueAsDouble(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return ConfigUtils.getConfigValueAsDouble(map, string, 0.0);
    }

    public static double getConfigValueAsDouble(@Nonnull Map<String, Object> map, @Nonnull String string, double d) {
        Double d2 = ConfigUtils.getConfigValue(map, string, Double.valueOf(d));
        return TypeUtils.castToDouble(d2);
    }

    public static float getConfigValueAsFloat(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return ConfigUtils.getConfigValueAsFloat(map, string, 0.0f);
    }

    public static float getConfigValueAsFloat(@Nonnull Map<String, Object> map, @Nonnull String string, float f) {
        Float f2 = ConfigUtils.getConfigValue(map, string, Float.valueOf(f));
        return TypeUtils.castToFloat(f2);
    }

    @Nullable
    public static Number getConfigValueAsNumber(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return ConfigUtils.getConfigValueAsNumber(map, string, null);
    }

    @Nullable
    public static Number getConfigValueAsNumber(@Nonnull Map<String, Object> map, @Nonnull String string, @Nullable Number number) {
        Number number2 = ConfigUtils.getConfigValue(map, string, number);
        return TypeUtils.castToNumber(number2);
    }

    @Nullable
    public static String getConfigValueAsString(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return ConfigUtils.getConfigValueAsString(map, string, "");
    }

    @Nullable
    public static String getConfigValueAsString(@Nonnull Map<String, Object> map, @Nonnull String string, @Nullable String string2) {
        String string3 = ConfigUtils.getConfigValue(map, string, string2);
        return string3 != null ? String.valueOf(string3) : null;
    }

    public static String getFilenameExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        int n2 = string.lastIndexOf("/");
        if (n2 > n) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String stripFilenameExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        int n2 = string.lastIndexOf("/");
        if (n2 > n) {
            return string;
        }
        return string.substring(0, n);
    }

    @Nonnull
    public static Set<String> collectKeys(@Nonnull Map<String, Object> map) {
        Objects.requireNonNull(map, "Argument 'map' must not be null");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            ConfigUtils.doCollectKeys(string, object, linkedHashSet);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    private static void doCollectKeys(String string, Object object, Set<String> set) {
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                ConfigUtils.doCollectKeys(string + "." + (String)entry.getKey(), entry.getValue(), set);
            }
        } else {
            set.add(string);
        }
    }
}

