/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpandableResourceBundle
extends ResourceBundle {
    private final Map<String, Object> entries = new LinkedHashMap<String, Object>();

    @Nonnull
    public static ResourceBundle wrapResourceBundle(@Nonnull ResourceBundle resourceBundle) {
        Objects.requireNonNull(resourceBundle, "Argument 'resourceBundle' must not be null");
        if (!(resourceBundle instanceof ExpandableResourceBundle)) {
            return new ExpandableResourceBundle(resourceBundle);
        }
        return resourceBundle;
    }

    public ExpandableResourceBundle(@Nonnull ResourceBundle resourceBundle) {
        Objects.requireNonNull(resourceBundle, "Argument 'delegate' must not be null");
        for (String string : resourceBundle.keySet()) {
            Object t = ConfigUtils.getConfigValue(resourceBundle, string);
            this.processKey(string, this.entries, t);
            this.entries.put(string, t);
        }
    }

    private void processKey(@Nonnull String string, @Nonnull Map<String, Object> map, @Nullable Object object) {
        String[] stringArray = this.split(string);
        if (stringArray[1] == null) {
            map.put(stringArray[0], object);
        } else {
            LinkedHashMap<String, Object> linkedHashMap = (LinkedHashMap<String, Object>)map.get(stringArray[0]);
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<String, Object>();
                map.put(stringArray[0], linkedHashMap);
            }
            this.processKey(stringArray[1], linkedHashMap, object);
        }
    }

    @Nonnull
    private String[] split(@Nonnull String string) {
        int n = string.indexOf(".");
        String string2 = n < 0 ? string : string.substring(0, n);
        String string3 = n > 0 ? string.substring(n + 1) : null;
        return new String[]{string2, string3};
    }

    @Override
    @Nullable
    protected final Object handleGetObject(@Nonnull String string) {
        return this.entries.get(GriffonNameUtils.requireNonBlank(string, "Argument 'key' must not be blank"));
    }

    @Override
    @Nonnull
    public final Enumeration<String> getKeys() {
        return new IteratorAsEnumeration<String>(this.entries.keySet().iterator());
    }

    private static class IteratorAsEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<E> iterator;

        public IteratorAsEnumeration(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }
}

