/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.core.Observable;
import griffon.core.Vetoable;
import griffon.core.artifact.GriffonArtifact;
import griffon.core.artifact.GriffonMvcArtifact;
import griffon.core.event.EventPublisher;
import griffon.core.i18n.MessageSource;
import griffon.core.mvc.MVCHandler;
import griffon.core.resources.ResourceHandler;
import griffon.core.resources.ResourceResolver;
import griffon.core.threading.ThreadingHandler;
import griffon.exceptions.BeanInstantiationException;
import griffon.exceptions.FieldException;
import griffon.exceptions.InstanceMethodInvocationException;
import griffon.exceptions.PropertyException;
import griffon.exceptions.StaticMethodInvocationException;
import griffon.util.GriffonNameUtils;
import griffon.util.MethodDescriptor;
import griffon.util.MethodUtils;
import griffon.util.TypeUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GriffonClassUtils {
    public static final Class<?>[] EMPTY_CLASS_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final Object[] EMPTY_ARGS;
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final String PROPERTY_IS_PREFIX = "is";
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String ON_SHUTDOWN_METHOD_NAME = "onShutdown";
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_COMPATIBLE_CLASSES;
    public static final Map<String, String> PRIMITIVE_TYPE_COMPATIBLE_TYPES;
    private static final Pattern EVENT_HANDLER_PATTERN;
    private static final Pattern CONTRIBUTION_PATTERN;
    private static final Pattern GETTER_PATTERN_1;
    private static final Pattern GETTER_PATTERN_2;
    private static final Pattern SETTER_PATTERN;
    private static final Set<MethodDescriptor> BASIC_METHODS;
    private static final Set<MethodDescriptor> ARTIFACT_METHODS;
    private static final Set<MethodDescriptor> MVC_METHODS;
    private static final Set<MethodDescriptor> THREADING_METHODS;
    private static final Set<MethodDescriptor> EVENT_PUBLISHER_METHODS;
    private static final Set<MethodDescriptor> OBSERVABLE_METHODS;
    private static final Set<MethodDescriptor> RESOURCE_HANDLER_METHODS;
    private static final Set<MethodDescriptor> MESSAGE_SOURCE_METHODS;
    private static final Set<MethodDescriptor> RESOURCE_RESOLVER_METHODS;
    private static final String ERROR_TYPE_NULL = "Argument 'type' must not be null";
    private static final String ERROR_METHOD_NAME_BLANK = "Argument 'methodName' must not be blank";
    private static final String ERROR_OBJECT_NULL = "Argument 'object' must not be null";
    private static final String ERROR_CLAZZ_NULL = "Argument 'clazz' must not be null";
    private static final String ERROR_DESCRIPTOR_NULL = "Argument 'descriptor' must not be null";
    private static final String ERROR_BEAN_NULL = "Argument 'bean' must not be null";
    private static final String ERROR_NAME_BLANK = "Argument 'name' must not be blank";
    private static final String ERROR_PROPERTIES_NULL = "Argument 'properties' must not be null";
    private static final String ERROR_FIELDS_NULL = "Argument 'fields' must not be null";
    private static final String ERROR_PROPERTY_NAME_BLANK = "Argument 'propertyName' must not be blank";
    private static final String ERROR_METHOD_NULL = "Argument 'method' must not be null";
    private static final Map<String, PropertyDescriptor[]> descriptorsCache;
    private static final String EMPTY_STRING = "";
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR;
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR;
    private static final Map<String, String> abbreviationMap;
    private static final Map<String, String> reverseAbbreviationMap;

    private static void registerPrimitiveClassPair(Class<?> clazz, Class<?> clazz2) {
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(clazz, clazz2);
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(clazz2, clazz);
        PRIMITIVE_TYPE_COMPATIBLE_TYPES.put(clazz.getName(), clazz2.getName());
        PRIMITIVE_TYPE_COMPATIBLE_TYPES.put(clazz2.getName(), clazz.getName());
    }

    public static void requireState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void requireState(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static byte[] requireNonEmpty(@Nonnull byte[] byArray) {
        Objects.requireNonNull(byArray);
        GriffonClassUtils.requireState(byArray.length != 0);
        return byArray;
    }

    public static byte[] requireNonEmpty(@Nonnull byte[] byArray, @Nonnull String string) {
        Objects.requireNonNull(byArray);
        GriffonClassUtils.requireState(byArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return byArray;
    }

    public static short[] requireNonEmpty(@Nonnull short[] sArray) {
        Objects.requireNonNull(sArray);
        GriffonClassUtils.requireState(sArray.length != 0);
        return sArray;
    }

    public static short[] requireNonEmpty(@Nonnull short[] sArray, @Nonnull String string) {
        Objects.requireNonNull(sArray);
        GriffonClassUtils.requireState(sArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return sArray;
    }

    public static int[] requireNonEmpty(@Nonnull int[] nArray) {
        Objects.requireNonNull(nArray);
        GriffonClassUtils.requireState(nArray.length != 0);
        return nArray;
    }

    public static int[] requireNonEmpty(@Nonnull int[] nArray, @Nonnull String string) {
        Objects.requireNonNull(nArray);
        GriffonClassUtils.requireState(nArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return nArray;
    }

    public static long[] requireNonEmpty(@Nonnull long[] lArray) {
        Objects.requireNonNull(lArray);
        GriffonClassUtils.requireState(lArray.length != 0);
        return lArray;
    }

    public static long[] requireNonEmpty(@Nonnull long[] lArray, @Nonnull String string) {
        Objects.requireNonNull(lArray);
        GriffonClassUtils.requireState(lArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return lArray;
    }

    public static float[] requireNonEmpty(@Nonnull float[] fArray) {
        Objects.requireNonNull(fArray);
        GriffonClassUtils.requireState(fArray.length != 0);
        return fArray;
    }

    public static float[] requireNonEmpty(@Nonnull float[] fArray, @Nonnull String string) {
        Objects.requireNonNull(fArray);
        GriffonClassUtils.requireState(fArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return fArray;
    }

    public static double[] requireNonEmpty(@Nonnull double[] dArray) {
        Objects.requireNonNull(dArray);
        GriffonClassUtils.requireState(dArray.length != 0);
        return dArray;
    }

    public static double[] requireNonEmpty(@Nonnull double[] dArray, @Nonnull String string) {
        Objects.requireNonNull(dArray);
        GriffonClassUtils.requireState(dArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return dArray;
    }

    public static char[] requireNonEmpty(@Nonnull char[] cArray) {
        Objects.requireNonNull(cArray);
        GriffonClassUtils.requireState(cArray.length != 0);
        return cArray;
    }

    public static char[] requireNonEmpty(@Nonnull char[] cArray, @Nonnull String string) {
        Objects.requireNonNull(cArray);
        GriffonClassUtils.requireState(cArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return cArray;
    }

    public static boolean[] requireNonEmpty(@Nonnull boolean[] blArray) {
        Objects.requireNonNull(blArray);
        GriffonClassUtils.requireState(blArray.length != 0);
        return blArray;
    }

    public static boolean[] requireNonEmpty(@Nonnull boolean[] blArray, @Nonnull String string) {
        Objects.requireNonNull(blArray);
        GriffonClassUtils.requireState(blArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return blArray;
    }

    public static <E> E[] requireNonEmpty(@Nonnull E[] EArray) {
        Objects.requireNonNull(EArray);
        GriffonClassUtils.requireState(EArray.length != 0);
        return EArray;
    }

    public static <E> E[] requireNonEmpty(@Nonnull E[] EArray, @Nonnull String string) {
        Objects.requireNonNull(EArray);
        GriffonClassUtils.requireState(EArray.length != 0, GriffonNameUtils.requireNonBlank(string, "message"));
        return EArray;
    }

    public static Collection<?> requireNonEmpty(@Nonnull Collection<?> collection) {
        Objects.requireNonNull(collection);
        GriffonClassUtils.requireState(!collection.isEmpty());
        return collection;
    }

    public static Collection<?> requireNonEmpty(@Nonnull Collection<?> collection, @Nonnull String string) {
        Objects.requireNonNull(collection);
        GriffonClassUtils.requireState(!collection.isEmpty(), GriffonNameUtils.requireNonBlank(string, "message"));
        return collection;
    }

    public static Map<?, ?> requireNonEmpty(@Nonnull Map<?, ?> map) {
        Objects.requireNonNull(map);
        GriffonClassUtils.requireState(!map.isEmpty());
        return map;
    }

    public static Map<?, ?> requireNonEmpty(@Nonnull Map<?, ?> map, @Nonnull String string) {
        Objects.requireNonNull(map);
        GriffonClassUtils.requireState(!map.isEmpty(), GriffonNameUtils.requireNonBlank(string, "message"));
        return map;
    }

    public static boolean isEventHandler(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        return EVENT_HANDLER_PATTERN.matcher(string).matches() && !ON_SHUTDOWN_METHOD_NAME.equals(string);
    }

    public static boolean isEventHandler(@Nonnull Method method) {
        return GriffonClassUtils.isEventHandler(method, false);
    }

    public static boolean isEventHandler(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isEventHandler(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isEventHandler(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && GriffonClassUtils.isEventHandler(methodDescriptor.getName());
    }

    public static boolean isBasicMethod(@Nonnull Method method) {
        return GriffonClassUtils.isBasicMethod(method, false);
    }

    public static boolean isBasicMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isBasicMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isBasicMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && BASIC_METHODS.contains(methodDescriptor);
    }

    public static boolean isContributionMethod(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        return CONTRIBUTION_PATTERN.matcher(string).matches();
    }

    public static boolean isContributionMethod(@Nonnull Method method) {
        return GriffonClassUtils.isContributionMethod(method, false);
    }

    public static boolean isContributionMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isContributionMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isContributionMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && CONTRIBUTION_PATTERN.matcher(methodDescriptor.getName()).matches();
    }

    public static boolean isGroovyInjectedMethod(@Nonnull Method method) {
        return GriffonClassUtils.isGroovyInjectedMethod(method, false);
    }

    public static boolean isGroovyInjectedMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isGroovyInjectedMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isGroovyInjectedMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && (methodDescriptor.getName().startsWith("super$") || methodDescriptor.getName().startsWith("this$"));
    }

    public static boolean isGetterMethod(@Nonnull Method method) {
        return GriffonClassUtils.isGetterMethod(method, false);
    }

    public static boolean isGetterMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isGetterMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isGetterMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && (GETTER_PATTERN_1.matcher(methodDescriptor.getName()).matches() || GETTER_PATTERN_2.matcher(methodDescriptor.getName()).matches());
    }

    public static boolean isSetterMethod(@Nonnull Method method) {
        return GriffonClassUtils.isSetterMethod(method, false);
    }

    public static boolean isSetterMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isSetterMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isSetterMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && SETTER_PATTERN.matcher(methodDescriptor.getName()).matches();
    }

    public static boolean isArtifactMethod(@Nonnull Method method) {
        return GriffonClassUtils.isArtifactMethod(method, false);
    }

    public static boolean isArtifactMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isArtifactMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isArtifactMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && ARTIFACT_METHODS.contains(methodDescriptor);
    }

    public static boolean isMvcMethod(@Nonnull Method method) {
        return GriffonClassUtils.isMvcMethod(method, false);
    }

    public static boolean isMvcMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isMvcMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isMvcMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && MVC_METHODS.contains(methodDescriptor);
    }

    public static boolean isThreadingMethod(@Nonnull Method method) {
        return GriffonClassUtils.isThreadingMethod(method, false);
    }

    public static boolean isThreadingMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isThreadingMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isThreadingMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && THREADING_METHODS.contains(methodDescriptor);
    }

    public static boolean isEventPublisherMethod(@Nonnull Method method) {
        return GriffonClassUtils.isEventPublisherMethod(method, false);
    }

    public static boolean isEventPublisherMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isEventPublisherMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isEventPublisherMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && EVENT_PUBLISHER_METHODS.contains(methodDescriptor);
    }

    public static boolean isObservableMethod(@Nonnull Method method) {
        return GriffonClassUtils.isObservableMethod(method, false);
    }

    public static boolean isObservableMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isObservableMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isObservableMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && OBSERVABLE_METHODS.contains(methodDescriptor);
    }

    public static boolean isResourceHandlerMethod(@Nonnull Method method) {
        return GriffonClassUtils.isResourceHandlerMethod(method, false);
    }

    public static boolean isResourceHandlerMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isResourceHandlerMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isResourceHandlerMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && RESOURCE_HANDLER_METHODS.contains(methodDescriptor);
    }

    public static boolean isMessageSourceMethod(@Nonnull Method method) {
        return GriffonClassUtils.isMessageSourceMethod(method, false);
    }

    public static boolean isMessageSourceMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isMessageSourceMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isMessageSourceMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && MESSAGE_SOURCE_METHODS.contains(methodDescriptor);
    }

    public static boolean isResourceResolverMethod(@Nonnull Method method) {
        return GriffonClassUtils.isResourceResolverMethod(method, false);
    }

    public static boolean isResourceResolverMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isResourceResolverMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isResourceResolverMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && RESOURCE_RESOLVER_METHODS.contains(methodDescriptor);
    }

    public static boolean isInstanceMethod(@Nonnull Method method) {
        return GriffonClassUtils.isInstanceMethod(method, false);
    }

    public static boolean isInstanceMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isInstanceMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        int n = methodDescriptor.getModifiers();
        return Modifier.isPublic(n) && !Modifier.isAbstract(n) && !Modifier.isStatic(n);
    }

    public static boolean isPlainMethod(@Nonnull Method method) {
        return GriffonClassUtils.isPlainMethod(method, false);
    }

    public static boolean isPlainMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        return GriffonClassUtils.isPlainMethod(MethodDescriptor.forMethod(method, bl));
    }

    public static boolean isPlainMethod(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, ERROR_METHOD_NULL);
        return GriffonClassUtils.isInstanceMethod(methodDescriptor) && !GriffonClassUtils.isBasicMethod(methodDescriptor) && !GriffonClassUtils.isGroovyInjectedMethod(methodDescriptor) && !GriffonClassUtils.isThreadingMethod(methodDescriptor) && !GriffonClassUtils.isArtifactMethod(methodDescriptor) && !GriffonClassUtils.isMvcMethod(methodDescriptor) && !GriffonClassUtils.isEventPublisherMethod(methodDescriptor) && !GriffonClassUtils.isObservableMethod(methodDescriptor) && !GriffonClassUtils.isResourceHandlerMethod(methodDescriptor) && !GriffonClassUtils.isGetterMethod(methodDescriptor) && !GriffonClassUtils.isSetterMethod(methodDescriptor) && !GriffonClassUtils.isContributionMethod(methodDescriptor);
    }

    public static boolean isPropertyOfType(Class<?> clazz, String string, Class<?> clazz2) {
        try {
            Class<?> clazz3 = GriffonClassUtils.getPropertyType(clazz, string);
            return clazz3 != null && clazz3.equals(clazz2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nonnull
    public static Object instantiateClass(@Nonnull Class<?> clazz) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new BeanInstantiationException("Could not create an instance of " + clazz, exception);
        }
    }

    @Nonnull
    public static Object instantiate(@Nonnull Class<?> clazz, @Nullable Object[] objectArray) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        try {
            if (objectArray == null) {
                objectArray = EMPTY_OBJECT_ARRAY;
            }
            int n = objectArray.length;
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
            return clazz.getDeclaredConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new BeanInstantiationException("Could not create an instance of " + clazz, exception);
        }
    }

    @Nullable
    public static Object getPropertyValueOfNewInstance(@Nullable Class<?> clazz, @Nullable String string, Class<?> clazz2) {
        Object object;
        if (clazz == null || GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            object = GriffonClassUtils.instantiateClass(clazz);
        }
        catch (BeanInstantiationException beanInstantiationException) {
            return null;
        }
        return GriffonClassUtils.getPropertyOrStaticPropertyOrFieldValue(object, string);
    }

    public static Object getPropertyValueOfNewInstance(Class<?> clazz, String string) {
        Object object;
        if (clazz == null || GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            object = GriffonClassUtils.instantiateClass(clazz);
        }
        catch (BeanInstantiationException beanInstantiationException) {
            return null;
        }
        return GriffonClassUtils.getPropertyOrStaticPropertyOrFieldValue(object, string);
    }

    public static PropertyDescriptor getPropertyDescriptorForValue(Object object, Object object2) {
        PropertyDescriptor[] propertyDescriptorArray;
        if (object == null || object2 == null) {
            return null;
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = GriffonClassUtils.getPropertyDescriptors(object.getClass())) {
            Object object3;
            if (!GriffonClassUtils.isAssignableOrConvertibleFrom(propertyDescriptor.getPropertyType(), object2.getClass())) continue;
            try {
                object3 = GriffonClassUtils.getReadMethod(propertyDescriptor).invoke(object, (Object[])null);
            }
            catch (Exception exception) {
                throw new RuntimeException("Problem calling readMethod of " + propertyDescriptor, exception);
            }
            if (!object2.equals(object3)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    @Nullable
    public static Class<?> getPropertyType(@Nullable Class<?> clazz, @Nullable String string) {
        if (clazz == null || GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            PropertyDescriptor propertyDescriptor = GriffonClassUtils.getPropertyDescriptor(clazz, string);
            if (propertyDescriptor != null) {
                return propertyDescriptor.getPropertyType();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nonnull
    public static PropertyDescriptor[] getPropertiesOfType(@Nullable Class<?> clazz, @Nullable Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            return new PropertyDescriptor[0];
        }
        HashSet<PropertyDescriptor> hashSet = new HashSet<PropertyDescriptor>();
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = GriffonClassUtils.getPropertyDescriptors(clazz)) {
                Class<?> clazz3 = propertyDescriptor.getPropertyType();
                if (!GriffonClassUtils.isTypeInstanceOfPropertyType(clazz2, clazz3)) continue;
                hashSet.add(propertyDescriptor);
            }
        }
        catch (Exception exception) {
            return new PropertyDescriptor[0];
        }
        return hashSet.toArray(new PropertyDescriptor[hashSet.size()]);
    }

    private static boolean isTypeInstanceOfPropertyType(Class<?> clazz, Class<?> clazz2) {
        return clazz2.isAssignableFrom(clazz) && !clazz2.equals(Object.class);
    }

    public static PropertyDescriptor[] getPropertiesAssignableToType(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            return new PropertyDescriptor[0];
        }
        HashSet<PropertyDescriptor> hashSet = new HashSet<PropertyDescriptor>();
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = GriffonClassUtils.getPropertyDescriptors(clazz)) {
                if (!clazz2.isAssignableFrom(propertyDescriptor.getPropertyType())) continue;
                hashSet.add(propertyDescriptor);
            }
        }
        catch (Exception exception) {
            return new PropertyDescriptor[0];
        }
        return hashSet.toArray(new PropertyDescriptor[hashSet.size()]);
    }

    public static PropertyDescriptor getProperty(Class<?> clazz, String string, Class<?> clazz2) {
        if (clazz == null || string == null || clazz2 == null) {
            return null;
        }
        try {
            PropertyDescriptor propertyDescriptor = GriffonClassUtils.getPropertyDescriptor(clazz, string);
            if (propertyDescriptor.getPropertyType().equals(clazz2)) {
                return propertyDescriptor;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object[] collectionToObjectArray(Collection<?> collection) {
        if (collection == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return collection.toArray(new Object[collection.size()]);
    }

    public static boolean isMatchBetweenPrimitiveAndWrapperTypes(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        Objects.requireNonNull(clazz, "Left type is null!");
        Objects.requireNonNull(clazz2, "Right type is null!");
        return GriffonClassUtils.isMatchBetweenPrimitiveAndWrapperTypes(clazz.getName(), clazz2.getName());
    }

    public static boolean isMatchBetweenPrimitiveAndWrapperTypes(@Nonnull String string, @Nonnull String string2) {
        GriffonNameUtils.requireNonBlank(string, "Left type is null!");
        GriffonNameUtils.requireNonBlank(string2, "Right type is null!");
        String string3 = PRIMITIVE_TYPE_COMPATIBLE_TYPES.get(string);
        return string3 != null && string3.equals(string2);
    }

    @Nullable
    private static Method findDeclaredMethod(@Nonnull Class<?> clazz, @Nonnull String string, Class[] classArray) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_METHOD_NAME_BLANK);
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(string, classArray);
                if (method != null) {
                    return method;
                }
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static boolean isStaticProperty(@Nonnull Class<?> clazz, @Nonnull String string) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_PROPERTY_NAME_BLANK);
        Method method = GriffonClassUtils.findDeclaredMethod(clazz, GriffonClassUtils.getGetterName(string), null);
        if (method != null) {
            return GriffonClassUtils.isPublicStatic(method);
        }
        try {
            Field field = clazz.getDeclaredField(string);
            if (field != null) {
                return GriffonClassUtils.isPublicStatic(field);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isPublicStatic(@Nonnull Method method) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        int n = method.getModifiers();
        return Modifier.isPublic(n) && Modifier.isStatic(n);
    }

    public static boolean isPublicStatic(@Nonnull Field field) {
        Objects.requireNonNull(field, "Argument 'field' must not be null");
        int n = field.getModifiers();
        return Modifier.isPublic(n) && Modifier.isStatic(n);
    }

    @Nonnull
    public static String getGetterName(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_PROPERTY_NAME_BLANK);
        return PROPERTY_GET_PREFIX + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    @Nullable
    public static Object getStaticPropertyValue(@Nonnull Class<?> clazz, @Nonnull String string) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Method method = GriffonClassUtils.findDeclaredMethod(clazz, GriffonClassUtils.getGetterName(string), null);
        try {
            if (method != null) {
                return method.invoke(null, (Object[])null);
            }
            Field field = clazz.getDeclaredField(string);
            if (field != null) {
                return field.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static Object getPropertyOrStaticPropertyOrFieldValue(@Nonnull Object object, @Nonnull String string) {
        Objects.requireNonNull(object, ERROR_OBJECT_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        if (GriffonClassUtils.isReadable(object, string)) {
            try {
                return GriffonClassUtils.getProperty(object, string);
            }
            catch (Exception exception) {
                throw new PropertyException(object, string);
            }
        }
        if (GriffonClassUtils.isPublicField(object, string)) {
            return GriffonClassUtils.getFieldValue(object, string);
        }
        Class<?> clazz = object.getClass();
        if (GriffonClassUtils.isStaticProperty(clazz, string)) {
            return GriffonClassUtils.getStaticPropertyValue(clazz, string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Object getFieldValue(@Nonnull Object object, @Nonnull String string) {
        Class<?> clazz;
        Objects.requireNonNull(object, ERROR_OBJECT_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        for (Class<?> clazz2 = clazz = object.getClass(); clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            Field field = null;
            boolean bl = false;
            try {
                field = clazz2.getDeclaredField(string);
                bl = field.isAccessible();
                field.setAccessible(true);
                Object object2 = field.get(object);
                return object2;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                if (field != null) {
                    field.setAccessible(bl);
                }
            }
        }
        return null;
    }

    @Nullable
    public static Field getField(@Nonnull Object object, @Nonnull String string) {
        Objects.requireNonNull(object, ERROR_OBJECT_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        return GriffonClassUtils.getField(object.getClass(), string);
    }

    @Nullable
    public static Field getField(@Nonnull Class<?> clazz, @Nonnull String string) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        for (Class<?> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            Object var3_3 = null;
            try {
                return clazz2.getDeclaredField(string);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Field[] getAllDeclaredFields(@Nonnull Class<?> clazz) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class<?> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            Field[] fieldArray = clazz2.getDeclaredFields();
            if (fieldArray == null || fieldArray.length <= 0) continue;
            arrayList.addAll(Arrays.asList(fieldArray));
        }
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    public static boolean isPublicField(@Nonnull Object object, @Nonnull String string) {
        Objects.requireNonNull(object, ERROR_OBJECT_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getDeclaredField(string);
            return Modifier.isPublic(field.getModifiers());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }

    public static boolean isPropertyInherited(@Nullable Class<?> clazz, @Nonnull String string) {
        PropertyDescriptor propertyDescriptor;
        if (clazz == null) {
            return false;
        }
        GriffonNameUtils.requireNonBlank(string, ERROR_PROPERTY_NAME_BLANK);
        Class<?> clazz2 = clazz.getSuperclass();
        try {
            propertyDescriptor = GriffonClassUtils.getPropertyDescriptor(clazz2, string);
        }
        catch (Exception exception) {
            throw new PropertyException(clazz2, string, (Throwable)exception);
        }
        return propertyDescriptor != null && propertyDescriptor.getReadMethod() != null;
    }

    @Nonnull
    public static Collection<?> createConcreteCollection(@Nonnull Class<?> clazz) {
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        AbstractCollection abstractCollection = clazz.equals(List.class) ? new ArrayList() : (clazz.equals(SortedSet.class) ? new TreeSet() : new LinkedHashSet());
        return abstractCollection;
    }

    @Nonnull
    public static String getSetterName(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_PROPERTY_NAME_BLANK);
        return PROPERTY_SET_PREFIX + string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static boolean isGetter(@Nullable String string, @Nullable Class[] classArray) {
        if (GriffonNameUtils.isBlank(string) || classArray == null) {
            return false;
        }
        if (classArray.length != 0) {
            return false;
        }
        return string.startsWith(PROPERTY_GET_PREFIX) ? (string = string.substring(3)).length() > 0 && Character.isUpperCase(string.charAt(0)) : string.startsWith(PROPERTY_IS_PREFIX) && (string = string.substring(2)).length() > 0 && Character.isUpperCase(string.charAt(0));
    }

    @Nullable
    public static String getPropertyForGetter(@Nullable String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        if (string.startsWith(PROPERTY_GET_PREFIX)) {
            String string2 = string.substring(3);
            return GriffonClassUtils.convertPropertyName(string2);
        }
        if (string.startsWith(PROPERTY_IS_PREFIX)) {
            String string3 = string.substring(2);
            return GriffonClassUtils.convertPropertyName(string3);
        }
        return null;
    }

    @Nonnull
    private static String convertPropertyName(@Nonnull String string) {
        if (Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        if (Character.isDigit(string.charAt(0))) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    @Nullable
    public static String getPropertyForSetter(@Nullable String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        if (string.startsWith(PROPERTY_SET_PREFIX)) {
            String string2 = string.substring(3);
            return GriffonClassUtils.convertPropertyName(string2);
        }
        return null;
    }

    public static boolean isSetter(@Nullable String string, @Nullable Class[] classArray) {
        if (GriffonNameUtils.isBlank(string) || classArray == null) {
            return false;
        }
        if (string.startsWith(PROPERTY_SET_PREFIX)) {
            if (classArray.length != 1) {
                return false;
            }
            if ((string = string.substring(3)).length() > 0 && Character.isUpperCase(string.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableOrConvertibleFrom(@Nullable Class<?> clazz, @Nullable Class<?> clazz2) {
        if (clazz2 == null || clazz == null) {
            return false;
        }
        if (clazz2.isPrimitive()) {
            Class<?> clazz3 = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(clazz2);
            return clazz3 != null && clazz.isAssignableFrom(clazz3);
        }
        return clazz.isAssignableFrom(clazz2);
    }

    public static boolean getBooleanFromMap(@Nullable String string, @Nullable Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        if (map.containsKey(string)) {
            Object object = map.get(string);
            if (object == null) {
                return false;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return Boolean.valueOf(object.toString());
        }
        return false;
    }

    public static boolean isClassBelowPackage(@Nonnull Class<?> clazz, @Nonnull List<?> list) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        Objects.requireNonNull(list, "Argument 'packageList' must not be null");
        String string = clazz.getPackage().getName();
        for (Object obj : list) {
            if (obj == null || !string.startsWith(obj.toString())) continue;
            return true;
        }
        return false;
    }

    public static void setPropertiesOrFields(@Nonnull Object object, @Nonnull Map<String, Object> map) throws PropertyException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        Objects.requireNonNull(map, ERROR_PROPERTIES_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            GriffonClassUtils.setPropertyOrFieldValue(object, entry.getKey(), entry.getValue());
        }
    }

    public static void setPropertiesOrFieldsNoException(@Nonnull Object object, @Nonnull Map<String, Object> map) {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        Objects.requireNonNull(map, ERROR_PROPERTIES_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                GriffonClassUtils.setPropertyOrFieldValue(object, entry.getKey(), entry.getValue());
            }
            catch (PropertyException propertyException) {}
        }
    }

    public static void setPropertyOrFieldValue(@Nonnull Object object, @Nonnull String string, @Nullable Object object2) throws PropertyException {
        try {
            GriffonClassUtils.setPropertyValue(object, string, object2);
        }
        catch (PropertyException propertyException) {
            try {
                GriffonClassUtils.setFieldValue(object, string, object2);
            }
            catch (FieldException fieldException) {
                throw propertyException;
            }
        }
    }

    public static void setPropertyOrFieldValueNoException(@Nonnull Object object, @Nonnull String string, @Nullable Object object2) {
        try {
            GriffonClassUtils.setPropertyOrFieldValue(object, string, object2);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }

    public static void setFieldsOrProperties(@Nonnull Object object, @Nonnull Map<String, Object> map) throws FieldException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        Objects.requireNonNull(map, ERROR_PROPERTIES_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            GriffonClassUtils.setFieldOrPropertyValue(object, entry.getKey(), entry.getValue());
        }
    }

    public static void setFieldsOrPropertiesNoException(@Nonnull Object object, @Nonnull Map<String, Object> map) {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        Objects.requireNonNull(map, ERROR_PROPERTIES_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                GriffonClassUtils.setFieldOrPropertyValue(object, entry.getKey(), entry.getValue());
            }
            catch (FieldException fieldException) {}
        }
    }

    public static void setFieldOrPropertyValue(@Nonnull Object object, @Nonnull String string, @Nullable Object object2) throws FieldException {
        try {
            GriffonClassUtils.setFieldValue(object, string, object2);
        }
        catch (FieldException fieldException) {
            try {
                GriffonClassUtils.setPropertyValue(object, string, object2);
            }
            catch (PropertyException propertyException) {
                throw fieldException;
            }
        }
    }

    public static void setFields(@Nonnull Object object, @Nonnull Map<String, Object> map) throws FieldException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        Objects.requireNonNull(map, ERROR_FIELDS_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            GriffonClassUtils.setFieldValue(object, entry.getKey(), entry.getValue());
        }
    }

    public static void setFieldsNoException(@Nonnull Object object, @Nonnull Map<String, Object> map) {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        Objects.requireNonNull(map, ERROR_FIELDS_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                GriffonClassUtils.setFieldValue(object, entry.getKey(), entry.getValue());
            }
            catch (FieldException fieldException) {}
        }
    }

    public static void setFieldValue(@Nonnull Object object, @Nonnull String string, @Nullable Object object2) throws FieldException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        try {
            GriffonClassUtils.setField(object, string, object2);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new FieldException(object, string, object2, reflectiveOperationException);
        }
    }

    public static void setFieldValueNoException(@Nonnull Object object, @Nonnull String string, @Nullable Object object2) {
        try {
            GriffonClassUtils.setFieldValue(object, string, object2);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public static void setProperties(@Nonnull Object object, @Nonnull Map<String, Object> map) throws PropertyException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        Objects.requireNonNull(map, ERROR_PROPERTIES_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            GriffonClassUtils.setPropertyValue(object, entry.getKey(), entry.getValue());
        }
    }

    public static void setPropertiesNoException(@Nonnull Object object, @Nonnull Map<String, Object> map) {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        Objects.requireNonNull(map, ERROR_PROPERTIES_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                GriffonClassUtils.setPropertyValue(object, entry.getKey(), entry.getValue());
            }
            catch (PropertyException propertyException) {}
        }
    }

    public static void setPropertyValue(@Nonnull Object object, @Nonnull String string, @Nullable Object object2) throws PropertyException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        try {
            GriffonClassUtils.setProperty(object, string, object2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new PropertyException(object, string, object2, reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyException(object, string, object2, invocationTargetException.getTargetException());
        }
    }

    @Nullable
    public static Object getPropertyValue(@Nonnull Object object, @Nonnull String string) throws PropertyException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        try {
            return GriffonClassUtils.getProperty(object, string);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new PropertyException(object, string, (Throwable)reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyException(object, string, invocationTargetException.getTargetException());
        }
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptor(@Nonnull Object object, @Nonnull String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        return GriffonClassUtils.getPropertyDescriptor(object instanceof Class ? (Class<?>)object : object.getClass(), string);
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptor(@Nonnull Class<?> clazz, @Nonnull String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor[] propertyDescriptorArray;
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = GriffonClassUtils.getPropertyDescriptors(clazz)) {
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    @Nonnull
    public static PropertyDescriptor[] getPropertyDescriptors(@Nonnull Class<?> clazz) {
        BeanInfo beanInfo;
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        PropertyDescriptor[] propertyDescriptorArray = descriptorsCache.get(clazz.getName());
        if (propertyDescriptorArray != null) {
            return propertyDescriptorArray;
        }
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return new PropertyDescriptor[0];
        }
        propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        descriptorsCache.put(clazz.getName(), propertyDescriptorArray);
        return propertyDescriptorArray;
    }

    @Nullable
    public static Method getReadMethod(@Nonnull PropertyDescriptor propertyDescriptor) {
        Objects.requireNonNull(propertyDescriptor, ERROR_DESCRIPTOR_NULL);
        return MethodUtils.getAccessibleMethod(propertyDescriptor.getReadMethod());
    }

    public static boolean isReadable(@Nonnull Object object, @Nonnull String string) {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        try {
            PropertyDescriptor propertyDescriptor = GriffonClassUtils.getPropertyDescriptor(object, string);
            if (propertyDescriptor != null) {
                Method method = GriffonClassUtils.getReadMethod(object.getClass(), propertyDescriptor);
                if (method != null) {
                    method = MethodUtils.getAccessibleMethod(object.getClass(), method);
                }
                return method != null;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    @Nullable
    public static Method getWriteMethod(@Nonnull PropertyDescriptor propertyDescriptor) {
        Objects.requireNonNull(propertyDescriptor, ERROR_DESCRIPTOR_NULL);
        return MethodUtils.getAccessibleMethod(propertyDescriptor.getWriteMethod());
    }

    public static boolean isWritable(@Nonnull Object object, @Nonnull String string) {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        try {
            PropertyDescriptor propertyDescriptor = GriffonClassUtils.getPropertyDescriptor(object, string);
            if (propertyDescriptor != null) {
                Method method = GriffonClassUtils.getWriteMethod(object.getClass(), propertyDescriptor);
                if (method != null) {
                    method = MethodUtils.getAccessibleMethod(object.getClass(), method);
                }
                return method != null;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static void setField(@Nonnull Object object, @Nonnull String string, @Nullable Object object2) throws NoSuchFieldException, IllegalAccessException, FieldException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(string);
                Class<?> clazz2 = field.getType();
                if (object2 != null && !clazz2.isAssignableFrom(object2.getClass())) {
                    object2 = TypeUtils.convertValue(clazz2, object2);
                }
                field.setAccessible(true);
                try {
                    field.set(object, object2);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new FieldException(object, string, object2, illegalArgumentException);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new NoSuchFieldException(string);
    }

    public static void setProperty(@Nonnull Object object, @Nonnull String string, @Nullable Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, PropertyException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        PropertyDescriptor propertyDescriptor = GriffonClassUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "' on class '" + object.getClass() + "'");
        }
        Method method = GriffonClassUtils.getWriteMethod(object.getClass(), propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no setter method in class '" + object.getClass() + "'");
        }
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (object2 != null && !clazz.isAssignableFrom(object2.getClass())) {
            object2 = TypeUtils.convertValue(clazz, object2);
        }
        try {
            method.invoke(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PropertyException(object, string, object2, illegalArgumentException);
        }
    }

    @Nullable
    public static Object getProperty(@Nonnull Object object, @Nonnull String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(object, ERROR_BEAN_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        PropertyDescriptor propertyDescriptor = GriffonClassUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "' on class '" + object.getClass() + "'");
        }
        Method method = GriffonClassUtils.getReadMethod(object.getClass(), propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no getter method in class '" + object.getClass() + "'");
        }
        return method.invoke(object, EMPTY_OBJECT_ARRAY);
    }

    @Nullable
    public static Method getReadMethod(@Nonnull Class<?> clazz, @Nonnull PropertyDescriptor propertyDescriptor) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        Objects.requireNonNull(propertyDescriptor, ERROR_DESCRIPTOR_NULL);
        return MethodUtils.getAccessibleMethod(clazz, propertyDescriptor.getReadMethod());
    }

    @Nullable
    public static Method getWriteMethod(@Nonnull Class<?> clazz, @Nonnull PropertyDescriptor propertyDescriptor) {
        Objects.requireNonNull(clazz, ERROR_CLAZZ_NULL);
        Objects.requireNonNull(propertyDescriptor, ERROR_DESCRIPTOR_NULL);
        return MethodUtils.getAccessibleMethod(clazz, propertyDescriptor.getWriteMethod());
    }

    public static void isTrue(boolean bl, String string) {
        if (bl) {
            throw new IllegalArgumentException(string);
        }
    }

    @Nullable
    public static Object invokeInstanceMethod(@Nonnull Object object, @Nonnull String string) {
        return GriffonClassUtils.invokeInstanceMethod(object, string, EMPTY_ARGS);
    }

    @Nullable
    public static Object invokeInstanceMethod(@Nonnull Object object, @Nonnull String string, Object object2) {
        return GriffonClassUtils.invokeInstanceMethod(object, string, new Object[]{object2});
    }

    @Nullable
    public static Object invokeInstanceMethod(@Nonnull Object object, @Nonnull String string, Object ... objectArray) {
        Objects.requireNonNull(object, ERROR_OBJECT_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_METHOD_NAME_BLANK);
        try {
            return MethodUtils.invokeMethod(object, string, objectArray);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new InstanceMethodInvocationException(object, string, objectArray, reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InstanceMethodInvocationException(object, string, objectArray, invocationTargetException.getTargetException());
        }
    }

    @Nullable
    public static Object invokeExactInstanceMethod(@Nonnull Object object, @Nonnull String string) {
        return GriffonClassUtils.invokeExactInstanceMethod(object, string, EMPTY_ARGS);
    }

    @Nullable
    public static Object invokeExactInstanceMethod(@Nonnull Object object, @Nonnull String string, Object object2) {
        return GriffonClassUtils.invokeExactInstanceMethod(object, string, new Object[]{object2});
    }

    @Nullable
    public static Object invokeExactInstanceMethod(@Nonnull Object object, @Nonnull String string, Object ... objectArray) {
        Objects.requireNonNull(object, ERROR_OBJECT_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_METHOD_NAME_BLANK);
        try {
            return MethodUtils.invokeExactMethod(object, string, objectArray);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new InstanceMethodInvocationException(object, string, objectArray, reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InstanceMethodInvocationException(object, string, objectArray, invocationTargetException.getTargetException());
        }
    }

    @Nullable
    public static Object invokeStaticMethod(@Nonnull Class<?> clazz, @Nonnull String string) {
        return GriffonClassUtils.invokeStaticMethod(clazz, string, EMPTY_ARGS);
    }

    @Nullable
    public static Object invokeStaticMethod(@Nonnull Class<?> clazz, @Nonnull String string, Object object) {
        return GriffonClassUtils.invokeStaticMethod(clazz, string, new Object[]{object});
    }

    @Nullable
    public static Object invokeStaticMethod(@Nonnull Class<?> clazz, @Nonnull String string, Object ... objectArray) {
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_METHOD_NAME_BLANK);
        try {
            return MethodUtils.invokeStaticMethod(clazz, string, objectArray);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new StaticMethodInvocationException(clazz, string, objectArray, reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new StaticMethodInvocationException(clazz, string, objectArray, invocationTargetException.getTargetException());
        }
    }

    @Nullable
    public static Object invokeExactStaticMethod(@Nonnull Class<?> clazz, @Nonnull String string) {
        return GriffonClassUtils.invokeExactStaticMethod(clazz, string, EMPTY_ARGS);
    }

    @Nullable
    public static Object invokeExactStaticMethod(@Nonnull Class<?> clazz, @Nonnull String string, Object object) {
        return GriffonClassUtils.invokeExactStaticMethod(clazz, string, new Object[]{object});
    }

    @Nullable
    public static Object invokeExactStaticMethod(@Nonnull Class<?> clazz, @Nonnull String string, Object ... objectArray) {
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_METHOD_NAME_BLANK);
        try {
            return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new StaticMethodInvocationException(clazz, string, objectArray, reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new StaticMethodInvocationException(clazz, string, objectArray, invocationTargetException.getTargetException());
        }
    }

    private static void addAbbreviation(String string, String string2) {
        abbreviationMap.put(string, string2);
        reverseAbbreviationMap.put(string2, string);
    }

    @Nonnull
    public static String getShortClassName(@Nullable Object object, @Nonnull String string) {
        if (object == null) {
            return string;
        }
        return GriffonClassUtils.getShortClassName(object.getClass());
    }

    @Nonnull
    public static String getShortClassName(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return EMPTY_STRING;
        }
        return GriffonClassUtils.getShortClassName(clazz.getName());
    }

    @Nonnull
    public static String getShortClassName(@Nullable String string) {
        int n;
        if (string == null) {
            return EMPTY_STRING;
        }
        if (string.length() == 0) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith("[")) {
            while (string.charAt(0) == '[') {
                string = string.substring(1);
                stringBuilder.append("[]");
            }
            if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';') {
                string = string.substring(1, string.length() - 1);
            }
        }
        if (reverseAbbreviationMap.containsKey(string)) {
            string = reverseAbbreviationMap.get(string);
        }
        int n2 = string.indexOf(36, (n = string.lastIndexOf(46)) == -1 ? 0 : n + 1);
        String string2 = string.substring(n + 1);
        if (n2 != -1) {
            string2 = string2.replace('$', '.');
        }
        return string2 + stringBuilder;
    }

    @Nonnull
    public static String getPackageName(@Nullable Object object, @Nonnull String string) {
        if (object == null) {
            return string;
        }
        return GriffonClassUtils.getPackageName(object.getClass());
    }

    @Nonnull
    public static String getPackageName(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return EMPTY_STRING;
        }
        return GriffonClassUtils.getPackageName(clazz.getName());
    }

    @Nonnull
    public static String getPackageName(@Nullable String string) {
        int n;
        if (string == null || string.length() == 0) {
            return EMPTY_STRING;
        }
        while (string.charAt(0) == '[') {
            string = string.substring(1);
        }
        if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';') {
            string = string.substring(1);
        }
        if ((n = string.lastIndexOf(46)) == -1) {
            return EMPTY_STRING;
        }
        return string.substring(0, n);
    }

    @Nullable
    public static Class<?>[] convertToTypeArray(@Nullable Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            classArray[i] = object != null ? object.getClass() : null;
        }
        return classArray;
    }

    static {
        MethodDescriptor methodDescriptor;
        int n;
        Object object;
        Object object2;
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_ARGS = EMPTY_OBJECT_ARRAY;
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES = new LinkedHashMap();
        PRIMITIVE_TYPE_COMPATIBLE_TYPES = new LinkedHashMap<String, String>();
        EVENT_HANDLER_PATTERN = Pattern.compile("^on[A-Z][\\w]*$");
        CONTRIBUTION_PATTERN = Pattern.compile("^with[A-Z][a-z0-9_]*[\\w]*$");
        GETTER_PATTERN_1 = Pattern.compile("^get[A-Z][\\w]*$");
        GETTER_PATTERN_2 = Pattern.compile("^is[A-Z][\\w]*$");
        SETTER_PATTERN = Pattern.compile("^set[A-Z][\\w]*$");
        BASIC_METHODS = new TreeSet<MethodDescriptor>();
        ARTIFACT_METHODS = new TreeSet<MethodDescriptor>();
        MVC_METHODS = new TreeSet<MethodDescriptor>();
        THREADING_METHODS = new TreeSet<MethodDescriptor>();
        EVENT_PUBLISHER_METHODS = new TreeSet<MethodDescriptor>();
        OBSERVABLE_METHODS = new TreeSet<MethodDescriptor>();
        RESOURCE_HANDLER_METHODS = new TreeSet<MethodDescriptor>();
        MESSAGE_SOURCE_METHODS = new TreeSet<MethodDescriptor>();
        RESOURCE_RESOLVER_METHODS = new TreeSet<MethodDescriptor>();
        GriffonClassUtils.registerPrimitiveClassPair(Boolean.class, Boolean.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Integer.class, Integer.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Short.class, Short.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Byte.class, Byte.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Character.class, Character.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Long.class, Long.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Float.class, Float.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Double.class, Double.TYPE);
        for (Method method : Object.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method);
            if (BASIC_METHODS.contains(object2)) continue;
            BASIC_METHODS.add((MethodDescriptor)object2);
        }
        try {
            object = GriffonClassUtils.class.getClassLoader().loadClass("groovy.lang.GroovyObject");
            Method[] methodArray = ((Class)object).getMethods();
            n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                object2 = methodArray[i];
                methodDescriptor = MethodDescriptor.forMethod((Method)object2, true);
                if (BASIC_METHODS.contains(methodDescriptor)) continue;
                BASIC_METHODS.add(methodDescriptor);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            object = GriffonClassUtils.class.getClassLoader().loadClass("groovy.lang.GroovyObjectSupport");
            Method[] methodArray = ((Class)object).getMethods();
            n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                object2 = methodArray[i];
                methodDescriptor = MethodDescriptor.forMethod((Method)object2);
                if (BASIC_METHODS.contains(methodDescriptor)) continue;
                BASIC_METHODS.add(methodDescriptor);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (Method method : GriffonArtifact.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (ARTIFACT_METHODS.contains(object2)) continue;
            ARTIFACT_METHODS.add((MethodDescriptor)object2);
        }
        for (Method method : MVCHandler.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (MVC_METHODS.contains(object2)) continue;
            MVC_METHODS.add((MethodDescriptor)object2);
        }
        for (Method method : GriffonMvcArtifact.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (MVC_METHODS.contains(object2)) continue;
            MVC_METHODS.add((MethodDescriptor)object2);
        }
        MVC_METHODS.add(new MethodDescriptor("initUI"));
        MVC_METHODS.add(new MethodDescriptor("invokeAction", new Class[]{String.class, Object[].class}));
        MVC_METHODS.add(new MethodDescriptor("invokeAction", new Class[]{String.class, Object[].class}, 129));
        for (Method method : ThreadingHandler.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (THREADING_METHODS.contains(object2)) continue;
            THREADING_METHODS.add((MethodDescriptor)object2);
        }
        for (Method method : EventPublisher.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (EVENT_PUBLISHER_METHODS.contains(object2)) continue;
            EVENT_PUBLISHER_METHODS.add((MethodDescriptor)object2);
        }
        for (Method method : Observable.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (OBSERVABLE_METHODS.contains(object2)) continue;
            OBSERVABLE_METHODS.add((MethodDescriptor)object2);
        }
        for (Method method : Vetoable.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (OBSERVABLE_METHODS.contains(object2)) continue;
            OBSERVABLE_METHODS.add((MethodDescriptor)object2);
        }
        for (Method method : ResourceHandler.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (RESOURCE_HANDLER_METHODS.contains(object2)) continue;
            RESOURCE_HANDLER_METHODS.add((MethodDescriptor)object2);
        }
        for (Method method : MessageSource.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (MESSAGE_SOURCE_METHODS.contains(object2)) continue;
            MESSAGE_SOURCE_METHODS.add((MethodDescriptor)object2);
        }
        for (Method method : ResourceResolver.class.getMethods()) {
            object2 = MethodDescriptor.forMethod(method, true);
            if (RESOURCE_RESOLVER_METHODS.contains(object2)) continue;
            RESOURCE_RESOLVER_METHODS.add((MethodDescriptor)object2);
        }
        descriptorsCache = new LinkedHashMap<String, PropertyDescriptor[]>();
        PACKAGE_SEPARATOR = String.valueOf('.');
        INNER_CLASS_SEPARATOR = String.valueOf('$');
        abbreviationMap = new HashMap<String, String>();
        reverseAbbreviationMap = new HashMap<String, String>();
        GriffonClassUtils.addAbbreviation("int", "I");
        GriffonClassUtils.addAbbreviation("boolean", "Z");
        GriffonClassUtils.addAbbreviation("float", "F");
        GriffonClassUtils.addAbbreviation("long", "J");
        GriffonClassUtils.addAbbreviation("short", "S");
        GriffonClassUtils.addAbbreviation("byte", "B");
        GriffonClassUtils.addAbbreviation("double", "D");
        GriffonClassUtils.addAbbreviation("char", "C");
    }
}

