/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GriffonNameUtils {
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final String[] KEYWORDS = new String[]{"abstract", "assert", "as", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "enum", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "in", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public static boolean isKeyword(String string) {
        return !GriffonNameUtils.isBlank(string) && Arrays.binarySearch(KEYWORDS, string.toLowerCase(Locale.ENGLISH)) > -1;
    }

    public static String capitalize(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static String uncapitalize(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return string;
        }
        if (string.length() == 1) {
            return String.valueOf(Character.toLowerCase(string.charAt(0)));
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String getSetterName(String string) {
        return PROPERTY_SET_PREFIX + GriffonNameUtils.capitalize(string);
    }

    public static String getGetterName(String string) {
        return PROPERTY_GET_PREFIX + GriffonNameUtils.capitalize(string);
    }

    public static String getClassName(String string, String string2) {
        if (GriffonNameUtils.isBlank(string)) {
            throw new IllegalArgumentException("Argument [logicalName] must not be null or blank");
        }
        String string3 = GriffonNameUtils.capitalize(string);
        if (string2 != null) {
            string3 = string3 + string2;
        }
        return string3;
    }

    public static String getClassNameRepresentation(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("[^\\w\\d]")) {
                String string3 = string2.trim();
                stringBuilder.append(GriffonNameUtils.capitalize(string3));
            }
        }
        return stringBuilder.toString();
    }

    public static String getClassNameForLowerCaseHyphenSeparatedName(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return string;
        }
        if (string.indexOf(45) > -1) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray = string.split("-")) {
                if (string2 == null || string2.length() == 0) continue;
                stringBuilder.append(GriffonNameUtils.capitalize(string2));
            }
            return stringBuilder.toString();
        }
        return GriffonNameUtils.capitalize(string);
    }

    public static String getLogicalName(Class<?> clazz, String string) {
        return GriffonNameUtils.getLogicalName(clazz.getName(), string);
    }

    public static String getLogicalName(String string, String string2) {
        String string3;
        if (!GriffonNameUtils.isBlank(string2) && (string3 = GriffonNameUtils.getShortName(string)).endsWith(string2)) {
            return string3.substring(0, string3.length() - string2.length());
        }
        return string;
    }

    public static String getLogicalPropertyName(String string, String string2) {
        if (!GriffonNameUtils.isBlank(string) && !GriffonNameUtils.isBlank(string2) && string.length() == string2.length() + 1 && string.endsWith(string2)) {
            return string.substring(0, 1).toLowerCase();
        }
        return GriffonNameUtils.getLogicalName(GriffonNameUtils.getPropertyName(string), string2);
    }

    public static String getPropertyName(String string) {
        return GriffonNameUtils.getPropertyNameRepresentation(string);
    }

    public static String getPropertyName(Class<?> clazz) {
        return GriffonNameUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyNameRepresentation(Class<?> clazz) {
        String string = GriffonNameUtils.getShortName(clazz);
        return GriffonNameUtils.getPropertyNameRepresentation(string);
    }

    public static String getPropertyNameRepresentation(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        String string2 = string.substring(0, 1).toLowerCase(Locale.ENGLISH) + string.substring(1);
        if (string2.indexOf(32) > -1) {
            string2 = string2.replaceAll("\\s", "");
        }
        return string2;
    }

    public static String getPropertyNameForLowerCaseHyphenSeparatedName(String string) {
        return GriffonNameUtils.getPropertyName(GriffonNameUtils.getClassNameForLowerCaseHyphenSeparatedName(string));
    }

    public static String getShortName(Class<?> clazz) {
        String string = clazz.getName();
        return GriffonNameUtils.getShortName(string);
    }

    public static String getShortName(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return string;
        }
        int n = string.lastIndexOf(".");
        if (n > -1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    public static String getNaturalName(String string) {
        if (GriffonNameUtils.isBlank(string = GriffonNameUtils.getShortName(string))) {
            return string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        char[] cArray = string.toCharArray();
        for (char c : cArray) {
            String string2;
            if (n >= arrayList.size()) {
                string2 = "";
                arrayList.add(n, string2);
            } else {
                string2 = (String)arrayList.get(n);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && string2.length() == 0) {
                    c = Character.toUpperCase(c);
                } else if (string2.length() > 1 && Character.isUpperCase(string2.charAt(string2.length() - 1))) {
                    string2 = "";
                    arrayList.add(++n, string2);
                }
                arrayList.set(n, string2 + c);
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (n == 0 && string2.length() == 0 || Character.isUpperCase(string2.charAt(string2.length() - 1))) {
                arrayList.set(n, string2 + c);
                continue;
            }
            arrayList.add(++n, String.valueOf(c));
        }
        Object object = new StringBuilder();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ((StringBuilder)object).append(string3);
            if (!iterator.hasNext()) continue;
            ((StringBuilder)object).append(' ');
        }
        return ((StringBuilder)object).toString();
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        for (char c : string.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String requireNonBlank(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public static String requireNonBlank(String string, String string2) {
        if (GriffonNameUtils.isBlank(string)) {
            throw new IllegalArgumentException(string2);
        }
        return string;
    }

    public static String getHyphenatedName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return GriffonNameUtils.getHyphenatedName(clazz.getName());
    }

    public static String getHyphenatedName(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return string;
        }
        if (string.endsWith(".groovy")) {
            string = string.substring(0, string.length() - 7);
        }
        String string2 = GriffonNameUtils.getNaturalName(GriffonNameUtils.getShortName(string));
        return string2.replaceAll("\\s", "-").toLowerCase();
    }

    @Nonnull
    public static String join(@Nonnull Iterable iterable, @Nullable String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (string == null) {
            string = "";
        }
        for (Object t : iterable) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(String.valueOf(t));
        }
        return stringBuilder.toString();
    }

    public static String quote(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return string;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            string = GriffonNameUtils.applyQuotes(string);
            break;
        }
        return string;
    }

    public static String unquote(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            return string;
        }
        if (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static String applyQuotes(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[1030];
        int n2 = 0;
        stringBuilder.append('\"');
        block11: for (int i = 0; i < n; ++i) {
            if (n2 > 1024) {
                stringBuilder.append(cArray2, 0, n2);
                n2 = 0;
            }
            char c2 = c;
            c = cArray[i];
            switch (c) {
                case '\"': 
                case '\\': {
                    cArray2[n2++] = 92;
                    cArray2[n2++] = c;
                    continue block11;
                }
                case '/': {
                    if (c2 == '<') {
                        cArray2[n2++] = 92;
                    }
                    cArray2[n2++] = c;
                    continue block11;
                }
                default: {
                    if (c < ' ') {
                        switch (c) {
                            case '\b': {
                                cArray2[n2++] = 92;
                                cArray2[n2++] = 98;
                                continue block11;
                            }
                            case '\t': {
                                cArray2[n2++] = 92;
                                cArray2[n2++] = 116;
                                continue block11;
                            }
                            case '\n': {
                                cArray2[n2++] = 92;
                                cArray2[n2++] = 110;
                                continue block11;
                            }
                            case '\f': {
                                cArray2[n2++] = 92;
                                cArray2[n2++] = 102;
                                continue block11;
                            }
                            case '\r': {
                                cArray2[n2++] = 92;
                                cArray2[n2++] = 114;
                                continue block11;
                            }
                        }
                        String string2 = "000" + Integer.toHexString(c);
                        int n3 = string2.length();
                        cArray2[n2++] = 92;
                        cArray2[n2++] = 117;
                        cArray2[n2++] = string2.charAt(n3 - 4);
                        cArray2[n2++] = string2.charAt(n3 - 3);
                        cArray2[n2++] = string2.charAt(n3 - 2);
                        cArray2[n2++] = string2.charAt(n3 - 1);
                        continue block11;
                    }
                    cArray2[n2++] = c;
                }
            }
        }
        stringBuilder.append(cArray2, 0, n2);
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

