/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MethodDescriptor
implements Comparable<MethodDescriptor> {
    private final String methodName;
    private final String[] paramTypes;
    private final int hashCode;
    private final int modifiers;
    private static final String[] EMPTY_CLASS_PARAMETERS = new String[0];

    @Nonnull
    public static MethodDescriptor forMethod(@Nonnull Method method) {
        return MethodDescriptor.forMethod(method, false);
    }

    @Nonnull
    public static MethodDescriptor forMethod(@Nonnull Method method, boolean bl) {
        Objects.requireNonNull(method, "Argument 'method' must not be null");
        int n = method.getModifiers();
        if (bl) {
            n -= 1024;
        }
        return new MethodDescriptor(method.getName(), method.getParameterTypes(), n);
    }

    private static boolean areParametersCompatible(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            if (string.equals(string2) || GriffonClassUtils.isMatchBetweenPrimitiveAndWrapperTypes(string, string2)) continue;
            return false;
        }
        return true;
    }

    public MethodDescriptor(@Nonnull String string) {
        this(string, EMPTY_CLASS_PARAMETERS, 1);
    }

    public MethodDescriptor(@Nonnull String string, int n) {
        this(string, EMPTY_CLASS_PARAMETERS, n);
    }

    public MethodDescriptor(@Nonnull String string, @Nonnull Class<?>[] classArray) {
        this(string, classArray, 1);
    }

    public MethodDescriptor(@Nonnull String string, @Nonnull String[] stringArray) {
        this(string, stringArray, 1);
    }

    public MethodDescriptor(@Nonnull String string, @Nonnull Class<?>[] classArray, int n) {
        this.methodName = GriffonNameUtils.requireNonBlank(string, "Argment 'methodName' must not be blank");
        Objects.requireNonNull(classArray, "Argument 'paramTypes' must not be null");
        this.paramTypes = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            this.paramTypes[i] = classArray[i].getName();
        }
        this.modifiers = n;
        this.hashCode = 31 * string.hashCode() + n;
    }

    public MethodDescriptor(@Nonnull String string, @Nonnull String[] stringArray, int n) {
        this.methodName = GriffonNameUtils.requireNonBlank(string, "Argment 'methodName' must not be blank");
        Objects.requireNonNull(stringArray, "Argument 'paramTypes' must not be null");
        this.paramTypes = Arrays.copyOf(stringArray, stringArray.length);
        this.modifiers = n;
        this.hashCode = 31 * string.hashCode() + n;
    }

    @Nonnull
    public String getName() {
        return this.methodName;
    }

    @Nonnull
    public String[] getParameterTypes() {
        return this.paramTypes;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor methodDescriptor = (MethodDescriptor)object;
        return this.methodName.equals(methodDescriptor.methodName) && this.modifiers == methodDescriptor.modifiers && MethodDescriptor.areParametersCompatible(this.paramTypes, methodDescriptor.paramTypes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Modifier.toString(this.modifiers)).append(" ");
        stringBuilder.append(this.methodName).append("(");
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.paramTypes[i]);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(MethodDescriptor methodDescriptor) {
        int n = this.methodName.compareTo(methodDescriptor.methodName);
        if (n != 0) {
            return n;
        }
        n = this.modifiers - methodDescriptor.modifiers;
        if (n != 0) {
            return n;
        }
        n = this.paramTypes.length - methodDescriptor.paramTypes.length;
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < this.paramTypes.length; ++i) {
            n = this.paramTypes[i].compareTo(methodDescriptor.paramTypes[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public boolean matches(@Nonnull MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, "Argument 'methodDescriptor' must not be null");
        if (!this.methodName.equals(methodDescriptor.methodName) || this.modifiers != methodDescriptor.modifiers || this.paramTypes.length != methodDescriptor.paramTypes.length) {
            return false;
        }
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Class<?> clazz = this.loadClass(this.paramTypes[i]);
            Class<?> clazz2 = this.loadClass(methodDescriptor.paramTypes[i]);
            if (clazz == null || clazz2 == null || GriffonClassUtils.isAssignableOrConvertibleFrom(clazz, clazz2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Class<?> loadClass(@Nonnull String string) {
        try {
            return Class.forName(string, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (GriffonClassUtils.PRIMITIVE_TYPE_COMPATIBLE_TYPES.containsKey(string)) {
                try {
                    string = GriffonClassUtils.PRIMITIVE_TYPE_COMPATIBLE_TYPES.get(string);
                    return Class.forName(string, true, this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    return null;
                }
            }
            return null;
        }
    }
}

