/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class MethodUtils {
    private static boolean CACHE_METHODS = true;
    private static final Class[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map cache = Collections.synchronizedMap(new WeakHashMap());

    public static synchronized void setCacheMethods(boolean bl) {
        CACHE_METHODS = bl;
        if (!CACHE_METHODS) {
            MethodUtils.clearCache();
        }
    }

    public static synchronized int clearCache() {
        int n = cache.size();
        cache.clear();
        return n;
    }

    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeMethod(object, string, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : Object.class;
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = EMPTY_CLASS_PARAMETERS;
        }
        if (objectArray == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeExactMethod(object, string, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : Object.class;
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        if (classArray == null) {
            classArray = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactStaticMethod(Class clazz, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        if (classArray == null) {
            classArray = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getAccessibleMethod(clazz, string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return method.invoke(null, objectArray);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object};
        return MethodUtils.invokeStaticMethod(clazz, string, objectArray);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : Object.class;
        }
        return MethodUtils.invokeStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = EMPTY_CLASS_PARAMETERS;
        }
        if (objectArray == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(clazz, string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return method.invoke(null, objectArray);
    }

    public static Object invokeExactStaticMethod(Class clazz, String string, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object};
        return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray);
    }

    public static Object invokeExactStaticMethod(Class clazz, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : Object.class;
        }
        return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return MethodUtils.getAccessibleMethod(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, true);
            Method method = MethodUtils.getCachedMethod(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = MethodUtils.getAccessibleMethod(clazz, clazz.getMethod(string, classArray));
            MethodUtils.cacheMethod(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        return MethodUtils.getAccessibleMethod(method.getDeclaringClass(), method);
    }

    public static Method getAccessibleMethod(Class clazz, Method method) {
        Class[] classArray;
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        boolean bl = true;
        if (clazz == null) {
            clazz = method.getDeclaringClass();
        } else {
            bl = clazz.equals(method.getDeclaringClass());
            if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz.getName() + " is not assignable from " + method.getDeclaringClass().getName());
            }
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            if (!bl && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                MethodUtils.setMethodAccessible(method);
            }
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class clazz, String string, Class[] classArray) {
        for (Class clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {
                return clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class[] classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                if (!Modifier.isPublic(classArray2[i].getModifiers())) continue;
                try {
                    method = classArray2[i].getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null) {
                    return method;
                }
                method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[i], string, classArray);
                if (method == null) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class clazz, String string, Class[] classArray) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, false);
        try {
            Method method = MethodUtils.getCachedMethod(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = clazz.getMethod(string, classArray);
            MethodUtils.setMethodAccessible(method);
            MethodUtils.cacheMethod(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            int n = classArray.length;
            Method method = null;
            Method[] methodArray = clazz.getMethods();
            float f = Float.MAX_VALUE;
            float f2 = Float.MAX_VALUE;
            int n2 = methodArray.length;
            for (int i = 0; i < n2; ++i) {
                Method method2;
                Class<?>[] classArray2;
                int n3;
                if (!methodArray[i].getName().equals(string) || (n3 = (classArray2 = methodArray[i].getParameterTypes()).length) != n) continue;
                boolean bl = true;
                for (int j = 0; j < n3; ++j) {
                    if (MethodUtils.isAssignmentCompatible(classArray2[j], classArray[j])) continue;
                    bl = false;
                    break;
                }
                if (!bl || (method2 = MethodUtils.getAccessibleMethod(clazz, methodArray[i])) == null) continue;
                MethodUtils.setMethodAccessible(method2);
                f2 = MethodUtils.getTotalTransformationCost(classArray, method2.getParameterTypes());
                if (!(f2 < f)) continue;
                method = method2;
                f = f2;
            }
            if (method != null) {
                MethodUtils.cacheMethod(methodDescriptor, method);
            }
            return method;
        }
    }

    private static void setMethodAccessible(Method method) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static float getTotalTransformationCost(Class[] classArray, Class[] classArray2) {
        float f = 0.0f;
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            Class clazz2 = classArray2[i];
            f += MethodUtils.getObjectTransformationCost(clazz, clazz2);
        }
        return f;
    }

    private static float getObjectTransformationCost(Class clazz, Class clazz2) {
        float f = 0.0f;
        while (clazz2 != null && !clazz2.equals(clazz)) {
            if (clazz2.isInterface() && MethodUtils.isAssignmentCompatible(clazz2, clazz)) {
                f += 0.25f;
                break;
            }
            f += 1.0f;
            clazz2 = clazz2.getSuperclass();
        }
        if (clazz2 == null) {
            f += 1.5f;
        }
        return f;
    }

    public static boolean isAssignmentCompatible(Class<?> clazz, Class<?> clazz2) {
        Class clazz3;
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive() && (clazz3 = MethodUtils.getPrimitiveWrapper(clazz)) != null) {
            return clazz3.equals(clazz2);
        }
        return false;
    }

    public static Class getPrimitiveWrapper(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        return null;
    }

    public static Class getPrimitiveType(Class clazz) {
        if (Boolean.class.equals((Object)clazz)) {
            return Boolean.TYPE;
        }
        if (Float.class.equals((Object)clazz)) {
            return Float.TYPE;
        }
        if (Long.class.equals((Object)clazz)) {
            return Long.TYPE;
        }
        if (Integer.class.equals((Object)clazz)) {
            return Integer.TYPE;
        }
        if (Short.class.equals((Object)clazz)) {
            return Short.TYPE;
        }
        if (Byte.class.equals((Object)clazz)) {
            return Byte.TYPE;
        }
        if (Double.class.equals((Object)clazz)) {
            return Double.TYPE;
        }
        if (Character.class.equals((Object)clazz)) {
            return Character.TYPE;
        }
        return null;
    }

    public static Class toNonPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            Class clazz2 = MethodUtils.getPrimitiveWrapper(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }
        return clazz;
    }

    private static Method getCachedMethod(MethodDescriptor methodDescriptor) {
        Reference reference;
        if (CACHE_METHODS && (reference = (Reference)cache.get(methodDescriptor)) != null) {
            return (Method)reference.get();
        }
        return null;
    }

    private static void cacheMethod(MethodDescriptor methodDescriptor, Method method) {
        if (CACHE_METHODS && method != null) {
            cache.put(methodDescriptor, new WeakReference<Method>(method));
        }
    }

    public static Object invokeSafe(Method method, Object object, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static class MethodDescriptor {
        private Class cls;
        private String methodName;
        private Class[] paramTypes;
        private boolean exact;
        private int hashCode;

        public MethodDescriptor(Class clazz, String string, Class[] classArray, boolean bl) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class must not be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Method Name must not be null");
            }
            if (classArray == null) {
                classArray = EMPTY_CLASS_PARAMETERS;
            }
            this.cls = clazz;
            this.methodName = string;
            this.paramTypes = classArray;
            this.exact = bl;
            this.hashCode = string.length();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)object;
            return this.exact == methodDescriptor.exact && this.methodName.equals(methodDescriptor.methodName) && this.cls.equals(methodDescriptor.cls) && Arrays.equals(this.paramTypes, methodDescriptor.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

