/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.core.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLoaderUtils.class);
    private static final String JAR_FILE_SCHEME = "jar:file:";

    private ServiceLoaderUtils() {
    }

    public static boolean load(@Nonnull ClassLoader classLoader, @Nonnull String string, @Nonnull Class<?> clazz, @Nonnull LineProcessor lineProcessor) {
        Enumeration<URL> enumeration;
        Objects.requireNonNull(classLoader, "Argument 'classLoader' must not be null");
        GriffonNameUtils.requireNonBlank(string, "Argument 'path' must not be blank");
        Objects.requireNonNull(clazz, "Argument 'type' must not be null");
        Objects.requireNonNull(lineProcessor, "Argument 'processor' must not be null");
        String string2 = string.endsWith("/") ? string : string + "/";
        try {
            enumeration = classLoader.getResources(string2 + clazz.getName());
        }
        catch (IOException iOException) {
            LOG.error(iOException.getClass().getName() + " error loading resources of type \"" + clazz.getName() + "\" from \"" + string2 + "\".");
            return false;
        }
        if (enumeration == null) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            LOG.debug("Reading {} definitions from {}", (Object)clazz.getName(), (Object)uRL);
            try {
                Scanner scanner = new Scanner(uRL.openStream());
                Throwable throwable = null;
                try {
                    while (scanner.hasNextLine()) {
                        String string3 = scanner.nextLine();
                        if (string3.startsWith("#") || GriffonNameUtils.isBlank(string3)) continue;
                        lineProcessor.process(classLoader, clazz, string3);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scanner == null) continue;
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    scanner.close();
                }
            }
            catch (IOException iOException) {
                LOG.warn("Could not load " + clazz.getName() + " definitions from " + uRL, GriffonExceptionHandler.sanitize(iOException));
            }
        }
        return true;
    }

    public static boolean load(@Nonnull ClassLoader classLoader, @Nonnull String string, @Nonnull PathFilter pathFilter, @Nonnull ResourceProcessor resourceProcessor) {
        Enumeration<URL> enumeration;
        Objects.requireNonNull(classLoader, "Argument 'classLoader' must not be null");
        GriffonNameUtils.requireNonBlank(string, "Argument 'path' must not be blank");
        Objects.requireNonNull(pathFilter, "Argument 'pathFilter' must not be blank");
        Objects.requireNonNull(resourceProcessor, "Argument 'processor' must not be null");
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            LOG.debug(iOException.getClass().getName() + " error loading resources from \"" + string + "\".");
            return false;
        }
        if (enumeration == null) {
            return false;
        }
        block10: while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            LOG.debug("Reading definitions from " + uRL);
            switch (uRL.getProtocol()) {
                case "file": {
                    ServiceLoaderUtils.handleFileResource(uRL, classLoader, string, pathFilter, resourceProcessor);
                    continue block10;
                }
                case "jar": {
                    ServiceLoaderUtils.handleJarResource(uRL, classLoader, string, pathFilter, resourceProcessor);
                    continue block10;
                }
            }
            LOG.warn("Could not load definitions from " + uRL);
        }
        return true;
    }

    private static void handleFileResource(@Nonnull URL uRL, @Nonnull ClassLoader classLoader, @Nonnull String string, @Nonnull PathFilter pathFilter, @Nonnull ResourceProcessor resourceProcessor) {
        try {
            File file = new File(uRL.toURI());
            for (File file2 : file.listFiles()) {
                if (!pathFilter.accept(file2.getName())) continue;
                try (Scanner scanner = new Scanner(file2);){
                    while (scanner.hasNextLine()) {
                        String string2 = scanner.nextLine();
                        if (string2.startsWith("#") || GriffonNameUtils.isBlank(string2)) continue;
                        resourceProcessor.process(classLoader, string2);
                    }
                }
                catch (IOException iOException) {
                    LOG.warn("An error occurred while loading resources from " + file2.getAbsolutePath(), GriffonExceptionHandler.sanitize(iOException));
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.warn("An error occurred while loading resources from " + uRL, GriffonExceptionHandler.sanitize(uRISyntaxException));
        }
    }

    private static void handleJarResource(@Nonnull URL uRL, @Nonnull ClassLoader classLoader, @Nonnull String string, @Nonnull PathFilter pathFilter, @Nonnull ResourceProcessor resourceProcessor) {
        block16: {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (!(uRLConnection instanceof JarURLConnection)) break block16;
                JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().startsWith(string) || !pathFilter.accept(jarEntry.getName())) continue;
                    try {
                        Scanner scanner = new Scanner(jarFile.getInputStream(jarEntry));
                        Throwable throwable = null;
                        try {
                            while (scanner.hasNextLine()) {
                                String string2 = scanner.nextLine();
                                if (string2.startsWith("#") || GriffonNameUtils.isBlank(string2)) continue;
                                resourceProcessor.process(classLoader, string2);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (scanner == null) continue;
                            if (throwable != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            scanner.close();
                        }
                    }
                    catch (IOException iOException) {
                        LOG.warn("An error occurred while loading resources from " + jarEntry.getName(), GriffonExceptionHandler.sanitize(iOException));
                    }
                }
            }
            catch (IOException iOException) {
                LOG.warn("An error occurred while loading resources from " + uRL, GriffonExceptionHandler.sanitize(iOException));
            }
        }
    }

    public static interface ResourceProcessor {
        public void process(@Nonnull ClassLoader var1, @Nonnull String var2);
    }

    public static interface LineProcessor {
        public void process(@Nonnull ClassLoader var1, @Nonnull Class<?> var2, @Nonnull String var3);
    }

    public static interface PathFilter {
        public boolean accept(@Nonnull String var1);
    }
}

