/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.core.editors.ExtendedPropertyEditor;
import griffon.core.editors.PropertyEditorResolver;
import griffon.exceptions.GriffonException;
import griffon.exceptions.TypeConversionException;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TypeUtils {
    private static final String ERROR_VALUE_NULL = "Argument 'value' must not be null";

    private TypeUtils() {
    }

    public static boolean castToBoolean(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return "true".equalsIgnoreCase(String.valueOf(object));
    }

    public static char castToChar(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return String.valueOf(object).charAt(0);
    }

    public static byte castToByte(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        return Byte.valueOf(String.valueOf(object));
    }

    public static short castToShort(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        return Short.valueOf(String.valueOf(object));
    }

    public static int castToInt(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return Integer.valueOf(String.valueOf(object));
    }

    public static long castToLong(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.valueOf(String.valueOf(object));
    }

    public static float castToFloat(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return Float.valueOf(String.valueOf(object)).floatValue();
    }

    public static double castToDouble(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.valueOf(String.valueOf(object));
    }

    public static BigInteger castToBigInteger(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        return new BigInteger(String.valueOf(object));
    }

    public static BigDecimal castToBigDecimal(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        return new BigDecimal(String.valueOf(object));
    }

    @Nullable
    public static Number castToNumber(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new IllegalArgumentException("Don't know how to cast '" + object + "' to " + Number.class.getName());
    }

    public static boolean castToBoolean(@Nullable Object object, boolean bl) {
        return object == null ? bl : TypeUtils.castToBoolean(object);
    }

    public static char castToChar(@Nullable Object object, char c) {
        return object == null ? c : TypeUtils.castToChar(object);
    }

    public static byte castToByte(@Nullable Object object, byte by) {
        return object == null ? by : TypeUtils.castToByte(object);
    }

    public static short castToShort(@Nullable Object object, short s) {
        return object == null ? s : TypeUtils.castToShort(object);
    }

    public static int castToInt(@Nullable Object object, int n) {
        return object == null ? n : TypeUtils.castToInt(object);
    }

    public static long castToLong(@Nullable Object object, long l) {
        return object == null ? l : TypeUtils.castToLong(object);
    }

    public static float castToFloat(@Nullable Object object, float f) {
        return object == null ? f : TypeUtils.castToFloat(object);
    }

    public static double castToDouble(@Nullable Object object, double d) {
        return object == null ? d : TypeUtils.castToDouble(object);
    }

    @Nullable
    public static Number castToNumber(@Nullable Object object, @Nullable Number number) {
        return object == null ? (Number)number : (Number)TypeUtils.castToNumber(object);
    }

    @Nullable
    public static BigInteger castToBigInteger(@Nullable Object object, @Nullable BigInteger bigInteger) {
        return object == null ? bigInteger : TypeUtils.castToBigInteger(object);
    }

    @Nullable
    public static BigDecimal castToBigDecimal(@Nullable Object object, @Nullable BigDecimal bigDecimal) {
        return object == null ? bigDecimal : TypeUtils.castToBigDecimal(object);
    }

    @Nonnull
    public static <T> T convertValue(@Nonnull Class<T> clazz, @Nonnull Object object) {
        return TypeUtils.convertValue(clazz, object, null);
    }

    @Nonnull
    public static <T> T convertValue(@Nonnull Class<T> clazz, @Nonnull Object object, @Nullable String string) {
        PropertyEditor propertyEditor;
        Objects.requireNonNull(clazz, "Argument 'targetType' must not be null");
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (null == string) {
            if (TypeUtils.isBoolean(clazz) && TypeUtils.isBoolean(object.getClass())) {
                return (T)object;
            }
            if (TypeUtils.isCharacter(clazz) && TypeUtils.isCharacter(object.getClass())) {
                return (T)object;
            }
            if (TypeUtils.isNumber(clazz) && TypeUtils.isNumber(object.getClass())) {
                if (TypeUtils.isByte(clazz)) {
                    return (T)Byte.valueOf(TypeUtils.castToByte(object));
                }
                if (TypeUtils.isShort(clazz)) {
                    return (T)Short.valueOf(TypeUtils.castToShort(object));
                }
                if (TypeUtils.isInteger(clazz)) {
                    return (T)Integer.valueOf(TypeUtils.castToInt(object));
                }
                if (TypeUtils.isLong(clazz)) {
                    return (T)Long.valueOf(TypeUtils.castToLong(object));
                }
                if (TypeUtils.isFloat(clazz)) {
                    return (T)Float.valueOf(TypeUtils.castToFloat(object));
                }
                if (TypeUtils.isDouble(clazz)) {
                    return (T)Double.valueOf(TypeUtils.castToDouble(object));
                }
                if (TypeUtils.isBigInteger(clazz)) {
                    return clazz.cast(BigInteger.valueOf(((Number)object).longValue()));
                }
                if (TypeUtils.isBigDecimal(clazz)) {
                    return clazz.cast(BigDecimal.valueOf(((Number)object).doubleValue()));
                }
            }
        }
        if ((propertyEditor = TypeUtils.resolveTargetPropertyEditor(clazz, string)) != null) {
            propertyEditor.setValue(object);
            return (T)propertyEditor.getValue();
        }
        throw new TypeConversionException(object, clazz);
    }

    @Nullable
    private static <T> PropertyEditor resolveTargetPropertyEditor(@Nonnull Class<T> clazz, @Nullable String string) {
        PropertyEditor propertyEditor = TypeUtils.doResolveTargetPropertyEditor(clazz);
        if (propertyEditor instanceof ExtendedPropertyEditor && !GriffonNameUtils.isBlank(string)) {
            ((ExtendedPropertyEditor)propertyEditor).setFormat(string);
        }
        return propertyEditor;
    }

    @Nullable
    private static <T> PropertyEditor doResolveTargetPropertyEditor(@Nonnull Class<T> clazz) {
        return PropertyEditorResolver.findEditor(clazz);
    }

    public static boolean isBoolean(@Nonnull Class<?> clazz) {
        return Boolean.class == clazz || Boolean.TYPE == clazz;
    }

    public static boolean isCharacter(@Nonnull Class<?> clazz) {
        return Character.class == clazz || Character.TYPE == clazz;
    }

    public static boolean isByte(@Nonnull Class<?> clazz) {
        return Byte.class == clazz || Byte.TYPE == clazz;
    }

    public static boolean isShort(@Nonnull Class<?> clazz) {
        return Short.class == clazz || Short.TYPE == clazz;
    }

    public static boolean isInteger(@Nonnull Class<?> clazz) {
        return Integer.class == clazz || Integer.TYPE == clazz;
    }

    public static boolean isLong(@Nonnull Class<?> clazz) {
        return Long.class == clazz || Long.TYPE == clazz;
    }

    public static boolean isFloat(@Nonnull Class<?> clazz) {
        return Float.class == clazz || Float.TYPE == clazz;
    }

    public static boolean isDouble(@Nonnull Class<?> clazz) {
        return Double.class == clazz || Double.TYPE == clazz;
    }

    public static boolean isBigInteger(@Nonnull Class<?> clazz) {
        return BigInteger.class == clazz;
    }

    public static boolean isBigDecimal(@Nonnull Class<?> clazz) {
        return BigDecimal.class == clazz;
    }

    public static boolean isNumber(@Nonnull Class<?> clazz) {
        return Number.class == clazz || TypeUtils.isByte(clazz) || TypeUtils.isShort(clazz) || TypeUtils.isInteger(clazz) || TypeUtils.isLong(clazz) || TypeUtils.isFloat(clazz) || TypeUtils.isDouble(clazz) || TypeUtils.isBigInteger(clazz) || TypeUtils.isBigDecimal(clazz);
    }

    public static boolean equals(@Nullable Object object, @Nullable Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (clazz.isArray() && clazz2.isArray()) {
            return TypeUtils.arrayEqual(object, object2);
        }
        if (clazz.isArray() && clazz.getComponentType().isPrimitive()) {
            object = TypeUtils.primitiveArrayToList(object);
        }
        if (clazz2.isArray() && clazz2.getComponentType().isPrimitive()) {
            object2 = TypeUtils.primitiveArrayToList(object2);
        }
        if (object instanceof Object[] && object2 instanceof List) {
            return TypeUtils.equals((Object[])object, (List)object2);
        }
        if (object instanceof List && object2 instanceof Object[]) {
            return TypeUtils.equals((List)object, (Object[])object2);
        }
        if (object instanceof List && object2 instanceof List) {
            return TypeUtils.equals((List)object, (List)object2);
        }
        if (object instanceof Map.Entry && object2 instanceof Map.Entry) {
            Object v;
            Object v2;
            Object k;
            Object k2 = ((Map.Entry)object).getKey();
            return (k2 == (k = ((Map.Entry)object2).getKey()) || k2 != null && k2.equals(k)) && ((v2 = ((Map.Entry)object).getValue()) == (v = ((Map.Entry)object2).getValue()) || v2 != null && TypeUtils.equals(v2, v));
        }
        return object.equals(object2);
    }

    public static boolean arrayEqual(@Nullable Object object, @Nullable Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (Array.getLength(object) != Array.getLength(object2)) {
            return false;
        }
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object object3;
            Object object4 = Array.get(object, i);
            if (TypeUtils.equals(object4, object3 = Array.get(object2, i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2 == null;
        }
        if (nArray2 == null) {
            return false;
        }
        if (nArray == nArray2) {
            return true;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] objectArray, List list) {
        return TypeUtils.doEquals(objectArray, list);
    }

    public static boolean equals(List list, Object[] objectArray) {
        return TypeUtils.doEquals(objectArray, list);
    }

    private static boolean doEquals(Object[] objectArray, List<?> list) {
        if (objectArray == null) {
            return list == null;
        }
        if (list == null) {
            return false;
        }
        if (objectArray.length != list.size()) {
            return false;
        }
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Object object = objectArray[i];
            Object obj = list.get(i);
            if (!(object == null ? obj != null : !TypeUtils.equals(object, obj))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(List<T> list, List<T> list2) {
        if (list == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        if (list == list2) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<T> iterator = list.iterator();
        Iterator<T> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            T t2 = iterator2.next();
            if (!(t == null ? t2 != null : !TypeUtils.equals(t, t2))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(Set<T> set, Set<T> set2) {
        if (set == null) {
            return set2 == null;
        }
        if (set2 == null) {
            return false;
        }
        if (set == set2) {
            return true;
        }
        if (set.size() != set2.size()) {
            return false;
        }
        Iterator<T> iterator = set.iterator();
        HashSet<T> hashSet = new HashSet<T>(set2);
        while (iterator.hasNext()) {
            T t = iterator.next();
            Iterator iterator2 = hashSet.iterator();
            Object var6_6 = null;
            boolean bl = false;
            while (iterator2.hasNext() && var6_6 == null) {
                Object e = iterator2.next();
                if (!TypeUtils.equals(t, e)) continue;
                var6_6 = e;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            hashSet.remove(var6_6);
        }
        return hashSet.size() == 0;
    }

    public static <K, V> boolean equals(Map<K, V> map, Map<K, V> map2) {
        if (map == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map == map2) {
            return true;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        if (!map.keySet().equals(map2.keySet())) {
            return false;
        }
        for (K k : map.keySet()) {
            if (TypeUtils.equals(map.get(k), map2.get(k))) continue;
            return false;
        }
        return true;
    }

    public static List primitiveArrayToList(Object object) {
        int n = Array.getLength(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 != null && object2.getClass().isArray() && object2.getClass().getComponentType().isPrimitive()) {
                object2 = TypeUtils.primitiveArrayToList(object2);
            }
            arrayList.add(object2);
        }
        return arrayList;
    }

    private static boolean isValidCharacterString(Object object) {
        String string;
        return object instanceof String && (string = (String)object).length() == 1;
    }

    public static int compareTo(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Comparable) {
            if (object instanceof Number) {
                if (TypeUtils.isValidCharacterString(object2)) {
                    return TypeUtils.compareTo((Number)object, Character.valueOf(TypeUtils.castToChar(object2)));
                }
                if (object2 instanceof Character || object2 instanceof Number) {
                    return TypeUtils.compareTo((Number)object, TypeUtils.castToNumber(object2));
                }
            } else if (object instanceof Character) {
                if (TypeUtils.isValidCharacterString(object2)) {
                    return TypeUtils.compareTo((Character)object, Character.valueOf(TypeUtils.castToChar(object2)));
                }
                if (object2 instanceof Number) {
                    return TypeUtils.compareTo((Character)object, (Number)object2);
                }
            } else if (object2 instanceof Number) {
                if (TypeUtils.isValidCharacterString(object)) {
                    return TypeUtils.compareTo(Character.valueOf(TypeUtils.castToChar(object)), (Number)object2);
                }
            } else {
                if (object instanceof String && object2 instanceof Character) {
                    return ((String)object).compareTo(object2.toString());
                }
                if (object instanceof CharSequence && object2 instanceof CharSequence) {
                    return String.valueOf(object).compareTo(String.valueOf(object2));
                }
            }
            if (object.getClass().isAssignableFrom(object2.getClass()) || object2.getClass() != Object.class && object2.getClass().isAssignableFrom(object.getClass()) || object instanceof CharSequence && object2 instanceof CharSequence) {
                Comparable comparable = (Comparable)object;
                return comparable.compareTo(object2);
            }
        }
        throw new GriffonException("Cannot compare " + object.getClass().getName() + " with value '" + object + "' and " + object2.getClass().getName() + " with value '" + object2 + "'");
    }

    public static int compareTo(Character c, Number number) {
        return TypeUtils.compareTo((Number)c.charValue(), number);
    }

    public static int compareTo(Number number, Character c) {
        return TypeUtils.compareTo(number, (Number)c.charValue());
    }

    public static int compareTo(Character c, Character c2) {
        return TypeUtils.compareTo((Number)c.charValue(), c2);
    }

    public static int compareTo(Number number, Number number2) {
        if (TypeUtils.isFloatingPoint(number) || TypeUtils.isFloatingPoint(number2)) {
            return Double.compare(number.doubleValue(), number2.doubleValue());
        }
        if (TypeUtils.isBigDecimal(number) || TypeUtils.isBigDecimal(number2)) {
            return TypeUtils.castToBigDecimal(number).compareTo(TypeUtils.castToBigDecimal(number2));
        }
        if (TypeUtils.isBigInteger(number) || TypeUtils.isBigInteger(number2)) {
            return TypeUtils.castToBigInteger(number).compareTo(TypeUtils.castToBigInteger(number2));
        }
        if (TypeUtils.isLong(number) || TypeUtils.isLong(number2)) {
            return Long.compare(number.longValue(), number2.longValue());
        }
        return Integer.compare(number.intValue(), number2.intValue());
    }

    public static boolean isFloatingPoint(Number number) {
        return number instanceof Double || number instanceof Float;
    }

    public static boolean isInteger(Number number) {
        return number instanceof Integer;
    }

    public static boolean isLong(Number number) {
        return number instanceof Long;
    }

    public static boolean isBigDecimal(Number number) {
        return number instanceof BigDecimal;
    }

    public static boolean isBigInteger(Number number) {
        return number instanceof BigInteger;
    }
}

