/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ApplicationBootstrapper;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.core.artifact.GriffonService;
import griffon.core.env.GriffonEnvironment;
import griffon.core.injection.Binding;
import griffon.core.injection.Injector;
import griffon.core.injection.InjectorFactory;
import griffon.core.injection.Key;
import griffon.core.injection.Module;
import griffon.util.AnnotationUtils;
import griffon.util.GriffonClassUtils;
import griffon.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.codehaus.griffon.runtime.core.DefaultApplicationBootstrapper;
import org.codehaus.griffon.runtime.core.DefaultApplicationModule;
import org.codehaus.griffon.runtime.core.injection.AbstractModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplicationBootstrapper
implements ApplicationBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApplicationBootstrapper.class);
    private static final String INJECTOR = "injector";
    private static final String GRIFFON_PATH = "META-INF/griffon";
    private static final String PROPERTIES = ".properties";
    protected final GriffonApplication application;

    public AbstractApplicationBootstrapper(@Nonnull GriffonApplication griffonApplication) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
    }

    @Override
    public void bootstrap() throws Exception {
        LOG.info("Griffon {}", (Object)GriffonEnvironment.getGriffonVersion());
        LOG.info("Build: {}", (Object)GriffonEnvironment.getBuildDateTime());
        LOG.info("Revision: {}", (Object)GriffonEnvironment.getBuildRevision());
        LOG.info("JVM: {}", (Object)GriffonEnvironment.getJvmVersion());
        LOG.info("OS: {}", (Object)GriffonEnvironment.getOsVersion());
        LOG.debug("Creating module bindings");
        Iterable<Binding<?>> iterable = this.createBindings();
        if (LOG.isTraceEnabled()) {
            for (Binding<?> binding : iterable) {
                LOG.trace(binding.toString());
            }
        }
        LOG.debug("Creating application injector");
        this.createInjector(iterable);
    }

    @Override
    public void run() {
        this.application.initialize();
        this.application.startup();
        this.application.ready();
    }

    @Nonnull
    protected Iterable<Binding<?>> createBindings() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<Module> arrayList = new ArrayList<Module>();
        this.createApplicationModule(arrayList);
        this.createArtifactsModule(arrayList);
        this.collectModuleBindings(arrayList);
        for (Module module : arrayList) {
            for (Binding<?> binding : module.getBindings()) {
                linkedHashMap.put(Key.of(binding), binding);
            }
        }
        return Collections.unmodifiableCollection(linkedHashMap.values());
    }

    protected void createArtifactsModule(@Nonnull List<Module> list) {
        final ArrayList arrayList = new ArrayList();
        ServiceLoaderUtils.load(this.getClass().getClassLoader(), GRIFFON_PATH, new ServiceLoaderUtils.PathFilter(){

            @Override
            public boolean accept(@Nonnull String string) {
                return !string.endsWith(AbstractApplicationBootstrapper.PROPERTIES);
            }
        }, new ServiceLoaderUtils.ResourceProcessor(){

            @Override
            public void process(@Nonnull ClassLoader classLoader, @Nonnull String string) {
                string = string.trim();
                try {
                    arrayList.add(classLoader.loadClass(string));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.warn("'" + string + "' could not be resolved as a Class");
                }
            }
        });
        list.add(new AbstractModule(){

            @Override
            protected void doConfigure() {
                for (Class clazz : arrayList) {
                    if (GriffonService.class.isAssignableFrom(clazz)) {
                        this.bind(clazz).asSingleton();
                        continue;
                    }
                    this.bind(clazz);
                }
            }
        });
    }

    protected void createApplicationModule(@Nonnull List<Module> list) {
        list.add(new AbstractModule(){

            @Override
            protected void doConfigure() {
                this.bind(GriffonApplication.class).toInstance(AbstractApplicationBootstrapper.this.application);
            }
        });
    }

    protected void collectModuleBindings(@Nonnull Collection<Module> collection) {
        List<Module> list = this.loadModules();
        list.add(0, new DefaultApplicationModule());
        Map<String, Module> map = this.sortModules(list);
        for (Map.Entry<String, Module> entry : map.entrySet()) {
            LOG.debug("Loading module bindings from {}:{}", (Object)entry.getKey(), (Object)entry.getValue());
            collection.add(entry.getValue());
        }
    }

    @Nonnull
    protected Map<String, Module> sortModules(@Nonnull List<Module> list) {
        return AnnotationUtils.sortByDependencies(list, "Module", "module");
    }

    @Nonnull
    protected abstract List<Module> loadModules();

    private void createInjector(@Nonnull Iterable<Binding<?>> iterable) throws Exception {
        ServiceLoader<InjectorFactory> serviceLoader = ServiceLoader.load(InjectorFactory.class);
        try {
            Iterator<InjectorFactory> iterator = serviceLoader.iterator();
            InjectorFactory injectorFactory = iterator.next();
            LOG.debug("Injector will be created by {}", (Object)injectorFactory);
            Injector injector = injectorFactory.createInjector(this.application, iterable);
            GriffonClassUtils.setProperty(this.application, INJECTOR, injector);
        }
        catch (Exception exception) {
            LOG.error("An error occurred while initializing the injector", GriffonExceptionHandler.sanitize(exception));
            throw exception;
        }
    }
}

