/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.Configuration;
import griffon.core.editors.PropertyEditorResolver;
import griffon.util.CollectionUtils;
import griffon.util.TypeUtils;
import java.beans.PropertyEditor;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractConfiguration
implements Configuration {
    @Override
    @Nullable
    public <T> T get(@Nonnull String string, @Nullable T t) {
        Object object = this.get(string);
        return (T)(object != null ? object : t);
    }

    @Override
    @Nullable
    public Object getAt(@Nonnull String string) {
        return this.get(string);
    }

    @Override
    @Nullable
    public <T> T getAt(@Nonnull String string, @Nullable T t) {
        return this.get(string, t);
    }

    @Override
    public boolean getAsBoolean(@Nonnull String string) {
        return this.getAsBoolean(string, false);
    }

    @Override
    public boolean getAsBoolean(@Nonnull String string, boolean bl) {
        return TypeUtils.castToBoolean(this.get(string), bl);
    }

    @Override
    public int getAsInt(@Nonnull String string) {
        return this.getAsInt(string, 0);
    }

    @Override
    public int getAsInt(@Nonnull String string, int n) {
        return TypeUtils.castToInt(this.get(string), n);
    }

    @Override
    public long getAsLong(@Nonnull String string) {
        return this.getAsLong(string, 0L);
    }

    @Override
    public long getAsLong(@Nonnull String string, long l) {
        return TypeUtils.castToLong(this.get(string), l);
    }

    @Override
    public float getAsFloat(@Nonnull String string) {
        return this.getAsFloat(string, 0.0f);
    }

    @Override
    public float getAsFloat(@Nonnull String string, float f) {
        return TypeUtils.castToFloat(this.get(string), f);
    }

    @Override
    public double getAsDouble(@Nonnull String string) {
        return this.getAsDouble(string, 0.0);
    }

    @Override
    public double getAsDouble(@Nonnull String string, double d) {
        return TypeUtils.castToDouble(this.get(string), d);
    }

    @Override
    @Nullable
    public String getAsString(@Nonnull String string) {
        return this.getAsString(string, null);
    }

    @Override
    @Nullable
    public <T> T getAs(@Nonnull String string) {
        return (T)this.get(string);
    }

    @Override
    @Nullable
    public <T> T getAs(@Nonnull String string, @Nullable T t) {
        Object object = this.get(string);
        return (T)(object != null ? object : t);
    }

    @Override
    @Nullable
    public <T> T getConverted(@Nonnull String string, @Nonnull Class<T> clazz) {
        Objects.requireNonNull(clazz, "Argument 'type' must not be null");
        return this.convertValue(this.get(string), clazz);
    }

    @Override
    @Nullable
    public <T> T getConverted(@Nonnull String string, @Nonnull Class<T> clazz, @Nullable T t) {
        T t2 = this.getConverted(string, clazz);
        return clazz.cast(t2 != null ? t2 : t);
    }

    protected <T> T convertValue(@Nullable Object object, @Nonnull Class<T> clazz) {
        if (object != null) {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(clazz);
            propertyEditor.setValue(object);
            return (T)propertyEditor.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    public String getAsString(@Nonnull String string, @Nullable String string2) {
        Object object = this.get(string);
        return object != null ? String.valueOf(object) : string2;
    }

    @Override
    @Nonnull
    public Properties asProperties() {
        return CollectionUtils.toProperties(this.asFlatMap());
    }
}

