/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.Context;
import griffon.core.editors.PropertyEditorResolver;
import griffon.exceptions.FieldException;
import griffon.inject.Contextual;
import griffon.util.AnnotationUtils;
import griffon.util.GriffonClassUtils;
import griffon.util.TypeUtils;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractContext
implements Context {
    protected Context parentContext;

    public AbstractContext(@Nullable Context context) {
        this.parentContext = context;
    }

    @Override
    @Nullable
    public Context getParentContext() {
        return this.parentContext;
    }

    @Override
    @Nullable
    public <T> T get(@Nonnull String string, @Nullable T t) {
        Object object = this.get(string);
        return (T)(object != null ? object : t);
    }

    @Override
    @Nullable
    public Object getAt(@Nonnull String string) {
        return this.get(string);
    }

    @Override
    @Nullable
    public <T> T getAt(@Nonnull String string, @Nullable T t) {
        return this.get(string, t);
    }

    @Override
    @Nullable
    public Object get(@Nonnull String string) {
        if (this.hasKey(string)) {
            return this.doGet(string);
        }
        if (this.parentContext != null) {
            return this.parentContext.get(string);
        }
        return null;
    }

    @Override
    public void destroy() {
        this.parentContext = null;
    }

    @Override
    public boolean containsKey(@Nonnull String string) {
        if (this.hasKey(string)) {
            return true;
        }
        if (this.parentContext != null) {
            return this.parentContext.containsKey(string);
        }
        return false;
    }

    @Nullable
    protected abstract Object doGet(@Nonnull String var1);

    @Override
    public boolean getAsBoolean(@Nonnull String string) {
        return this.getAsBoolean(string, false);
    }

    @Override
    public boolean getAsBoolean(@Nonnull String string, boolean bl) {
        return TypeUtils.castToBoolean(this.get(string), bl);
    }

    @Override
    public int getAsInt(@Nonnull String string) {
        return this.getAsInt(string, 0);
    }

    @Override
    public int getAsInt(@Nonnull String string, int n) {
        return TypeUtils.castToInt(this.get(string), n);
    }

    @Override
    public long getAsLong(@Nonnull String string) {
        return this.getAsLong(string, 0L);
    }

    @Override
    public long getAsLong(@Nonnull String string, long l) {
        return TypeUtils.castToLong(this.get(string), l);
    }

    @Override
    public float getAsFloat(@Nonnull String string) {
        return this.getAsFloat(string, 0.0f);
    }

    @Override
    public float getAsFloat(@Nonnull String string, float f) {
        return TypeUtils.castToFloat(this.get(string), f);
    }

    @Override
    public double getAsDouble(@Nonnull String string) {
        return this.getAsDouble(string, 0.0);
    }

    @Override
    public double getAsDouble(@Nonnull String string, double d) {
        return TypeUtils.castToDouble(this.get(string), d);
    }

    @Override
    @Nullable
    public String getAsString(@Nonnull String string) {
        return this.getAsString(string, null);
    }

    @Override
    @Nullable
    public String getAsString(@Nonnull String string, @Nullable String string2) {
        Object object = this.get(string);
        return object != null ? String.valueOf(object) : string2;
    }

    @Override
    @Nullable
    public <T> T getAs(@Nonnull String string) {
        return (T)this.get(string);
    }

    @Override
    @Nullable
    public <T> T getAs(@Nonnull String string, @Nullable T t) {
        Object object = this.get(string);
        return (T)(object != null ? object : t);
    }

    @Override
    @Nullable
    public <T> T getConverted(@Nonnull String string, @Nonnull Class<T> clazz) {
        Objects.requireNonNull(clazz, "Argument 'type' must not be null");
        return this.convertValue(this.get(string), clazz);
    }

    @Override
    @Nullable
    public <T> T getConverted(@Nonnull String string, @Nonnull Class<T> clazz, @Nullable T t) {
        T t2 = this.getConverted(string, clazz);
        return clazz.cast(t2 != null ? t2 : t);
    }

    protected <T> T convertValue(@Nullable Object object, @Nonnull Class<T> clazz) {
        if (object != null) {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(clazz);
            propertyEditor.setValue(object);
            return (T)propertyEditor.getValue();
        }
        return null;
    }

    @Override
    @Nonnull
    public <T> T injectMembers(@Nonnull T t) {
        Object object;
        Object object2;
        Objects.requireNonNull(t, "Argument 'instance' must not be null");
        for (PropertyDescriptor object3 : GriffonClassUtils.getPropertyDescriptors(t.getClass())) {
            object2 = object3.getWriteMethod();
            if (object2 == null || ((Method)object2).getAnnotation(Contextual.class) == null) continue;
            object = AnnotationUtils.nameFor((Method)object2);
            Object object4 = this.get((String)object);
            Nonnull nonnull = AnnotationUtils.findAnnotation(AnnotationUtils.annotationsOfMethodParameter((Method)object2, 0), Nonnull.class);
            if (object4 == null && nonnull != null) {
                throw new IllegalStateException("Could not find an instance of type " + ((Method)object2).getParameterTypes()[0].getName() + " under key '" + (String)object + "' to be injected on property '" + object3.getName() + "' (" + t.getClass().getName() + "). Property does not accept null values.");
            }
            try {
                ((Method)object2).invoke(t, object4);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new IllegalStateException(reflectiveOperationException);
            }
        }
        for (Field field : GriffonClassUtils.getAllDeclaredFields(t.getClass())) {
            if (field.getAnnotation(Contextual.class) == null) continue;
            object2 = AnnotationUtils.nameFor(field);
            object = this.get((String)object2);
            if (object == null && field.getAnnotation(Nonnull.class) != null) {
                throw new IllegalStateException("Could not find an instance of type " + field.getType().getName() + " under key '" + (String)object2 + "' to be injected on field '" + field.getName() + "' (" + t.getClass().getName() + "). Field does not accept null values.");
            }
            try {
                GriffonClassUtils.setFieldValue(t, field.getName(), object);
            }
            catch (FieldException fieldException) {
                throw new IllegalStateException(fieldException);
            }
        }
        return t;
    }
}

