/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.LifecycleHandler;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public abstract class AbstractLifecycleHandler
implements LifecycleHandler {
    private final GriffonApplication application;

    @Inject
    public AbstractLifecycleHandler(@Nonnull GriffonApplication griffonApplication) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
    }

    @Nonnull
    protected GriffonApplication getApplication() {
        return this.application;
    }

    @Override
    public boolean isUIThread() {
        return this.application.getUIThreadManager().isUIThread();
    }

    @Override
    @Nonnull
    public <R> Future<R> runFuture(@Nonnull Callable<R> callable) {
        return this.application.getUIThreadManager().runFuture(callable);
    }

    @Override
    @Nonnull
    public <R> Future<R> runFuture(@Nonnull ExecutorService executorService, @Nonnull Callable<R> callable) {
        return this.application.getUIThreadManager().runFuture(executorService, callable);
    }

    @Override
    public void runInsideUIAsync(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runInsideUIAsync(runnable);
    }

    @Override
    public void runInsideUISync(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runInsideUISync(runnable);
    }

    @Override
    public void runOutsideUI(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runOutsideUI(runnable);
    }

    @Override
    @Nullable
    public <R> R runInsideUISync(@Nonnull Callable<R> callable) {
        return this.application.getUIThreadManager().runInsideUISync(callable);
    }
}

