/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ApplicationClassLoader;
import griffon.core.ApplicationConfigurer;
import griffon.core.ApplicationEvent;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.core.LifecycleHandler;
import griffon.core.PlatformHandler;
import griffon.core.RunnableWithArgs;
import griffon.core.artifact.ArtifactHandler;
import griffon.core.artifact.ArtifactManager;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.ActionHandler;
import griffon.core.controller.ActionInterceptor;
import griffon.core.editors.PropertyEditorResolver;
import griffon.core.env.Lifecycle;
import griffon.core.event.EventHandler;
import griffon.core.injection.Injector;
import griffon.core.mvc.MVCGroupConfiguration;
import griffon.core.resources.ResourceInjector;
import griffon.util.AnnotationUtils;
import griffon.util.ServiceLoaderUtils;
import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.controller.NoopActionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationConfigurer
implements ApplicationConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApplicationConfigurer.class);
    private static final String ERROR_APPLICATION_NULL = "Argument 'application' must not be null";
    private static final String KEY_APP_LIFECYCLE_HANDLER_DISABLE = "application.lifecycle.handler.disable";
    private static final String KEY_GRIFFON_CONTROLLER_ACTION_HANDLER_ORDER = "griffon.controller.action.handler.order";
    private final Object lock = new Object();
    private final GriffonApplication application;
    @GuardedBy(value="lock")
    private boolean initialized;

    @Inject
    public DefaultApplicationConfigurer(@Nonnull GriffonApplication griffonApplication) {
        this.application = Objects.requireNonNull(griffonApplication, ERROR_APPLICATION_NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void init() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                this.doInitialize();
                this.initialized = true;
            }
        }
    }

    @Override
    public void runLifecycleHandler(@Nonnull Lifecycle lifecycle) {
        LifecycleHandler lifecycleHandler;
        Objects.requireNonNull(lifecycle, "Argument 'lifecycle' must not be null");
        boolean bl = this.application.getConfiguration().getAsBoolean(KEY_APP_LIFECYCLE_HANDLER_DISABLE, false);
        if (bl) {
            LOG.info("Lifecycle handler '{}' has been disabled. SKIPPING.", (Object)lifecycle.getName());
            return;
        }
        try {
            lifecycleHandler = this.application.getInjector().getInstance(LifecycleHandler.class, (Annotation)AnnotationUtils.named(lifecycle.getName()));
        }
        catch (Exception exception) {
            return;
        }
        lifecycleHandler.execute();
    }

    protected void doInitialize() {
        this.initializeEventHandler();
        this.event(ApplicationEvent.BOOTSTRAP_START, Arrays.asList(this.application));
        this.initializePropertyEditors();
        this.initializeResourcesInjector();
        this.runLifecycleHandler(Lifecycle.INITIALIZE);
        this.applyPlatformTweaks();
        this.initializeAddonManager();
        this.initializeMvcManager();
        this.initializeActionManager();
        this.initializeArtifactManager();
        this.event(ApplicationEvent.BOOTSTRAP_END, Arrays.asList(this.application));
    }

    protected void initializeEventHandler() {
        Collection<EventHandler> collection = this.application.getInjector().getInstances(EventHandler.class);
        Map<String, EventHandler> map = AnnotationUtils.sortByDependencies(collection, "EventHandler", "handler");
        for (EventHandler eventHandler : map.values()) {
            this.application.getEventRouter().addEventListener(eventHandler);
        }
    }

    protected void event(@Nonnull ApplicationEvent applicationEvent, @Nullable List<?> list) {
        this.application.getEventRouter().publishEvent(applicationEvent.getName(), list);
    }

    protected void initializePropertyEditors() {
        Class[][] classArrayArray;
        ServiceLoaderUtils.load(this.applicationClassLoader().get(), "META-INF/editors/", PropertyEditor.class, new ServiceLoaderUtils.LineProcessor(){

            @Override
            public void process(@Nonnull ClassLoader classLoader, @Nonnull Class<?> clazz, @Nonnull String string) {
                block2: {
                    try {
                        String[] stringArray = string.trim().split("=");
                        Class<?> clazz2 = DefaultApplicationConfigurer.this.loadClass(stringArray[0].trim(), classLoader);
                        Class<?> clazz3 = DefaultApplicationConfigurer.this.loadClass(stringArray[1].trim(), classLoader);
                        clazz3.newInstance();
                        PropertyEditorResolver.registerEditor(clazz2, clazz3);
                        LOG.debug("Registering {} as editor for {}", (Object)clazz3.getName(), (Object)clazz2.getName());
                    }
                    catch (Exception exception) {
                        if (!LOG.isWarnEnabled()) break block2;
                        LOG.warn("Could not load " + clazz.getName() + " with " + string, GriffonExceptionHandler.sanitize(exception));
                    }
                }
            }
        });
        for (Class[] classArray : classArrayArray = new Class[][]{{Boolean.class, Boolean.TYPE}, {Byte.class, Byte.TYPE}, {Short.class, Short.TYPE}, {Integer.class, Integer.TYPE}, {Long.class, Long.TYPE}, {Float.class, Float.TYPE}, {Double.class, Double.TYPE}}) {
            PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(classArray[0]);
            LOG.debug("Registering {} as editor for {}", (Object)propertyEditor.getClass().getName(), (Object)classArray[1].getName());
            PropertyEditorResolver.registerEditor(classArray[1], propertyEditor.getClass());
        }
    }

    protected void initializeResourcesInjector() {
        final ResourceInjector resourceInjector = this.application.getResourceInjector();
        this.application.getEventRouter().addEventListener(ApplicationEvent.NEW_INSTANCE.getName(), new RunnableWithArgs(){

            @Override
            public void run(Object ... objectArray) {
                resourceInjector.injectResources(objectArray[1]);
            }
        });
    }

    protected void initializeArtifactManager() {
        Injector<?> injector = this.application.getInjector();
        ArtifactManager artifactManager = this.application.getArtifactManager();
        for (ArtifactHandler artifactHandler : injector.getInstances(ArtifactHandler.class)) {
            artifactManager.registerArtifactHandler(artifactHandler);
        }
        artifactManager.loadArtifactMetadata();
    }

    protected void applyPlatformTweaks() {
        PlatformHandler platformHandler = this.application.getInjector().getInstance(PlatformHandler.class);
        platformHandler.handle(this.application);
    }

    protected void initializeAddonManager() {
        this.application.getAddonManager().initialize();
    }

    protected void initializeMvcManager() {
        LinkedHashMap<String, MVCGroupConfiguration> linkedHashMap = new LinkedHashMap<String, MVCGroupConfiguration>();
        Map map = this.application.getConfiguration().get("mvcGroups", Collections.emptyMap());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                LOG.debug("Adding MVC group {}", (Object)string);
                Map map2 = (Map)entry.getValue();
                Map<String, Object> map3 = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
                for (Map.Entry entry2 : map2.entrySet()) {
                    String string2 = String.valueOf(entry2.getKey());
                    if ("config".equals(string2) && entry2.getValue() instanceof Map) {
                        map3 = (Map)entry2.getValue();
                        continue;
                    }
                    linkedHashMap2.put(string2, String.valueOf(entry2.getValue()));
                }
                linkedHashMap.put(string, this.application.getMvcGroupManager().newMVCGroupConfiguration(string, linkedHashMap2, map3));
            }
        }
        this.application.getMvcGroupManager().initialize(linkedHashMap);
    }

    protected void initializeActionManager() {
        if (this.application.getActionManager() instanceof NoopActionManager) {
            return;
        }
        this.application.getEventRouter().addEventListener(ApplicationEvent.NEW_INSTANCE.getName(), new RunnableWithArgs(){

            @Override
            public void run(Object ... objectArray) {
                Class clazz = (Class)objectArray[0];
                if (GriffonController.class.isAssignableFrom(clazz)) {
                    DefaultApplicationConfigurer.this.application.getActionManager().createActions((GriffonController)objectArray[1]);
                }
            }
        });
        Injector<?> injector = this.application.getInjector();
        Collection<ActionHandler> collection = injector.getInstances(ActionHandler.class);
        List<String> list = this.application.getConfiguration().get(KEY_GRIFFON_CONTROLLER_ACTION_HANDLER_ORDER, Collections.emptyList());
        Map<String, ActionHandler> map = AnnotationUtils.sortByDependencies(collection, "ActionHandler", "handler", list);
        for (ActionHandler actionHandler : map.values()) {
            this.application.getActionManager().addActionHandler(actionHandler);
        }
        Collection<ActionInterceptor> collection2 = injector.getInstances(ActionInterceptor.class);
        if (!collection2.isEmpty()) {
            this.application.getLog().error(ActionInterceptor.class.getName() + " has been deprecated and is no longer supported");
            throw new UnsupportedOperationException(ActionInterceptor.class.getName() + " has been deprecated and is no longer supported");
        }
    }

    protected Class<?> loadClass(@Nonnull String string, @Nonnull ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader classLoader2 = DefaultApplicationConfigurer.class.getClassLoader();
        try {
            return classLoader2.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassNotFoundException classNotFoundException2 = classNotFoundException;
            classLoader2 = classLoader;
            try {
                return classLoader2.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException3) {
                classNotFoundException2 = classNotFoundException3;
                throw classNotFoundException2;
            }
        }
    }

    private ApplicationClassLoader applicationClassLoader() {
        return this.application.getInjector().getInstance(ApplicationClassLoader.class);
    }
}

