/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.Context;
import griffon.util.GriffonNameUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.AbstractContext;

public class DefaultContext
extends AbstractContext {
    protected static final String ERROR_KEY_BLANK = "Argument 'key' must not be blank";
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public DefaultContext() {
        this(null);
    }

    public DefaultContext(@Nullable Context context) {
        super(context);
    }

    @Override
    @Nullable
    protected Object doGet(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        return this.attributes.get(string);
    }

    @Override
    public boolean hasKey(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        return this.attributes.containsKey(string);
    }

    @Override
    @Nullable
    public Object remove(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        return this.attributes.remove(string);
    }

    @Override
    @Nullable
    public <T> T removeAs(@Nonnull String string) {
        return (T)this.remove(string);
    }

    @Override
    @Nullable
    public <T> T removeConverted(@Nonnull String string, @Nonnull Class<T> clazz) {
        return this.convertValue(this.remove(string), clazz);
    }

    @Override
    public void put(@Nonnull String string, @Nullable Object object) {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        this.attributes.put(string, object);
    }

    @Override
    public void putAt(@Nonnull String string, @Nullable Object object) {
        this.put(string, object);
    }

    @Override
    public void destroy() {
        this.attributes.clear();
        super.destroy();
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>(this.attributes.keySet());
        if (this.parentContext != null) {
            hashSet.addAll(this.parentContext.keySet());
        }
        return hashSet;
    }
}

