/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ExecutorServiceManager;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultExecutorServiceManager
implements ExecutorServiceManager {
    private final Set<ExecutorService> executorServices = new LinkedHashSet<ExecutorService>();

    @Override
    @Nonnull
    public Collection<ExecutorService> getExecutorServices() {
        return Collections.unmodifiableSet(this.executorServices);
    }

    @Override
    @Nullable
    public ExecutorService add(@Nullable ExecutorService executorService) {
        if (executorService != null) {
            this.executorServices.add(executorService);
        }
        return executorService;
    }

    @Override
    @Nullable
    public ExecutorService remove(@Nullable ExecutorService executorService) {
        this.executorServices.remove(executorService);
        return executorService;
    }

    @Override
    public void shutdownAll() {
        for (ExecutorService executorService : this.executorServices) {
            if (executorService.isShutdown()) continue;
            executorService.shutdown();
        }
    }
}

