/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import griffon.core.GriffonApplication;
import griffon.util.GriffonNameUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.codehaus.griffon.runtime.core.DefaultPlatformHandler;

public class DefaultMacOSXPlatformHandler
extends DefaultPlatformHandler {
    @Override
    public void handle(@Nonnull GriffonApplication griffonApplication) {
        super.handle(griffonApplication);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        String string = griffonApplication.getConfiguration().getAsString("application.title", "Griffon");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", GriffonNameUtils.capitalize(string));
        boolean bl = griffonApplication.getConfiguration().getAsBoolean("osx.noabout", false);
        boolean bl2 = griffonApplication.getConfiguration().getAsBoolean("osx.noprefs", false);
        boolean bl3 = griffonApplication.getConfiguration().getAsBoolean("osx.noquit", false);
        GriffonMacOSXSupport griffonMacOSXSupport = new GriffonMacOSXSupport(griffonApplication, bl3);
        if (!bl) {
            MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)griffonMacOSXSupport);
        }
        if (!bl2) {
            MRJApplicationUtils.registerPrefsHandler((MRJPrefsHandler)griffonMacOSXSupport);
        }
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)griffonMacOSXSupport);
    }

    private static class GriffonMacOSXSupport
    implements MRJAboutHandler,
    MRJQuitHandler,
    MRJPrefsHandler {
        private final GriffonApplication application;
        private final boolean noquit;

        private GriffonMacOSXSupport(@Nonnull GriffonApplication griffonApplication, boolean bl) {
            this.application = griffonApplication;
            this.noquit = bl;
        }

        public void handleAbout() {
            this.application.getEventRouter().publishEvent("OSXAbout", Arrays.asList(this.application));
        }

        public void handlePrefs() throws IllegalStateException {
            this.application.getEventRouter().publishEvent("OSXPrefs", Arrays.asList(this.application));
        }

        public void handleQuit() {
            if (this.noquit) {
                this.application.getEventRouter().publishEvent("OSXQuit", Arrays.asList(this.application));
            } else {
                this.application.shutdown();
            }
        }
    }
}

