/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.Context;
import griffon.core.ObservableContext;
import griffon.util.TypeUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.DefaultContext;

public class DefaultObservableContext
extends DefaultContext
implements ObservableContext {
    private static final String ERROR_LISTENER_NULL = "Argument 'listener' must not be null";
    private final List<ObservableContext.ContextEventListener> listeners = new CopyOnWriteArrayList<ObservableContext.ContextEventListener>();
    private final ObservableContext.ContextEventListener parentListener = new ObservableContext.ContextEventListener(){

        @Override
        public void contextChanged(@Nonnull ObservableContext.ContextEvent contextEvent) {
            String string = contextEvent.getKey();
            if (!DefaultObservableContext.this.hasKey(string)) {
                DefaultObservableContext.this.fireContextEvent(contextEvent.getType(), string, contextEvent.getOldValue(), contextEvent.getNewValue());
            }
        }
    };

    public DefaultObservableContext() {
    }

    public DefaultObservableContext(@Nonnull Context context) {
        super(context);
        if (context instanceof ObservableContext) {
            ObservableContext observableContext = (ObservableContext)context;
            observableContext.addContextEventListener(this.parentListener);
        }
    }

    @Override
    public void addContextEventListener(@Nonnull ObservableContext.ContextEventListener contextEventListener) {
        Objects.requireNonNull(contextEventListener, ERROR_LISTENER_NULL);
        if (!this.listeners.contains(contextEventListener)) {
            this.listeners.add(contextEventListener);
        }
    }

    @Override
    public void removeContextEventListener(@Nonnull ObservableContext.ContextEventListener contextEventListener) {
        Objects.requireNonNull(contextEventListener, ERROR_LISTENER_NULL);
        this.listeners.remove(contextEventListener);
    }

    @Override
    @Nonnull
    public ObservableContext.ContextEventListener[] getContextEventListeners() {
        return this.listeners.toArray(new ObservableContext.ContextEventListener[this.listeners.size()]);
    }

    @Override
    public void put(@Nonnull String string, @Nullable Object object) {
        boolean bl = this.hasKey(string);
        boolean bl2 = !bl && this.containsKey(string);
        Object object2 = this.get(string);
        super.put(string, object);
        boolean bl3 = TypeUtils.equals(object2, object);
        if (bl2) {
            if (!bl3) {
                this.fireContextEvent(ObservableContext.ContextEvent.Type.UPDATE, string, object2, object);
            }
        } else if (bl) {
            this.fireContextEvent(ObservableContext.ContextEvent.Type.UPDATE, string, object2, object);
        } else {
            this.fireContextEvent(ObservableContext.ContextEvent.Type.ADD, string, null, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object remove(@Nonnull String string) {
        boolean bl = this.hasKey(string);
        Object object = super.remove(string);
        boolean bl2 = bl && !this.hasKey(string);
        boolean bl3 = this.containsKey(string);
        try {
            Object object2 = object;
            return object2;
        }
        finally {
            if (bl2) {
                if (bl3) {
                    Object object3 = this.get(string);
                    boolean bl4 = TypeUtils.equals(object, object3);
                    if (!bl4) {
                        this.fireContextEvent(ObservableContext.ContextEvent.Type.UPDATE, string, object, object3);
                    }
                } else {
                    this.fireContextEvent(ObservableContext.ContextEvent.Type.REMOVE, string, object, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T removeAs(@Nonnull String string) {
        boolean bl = this.hasKey(string);
        Object t = super.removeAs(string);
        boolean bl2 = bl && !this.hasKey(string);
        boolean bl3 = this.containsKey(string);
        try {
            Object t2 = t;
            return t2;
        }
        finally {
            if (bl2) {
                if (bl3) {
                    Object t3 = this.getAs(string);
                    boolean bl4 = TypeUtils.equals(t, t3);
                    if (!bl4) {
                        this.fireContextEvent(ObservableContext.ContextEvent.Type.UPDATE, string, t, t3);
                    }
                } else {
                    this.fireContextEvent(ObservableContext.ContextEvent.Type.REMOVE, string, t, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T removeConverted(@Nonnull String string, @Nonnull Class<T> clazz) {
        boolean bl = this.hasKey(string);
        T t = super.removeConverted(string, clazz);
        boolean bl2 = bl && !this.hasKey(string);
        boolean bl3 = this.containsKey(string);
        try {
            T t2 = t;
            return t2;
        }
        finally {
            if (bl2) {
                if (bl3) {
                    T t3 = this.getConverted(string, clazz);
                    boolean bl4 = TypeUtils.equals(t, t3);
                    if (!bl4) {
                        this.fireContextEvent(ObservableContext.ContextEvent.Type.UPDATE, string, t, t3);
                    }
                } else {
                    this.fireContextEvent(ObservableContext.ContextEvent.Type.REMOVE, string, t, null);
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.getParentContext() instanceof ObservableContext) {
            ObservableContext observableContext = (ObservableContext)this.getParentContext();
            observableContext.removeContextEventListener(this.parentListener);
        }
        this.listeners.clear();
        super.destroy();
    }

    protected void fireContextEvent(@Nonnull ObservableContext.ContextEvent.Type type, @Nonnull String string, @Nullable Object object, @Nullable Object object2) {
        this.fireContextEvent(new ObservableContext.ContextEvent(type, string, object, object2));
    }

    protected void fireContextEvent(@Nonnull ObservableContext.ContextEvent contextEvent) {
        for (ObservableContext.ContextEventListener contextEventListener : this.listeners) {
            contextEventListener.contextChanged(contextEvent);
        }
    }
}

