/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.Configuration;
import griffon.core.MutableConfiguration;
import griffon.util.AbstractMapResourceBundle;
import griffon.util.CompositeResourceBundle;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.ConfigurationDecorator;

public class DelegatingMutableConfiguration
extends ConfigurationDecorator
implements MutableConfiguration {
    private static final String ERROR_KEY_BLANK = "Argument 'key' must not be blank";
    private static final String ERROR_VALUE_NULL = "Argument 'value' must not be null";
    private final Map<String, Object> mutableKeyValues = new LinkedHashMap<String, Object>();
    private final Set<String> removedKeys = new LinkedHashSet<String>();

    public DelegatingMutableConfiguration(@Nonnull Configuration configuration) {
        super(configuration);
    }

    @Override
    public void set(@Nonnull String string, @Nonnull Object object) {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        this.mutableKeyValues.put(string, object);
    }

    @Override
    @Nullable
    public Object remove(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        if (this.mutableKeyValues.containsKey(string)) {
            this.removedKeys.add(string);
            return this.mutableKeyValues.remove(string);
        }
        if (!this.removedKeys.contains(string) && this.delegate.containsKey(string)) {
            this.removedKeys.add(string);
            return this.delegate.get(string);
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T removeAs(@Nonnull String string) {
        return (T)this.remove(string);
    }

    @Override
    @Nullable
    public <T> T removeConverted(@Nonnull String string, @Nonnull Class<T> clazz) {
        return this.convertValue(this.remove(string), clazz);
    }

    @Override
    @Nonnull
    public Map<String, Object> asFlatMap() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(this.delegate.asFlatMap());
        linkedHashMap.putAll(this.mutableKeyValues);
        for (String string : this.removedKeys) {
            linkedHashMap.remove(string);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    @Nonnull
    public ResourceBundle asResourceBundle() {
        return new CompositeResourceBundle(Arrays.asList(new PrivateMapResourceBundle(this.asFlatMap()), this.delegate.asResourceBundle()));
    }

    @Override
    @Nullable
    public Object get(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        try {
            return ConfigUtils.getConfigValue(this.mutableKeyValues, string);
        }
        catch (MissingResourceException missingResourceException) {
            if (this.removedKeys.contains(string)) {
                return null;
            }
            return super.get(string);
        }
    }

    @Override
    @Nullable
    public <T> T get(@Nonnull String string, @Nullable T t) {
        Object object = this.get(string);
        return (T)(object != null ? object : t);
    }

    @Override
    @Nullable
    public String getAsString(@Nonnull String string, @Nullable String string2) {
        Object object = this.get(string);
        return object != null ? String.valueOf(object) : string2;
    }

    @Override
    public boolean containsKey(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        return ConfigUtils.containsKey(this.mutableKeyValues, string) || !this.removedKeys.contains(string) && this.delegate.containsKey(string);
    }

    private static class PrivateMapResourceBundle
    extends AbstractMapResourceBundle {
        private final Map<String, Object> map = new LinkedHashMap<String, Object>();

        private PrivateMapResourceBundle(Map<String, Object> map) {
            this.map.putAll(map);
            this.initialize(this.entries);
            this.initializeKeys();
        }

        @Override
        protected void initialize(@Nonnull Map<String, Object> map) {
            if (this.map != null && map != null) {
                map.putAll(this.map);
            }
        }
    }
}

