/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ApplicationClassLoader;
import griffon.core.GriffonApplication;
import griffon.core.LifecycleHandler;
import griffon.exceptions.InstanceNotFoundException;
import griffon.util.AnnotationUtils;
import griffon.util.GriffonNameUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.codehaus.griffon.runtime.core.AbstractLifecycleHandler;

public class LifecycleHandlerProvider
implements Provider<LifecycleHandler> {
    private final String basename;
    private GriffonApplication application;
    private ApplicationClassLoader applicationClassLoader;

    public LifecycleHandlerProvider(@Nonnull String string) {
        this.basename = GriffonNameUtils.requireNonBlank(string, "Argument 'basename' must not be blank");
    }

    @Inject
    public void setGriffonApplication(@Nonnull GriffonApplication griffonApplication) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
    }

    @Inject
    public void setApplicationClassLoader(ApplicationClassLoader applicationClassLoader) {
        this.applicationClassLoader = Objects.requireNonNull(applicationClassLoader, "Argument 'applicationClassLoader' must not be null");
    }

    public LifecycleHandler get() {
        Class<?> clazz;
        try {
            clazz = this.applicationClassLoader.get().loadClass(this.basename);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new NoopLifecycleHandler(this.application);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(GriffonApplication.class);
            LifecycleHandler lifecycleHandler = (LifecycleHandler)constructor.newInstance(this.application);
            this.application.getInjector().injectMembers(lifecycleHandler);
            return lifecycleHandler;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException reflectiveOperationException) {
            throw new InstanceNotFoundException(clazz, (Annotation)AnnotationUtils.named(this.basename), reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InstanceNotFoundException(clazz, (Annotation)AnnotationUtils.named(this.basename), invocationTargetException.getTargetException());
        }
    }

    private static class NoopLifecycleHandler
    extends AbstractLifecycleHandler {
        public NoopLifecycleHandler(@Nonnull GriffonApplication griffonApplication) {
            super(griffonApplication);
        }

        @Override
        public void execute() {
        }
    }
}

