/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.Configuration;
import griffon.core.PlatformHandler;
import griffon.exceptions.InstanceNotFoundException;
import griffon.exceptions.TypeNotFoundException;
import griffon.util.CollectionUtils;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonNameUtils;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.codehaus.griffon.runtime.core.DefaultPlatformHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformHandlerProvider
implements Provider<PlatformHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformHandlerProvider.class);
    private static final String DEFAULT_PLATFORM_HANDLER = "org.codehaus.griffon.runtime.core.DefaultPlatformHandler";
    private static final Map<String, String> DEFAULT_PLATFORM_HANDLERS = CollectionUtils.map().e("linux", "org.codehaus.griffon.runtime.core.DefaultPlatformHandler").e("linux64", "org.codehaus.griffon.runtime.core.DefaultPlatformHandler").e("macosx", "org.codehaus.griffon.runtime.core.DefaultMacOSXPlatformHandler").e("macosx64", "org.codehaus.griffon.runtime.core.DefaultMacOSXPlatformHandler").e("solaris", "org.codehaus.griffon.runtime.core.DefaultPlatformHandler").e("windows", "org.codehaus.griffon.runtime.core.DefaultPlatformHandler").e("windows64", "org.codehaus.griffon.runtime.core.DefaultPlatformHandler");
    @Inject
    private Configuration configuration;

    public PlatformHandler get() {
        Class<?> clazz;
        String string = GriffonApplicationUtils.platform;
        String string2 = this.configuration.getAsString("platform.handler." + string, DEFAULT_PLATFORM_HANDLERS.get(string));
        if (GriffonNameUtils.isBlank(string2)) {
            string2 = DEFAULT_PLATFORM_HANDLER;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using " + string2 + " as PlatformHandler");
        }
        try {
            clazz = Class.forName(string2, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotFoundException(PlatformHandler.class.getName(), classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (GriffonApplicationUtils.isJdk9()) {
                return new DefaultPlatformHandler();
            }
            throw new TypeNotFoundException(PlatformHandler.class.getName(), noClassDefFoundError);
        }
        try {
            return (PlatformHandler)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new InstanceNotFoundException(clazz, (Throwable)reflectiveOperationException);
        }
    }
}

