/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.AbstractConfiguration;

public class ResourceBundleConfiguration
extends AbstractConfiguration {
    protected static final String ERROR_KEY_BLANK = "Argument 'key' must not be blank";
    private final ResourceBundle resourceBundle;
    private final Map<String, Object> flatMap = new LinkedHashMap<String, Object>();

    @Inject
    public ResourceBundleConfiguration(@Nonnull ResourceBundle resourceBundle) {
        this.resourceBundle = Objects.requireNonNull(resourceBundle, "Argument 'resourceBundle' must not be null");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.flatMap.put(string, ConfigUtils.getConfigValue(resourceBundle, string));
        }
    }

    @Override
    public boolean containsKey(@Nonnull String string) {
        return this.resourceBundle.containsKey(GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK));
    }

    @Override
    @Nonnull
    public Map<String, Object> asFlatMap() {
        return Collections.unmodifiableMap(this.flatMap);
    }

    @Override
    @Nonnull
    public ResourceBundle asResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    @Nullable
    public Object get(@Nonnull String string) {
        try {
            return ConfigUtils.getConfigValue(this.resourceBundle, string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

