/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.addon;

import griffon.core.ApplicationEvent;
import griffon.core.GriffonApplication;
import griffon.core.addon.AddonManager;
import griffon.core.addon.GriffonAddon;
import griffon.core.mvc.MVCGroupConfiguration;
import griffon.util.AnnotationUtils;
import griffon.util.CollectionUtils;
import griffon.util.GriffonNameUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAddonManager
implements AddonManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAddonManager.class);
    private static final String ERROR_NAME_BLANK = "Argument 'name' must not be blank";
    private final Map<String, GriffonAddon> addons = new LinkedHashMap<String, GriffonAddon>();
    private final Object lock = new Object[0];
    @GuardedBy(value="lock")
    private boolean initialized;
    private final GriffonApplication application;

    @Inject
    public AbstractAddonManager(@Nonnull GriffonApplication griffonApplication) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
    }

    @Nonnull
    public GriffonApplication getApplication() {
        return this.application;
    }

    @Override
    @Nonnull
    public Map<String, GriffonAddon> getAddons() {
        return Collections.unmodifiableMap(this.addons);
    }

    @Override
    @Nullable
    public GriffonAddon findAddon(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        if (string.endsWith("GriffonAddon")) {
            string = string.substring(0, string.length() - 12);
        }
        return this.addons.get(GriffonNameUtils.getPropertyName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initialize() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                this.doInitialize();
                this.initialized = true;
            }
        }
    }

    protected void doInitialize() {
        LOG.debug("Loading addons [START]");
        Map<String, GriffonAddon> map = this.preloadAddons();
        this.event(ApplicationEvent.LOAD_ADDONS_START);
        for (Map.Entry<String, GriffonAddon> object : map.entrySet()) {
            String string = object.getKey();
            GriffonAddon griffonAddon = object.getValue();
            LOG.debug("Loading addon {} with class {}", (Object)string, (Object)griffonAddon.getClass().getName());
            this.event(ApplicationEvent.LOAD_ADDON_START, Arrays.asList(this.getApplication(), string, griffonAddon));
            this.getApplication().getEventRouter().addEventListener(griffonAddon);
            this.addMVCGroups(griffonAddon);
            griffonAddon.init(this.getApplication());
            this.addons.put(string, griffonAddon);
            this.event(ApplicationEvent.LOAD_ADDON_END, Arrays.asList(this.getApplication(), string, griffonAddon));
            LOG.debug("Loaded addon {}", (Object)string);
        }
        for (GriffonAddon griffonAddon : CollectionUtils.reverse(map.values())) {
            this.getApplication().addShutdownHandler(griffonAddon);
        }
        LOG.debug("Loading addons [END]");
        this.event(ApplicationEvent.LOAD_ADDONS_END);
    }

    @Nonnull
    protected Map<String, GriffonAddon> preloadAddons() {
        Collection<GriffonAddon> collection = this.getApplication().getInjector().getInstances(GriffonAddon.class);
        return AnnotationUtils.sortByDependencies(collection, "GriffonAddon", "addon");
    }

    protected void addMVCGroups(@Nonnull GriffonAddon griffonAddon) {
        for (Map.Entry<String, Map<String, Object>> entry : griffonAddon.getMvcGroups().entrySet()) {
            String string = entry.getKey();
            LOG.debug("Adding MVC group {}", (Object)string);
            Map<String, Object> map = entry.getValue();
            Map<String, Object> map2 = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                String string2 = String.valueOf(entry2.getKey());
                if ("config".equals(string2) && entry2.getValue() instanceof Map) {
                    map2 = (Map)entry2.getValue();
                    continue;
                }
                linkedHashMap.put(string2, String.valueOf(entry2.getValue()));
            }
            MVCGroupConfiguration mVCGroupConfiguration = this.getApplication().getMvcGroupManager().newMVCGroupConfiguration(string, linkedHashMap, map2);
            this.getApplication().getMvcGroupManager().addConfiguration(mVCGroupConfiguration);
        }
    }

    @Nonnull
    protected Map<String, GriffonAddon> getAddonsInternal() {
        return this.addons;
    }

    protected void event(@Nonnull ApplicationEvent applicationEvent) {
        this.event(applicationEvent, Arrays.asList(this.getApplication()));
    }

    protected void event(@Nonnull ApplicationEvent applicationEvent, @Nonnull List<?> list) {
        this.getApplication().getEventRouter().publishEvent(applicationEvent.getName(), list);
    }
}

