/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.artifact;

import griffon.core.GriffonApplication;
import griffon.core.artifact.ArtifactHandler;
import griffon.core.artifact.GriffonArtifact;
import griffon.core.artifact.GriffonClass;
import griffon.util.GriffonNameUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public abstract class AbstractArtifactHandler<A extends GriffonArtifact>
implements ArtifactHandler<A> {
    protected static final String ERROR_CLASS_NULL = "Argument 'class' must not be null";
    private final Class<A> artifactType;
    private final String type;
    private final String trailing;
    private final GriffonApplication application;
    private final Map<String, GriffonClass> classesByName = new TreeMap<String, GriffonClass>();
    private GriffonClass[] griffonClasses = new GriffonClass[0];

    @Inject
    public AbstractArtifactHandler(@Nonnull GriffonApplication griffonApplication, @Nonnull Class<A> clazz, @Nonnull String string, @Nonnull String string2) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
        this.artifactType = Objects.requireNonNull(clazz, "Argument 'artifactType' must not be null");
        this.type = GriffonNameUtils.requireNonBlank(string, "Argument 'type' must not be blank");
        this.trailing = Objects.requireNonNull(string2, "Argument 'trailing' must not be null");
    }

    @Override
    @Nonnull
    public Class<A> getArtifactType() {
        return this.artifactType;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getTrailing() {
        return this.trailing;
    }

    @Override
    public void initialize(@Nonnull Class<A>[] classArray) {
        this.griffonClasses = new GriffonClass[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            GriffonClass griffonClass;
            Class<A> clazz = classArray[i];
            this.griffonClasses[i] = griffonClass = this.newGriffonClassInstance(clazz);
            this.classesByName.put(clazz.getName(), griffonClass);
        }
    }

    @Override
    @Nonnull
    public Map<String, GriffonClass> getClassesByName() {
        return Collections.unmodifiableMap(this.classesByName);
    }

    @Override
    public boolean isArtifact(@Nonnull Class<A> clazz) {
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        return this.classesByName.get(clazz.getName()) != null;
    }

    @Override
    public boolean isArtifact(@Nonnull GriffonClass griffonClass) {
        Objects.requireNonNull(griffonClass, ERROR_CLASS_NULL);
        for (GriffonClass griffonClass2 : this.griffonClasses) {
            if (!griffonClass2.equals(griffonClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public GriffonClass[] getClasses() {
        return this.griffonClasses;
    }

    @Override
    @Nullable
    public GriffonClass getClassFor(@Nonnull Class<A> clazz) {
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        return this.getClassFor(clazz.getName());
    }

    @Override
    @Nullable
    public GriffonClass getClassFor(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'fqnClassName' must not be blank");
        return this.classesByName.get(string);
    }

    @Override
    @Nullable
    public GriffonClass findClassFor(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'propertyName' must not be blank");
        String string2 = string;
        int n = string.lastIndexOf(".");
        if (n > -1) {
            string2 = string2.substring(n + 1);
        }
        if (!(string2 = string2.length() == 1 ? string2.toUpperCase() : string2.substring(0, 1).toUpperCase() + string2.substring(1)).endsWith(this.trailing)) {
            string2 = string2 + this.trailing;
        }
        for (GriffonClass griffonClass : this.griffonClasses) {
            if (!griffonClass.getClazz().getSimpleName().equals(string2)) continue;
            return griffonClass;
        }
        return null;
    }

    @Nonnull
    protected GriffonApplication getApplication() {
        return this.application;
    }
}

