/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.artifact;

import griffon.core.artifact.ArtifactHandler;
import griffon.core.artifact.ArtifactManager;
import griffon.core.artifact.GriffonArtifact;
import griffon.core.artifact.GriffonClass;
import griffon.core.artifact.GriffonView;
import griffon.core.injection.Injector;
import griffon.core.threading.UIThreadManager;
import griffon.exceptions.ArtifactHandlerNotFoundException;
import griffon.exceptions.ArtifactNotFoundException;
import griffon.util.GriffonNameUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactManager
implements ArtifactManager {
    protected static final String ERROR_ARTIFACT_HANDLER_NULL = "Argument 'artifactHandler' must not be null";
    private static final String ERROR_NAME_BLANK = "Argument 'name' must not be blank";
    private static final String ERROR_TYPE_BLANK = "Argument 'type' must not be blank";
    private static final String ERROR_CLASS_NULL = "Argument 'clazz' must not be null";
    private static final String ERROR_ARTIFACT_NULL = "Argument 'artifact' must not be null";
    private static final String ERROR_FULLY_QUALIFIED_CLASSNAME_BLANK = "Argument 'fqClassName' must not be blank";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractArtifactManager.class);
    private final Map<String, Class<? extends GriffonArtifact>[]> artifacts = new ConcurrentHashMap<String, Class<? extends GriffonArtifact>[]>();
    private final Map<String, ArtifactHandler> artifactHandlers = new ConcurrentHashMap<String, ArtifactHandler>();
    private final Object lock = new Object[0];
    @Inject
    private Provider<Injector> injectorProvider;
    @Inject
    private UIThreadManager uiThreadManager;

    @Nonnull
    protected Map<String, ArtifactHandler> getArtifactHandlers() {
        return this.artifactHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadArtifactMetadata() {
        Map<String, List<Class<? extends GriffonArtifact>>> map = this.doLoadArtifactMetadata();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, List<Class<? extends GriffonArtifact>>> entry : map.entrySet()) {
                String string = entry.getKey();
                ArtifactHandler artifactHandler = this.artifactHandlers.get(string);
                if (artifactHandler == null) {
                    throw new ArtifactHandlerNotFoundException(string);
                }
                List<Class<? extends GriffonArtifact>> list = entry.getValue();
                this.artifacts.put(string, list.toArray(new Class[list.size()]));
                artifactHandler.initialize(this.artifacts.get(string));
            }
        }
    }

    @Override
    @Nonnull
    public Set<String> getAllTypes() {
        return Collections.unmodifiableSet(this.artifactHandlers.keySet());
    }

    @Override
    @Nonnull
    public <A extends GriffonArtifact> A newInstance(@Nonnull GriffonClass griffonClass) {
        try {
            Objects.requireNonNull(griffonClass, "Argument 'griffonClass' must not be null");
        }
        catch (RuntimeException runtimeException) {
            throw new ArtifactNotFoundException(runtimeException);
        }
        return (A)this.newInstance(griffonClass.getClazz());
    }

    @Override
    @Nonnull
    public <A extends GriffonArtifact> A newInstance(final @Nonnull Class<A> clazz) {
        if (this.findGriffonClass(clazz) == null) {
            throw new ArtifactNotFoundException(clazz);
        }
        if (GriffonView.class.isAssignableFrom(clazz)) {
            return (A)((GriffonArtifact)this.uiThreadManager.runInsideUISync(new Callable<A>(){

                @Override
                public A call() throws Exception {
                    return (GriffonArtifact)((Injector)AbstractArtifactManager.this.injectorProvider.get()).getInstance(clazz);
                }
            }));
        }
        return (A)((GriffonArtifact)((Injector)this.injectorProvider.get()).getInstance(clazz));
    }

    @Nonnull
    protected abstract Map<String, List<Class<? extends GriffonArtifact>>> doLoadArtifactMetadata();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerArtifactHandler(@Nonnull ArtifactHandler artifactHandler) {
        Objects.requireNonNull(artifactHandler, ERROR_ARTIFACT_HANDLER_NULL);
        LOG.debug("Registering artifact handler for type '{}': {}", (Object)artifactHandler.getType(), (Object)artifactHandler);
        Object object = this.lock;
        synchronized (object) {
            this.artifactHandlers.put(artifactHandler.getType(), artifactHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterArtifactHandler(@Nonnull ArtifactHandler artifactHandler) {
        Objects.requireNonNull(artifactHandler, ERROR_ARTIFACT_HANDLER_NULL);
        LOG.debug("Removing artifact handler for type '{}': {}", (Object)artifactHandler.getType(), (Object)artifactHandler);
        Object object = this.lock;
        synchronized (object) {
            this.artifactHandlers.remove(artifactHandler.getType());
        }
    }

    protected boolean isArtifactTypeSupported(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_TYPE_BLANK);
        return this.artifactHandlers.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GriffonClass findGriffonClass(@Nonnull String string, @Nonnull String string2) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        GriffonNameUtils.requireNonBlank(string2, ERROR_TYPE_BLANK);
        LOG.debug("Searching for griffonClass of {}:{}", (Object)string2, (Object)string);
        Object object = this.lock;
        synchronized (object) {
            ArtifactHandler artifactHandler = this.artifactHandlers.get(string2);
            return artifactHandler != null ? artifactHandler.findClassFor(string) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GriffonClass findGriffonClass(@Nonnull Class<? extends GriffonArtifact> clazz, @Nonnull String string) {
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_TYPE_BLANK);
        LOG.debug("Searching for griffonClass of {}:{}", (Object)string, (Object)clazz.getName());
        Object object = this.lock;
        synchronized (object) {
            ArtifactHandler artifactHandler = this.artifactHandlers.get(string);
            return artifactHandler != null ? artifactHandler.getClassFor(clazz) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <A extends GriffonArtifact> GriffonClass findGriffonClass(@Nonnull A a) {
        Objects.requireNonNull(a, ERROR_ARTIFACT_NULL);
        Object object = this.lock;
        synchronized (object) {
            return this.findGriffonClass(a.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GriffonClass findGriffonClass(@Nonnull Class<? extends GriffonArtifact> clazz) {
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        LOG.debug("Searching for griffonClass of {}", (Object)clazz.getName());
        Object object = this.lock;
        synchronized (object) {
            for (ArtifactHandler artifactHandler : this.artifactHandlers.values()) {
                GriffonClass griffonClass = artifactHandler.getClassFor(clazz);
                if (griffonClass == null) continue;
                return griffonClass;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GriffonClass findGriffonClass(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_FULLY_QUALIFIED_CLASSNAME_BLANK);
        LOG.debug("Searching for griffonClass of {}", (Object)string);
        Object object = this.lock;
        synchronized (object) {
            for (ArtifactHandler artifactHandler : this.artifactHandlers.values()) {
                GriffonClass griffonClass = artifactHandler.getClassFor(string);
                if (griffonClass == null) continue;
                return griffonClass;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<GriffonClass> getClassesOfType(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_TYPE_BLANK);
        Object object = this.lock;
        synchronized (object) {
            if (this.artifacts.containsKey(string)) {
                return Arrays.asList(this.artifactHandlers.get(string).getClasses());
            }
        }
        return EMPTY_GRIFFON_CLASS_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<GriffonClass> getAllClasses() {
        ArrayList<GriffonClass> arrayList = new ArrayList<GriffonClass>();
        Object object = this.lock;
        synchronized (object) {
            for (ArtifactHandler artifactHandler : this.artifactHandlers.values()) {
                arrayList.addAll(Arrays.asList(artifactHandler.getClasses()));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected <A extends GriffonArtifact> boolean isClassOfType(@Nonnull String string, @Nonnull Class<A> clazz) {
        for (Class<? extends GriffonArtifact> clazz2 : this.artifacts.get(string)) {
            if (!clazz2.getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }
}

