/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.artifact;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonArtifact;
import griffon.core.artifact.GriffonClass;
import griffon.core.artifact.GriffonController;
import griffon.core.artifact.GriffonModel;
import griffon.core.artifact.GriffonMvcArtifact;
import griffon.core.artifact.GriffonView;
import griffon.core.i18n.NoSuchMessageException;
import griffon.core.mvc.MVCFunction;
import griffon.core.mvc.MVCGroup;
import griffon.core.mvc.MVCGroupFunction;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGriffonArtifact
implements GriffonArtifact {
    private final Logger log;
    private final Object lock = new Object[0];
    @Inject
    protected GriffonApplication application;
    @GuardedBy(value="lock")
    private GriffonClass griffonClass;

    public AbstractGriffonArtifact() {
        this.log = LoggerFactory.getLogger((String)("griffon.app." + this.getArtifactType() + "." + this.getClass().getName()));
    }

    @Inject
    @Deprecated
    public AbstractGriffonArtifact(@Nonnull GriffonApplication griffonApplication) {
        this();
        this.application = griffonApplication;
    }

    @Override
    @Nonnull
    public GriffonApplication getApplication() {
        return this.application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public GriffonClass getGriffonClass() {
        Object object = this.lock;
        synchronized (object) {
            if (this.griffonClass == null) {
                this.griffonClass = this.application.getArtifactManager().findGriffonClass(this.getClass());
            }
            return this.griffonClass;
        }
    }

    @Override
    @Nonnull
    public Logger getLog() {
        return this.log;
    }

    @Nonnull
    protected abstract String getArtifactType();

    @Override
    public boolean isUIThread() {
        return this.application.getUIThreadManager().isUIThread();
    }

    @Override
    @Nonnull
    public <R> Future<R> runFuture(@Nonnull ExecutorService executorService, @Nonnull Callable<R> callable) {
        return this.application.getUIThreadManager().runFuture(executorService, callable);
    }

    @Override
    @Nonnull
    public <R> Future<R> runFuture(@Nonnull Callable<R> callable) {
        return this.application.getUIThreadManager().runFuture(callable);
    }

    @Override
    public void runInsideUISync(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runInsideUISync(runnable);
    }

    @Override
    public void runOutsideUI(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runOutsideUI(runnable);
    }

    @Override
    public void runInsideUIAsync(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runInsideUIAsync(runnable);
    }

    @Override
    @Nullable
    public <R> R runInsideUISync(@Nonnull Callable<R> callable) {
        return this.application.getUIThreadManager().runInsideUISync(callable);
    }

    @Override
    @Nonnull
    public ClassLoader classloader() {
        return this.application.getResourceHandler().classloader();
    }

    @Override
    @Nullable
    public URL getResourceAsURL(@Nonnull String string) {
        return this.application.getResourceHandler().getResourceAsURL(string);
    }

    @Override
    @Nullable
    public List<URL> getResources(@Nonnull String string) {
        return this.application.getResourceHandler().getResources(string);
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(@Nonnull String string) {
        return this.application.getResourceHandler().getResourceAsStream(string);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return this.application.getMvcGroupManager().createMVCGroup(map, string);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string) {
        return this.application.getMvcGroupManager().createMVC(string);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull String string2, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.application.getMvcGroupManager().withMVC(string, string2, mVCFunction);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull String string2) {
        return this.application.getMvcGroupManager().createMVC(string, string2);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2) {
        return this.application.getMvcGroupManager().createMVC(map, string, string2);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.application.getMvcGroupManager().withMVC(map, string, string2, mVCFunction);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2) {
        return this.application.getMvcGroupManager().createMVCGroup(map, string, string2);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map) {
        return this.application.getMvcGroupManager().createMVCGroup(string, string2, map);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return this.application.getMvcGroupManager().createMVC(map, string);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.application.getMvcGroupManager().withMVC(string, mVCFunction);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string) {
        return this.application.getMvcGroupManager().createMVCGroup(string);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull String string2) {
        return this.application.getMvcGroupManager().createMVCGroup(string, string2);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull Map<String, Object> map) {
        return this.application.getMvcGroupManager().createMVC(string, map);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.application.getMvcGroupManager().withMVC(map, string, mVCFunction);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.application.getMvcGroupManager().withMVC(string, map, mVCFunction);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull Map<String, Object> map) {
        return this.application.getMvcGroupManager().createMVCGroup(string, map);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map) {
        return this.application.getMvcGroupManager().createMVC(string, string2, map);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.application.getMvcGroupManager().withMVC(string, string2, map, mVCFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.application.getMvcGroupManager().withMVCGroup(map, string, mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.application.getMvcGroupManager().withMVCGroup(map, string, string2, mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.application.getMvcGroupManager().withMVCGroup(string, map, mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.application.getMvcGroupManager().withMVCGroup(string, mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.application.getMvcGroupManager().withMVCGroup(string, string2, map, mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.application.getMvcGroupManager().withMVCGroup(string, string2, mVCGroupFunction);
    }

    @Override
    public void destroyMVCGroup(@Nonnull String string) {
        this.application.getMvcGroupManager().destroyMVCGroup(string);
    }

    @Nonnull
    protected String msg(@Nonnull String string) throws NoSuchMessageException {
        return this.getApplication().getMessageSource().getMessage(string);
    }

    @Nonnull
    protected String msg(@Nonnull String string, @Nonnull List<?> list) throws NoSuchMessageException {
        return this.getApplication().getMessageSource().getMessage(string, list);
    }

    @Nonnull
    protected String msg(@Nonnull String string, @Nonnull Object[] objectArray) throws NoSuchMessageException {
        return this.getApplication().getMessageSource().getMessage(string, objectArray);
    }

    @Nonnull
    protected String msg(@Nonnull String string, @Nonnull Map<String, Object> map) throws NoSuchMessageException {
        return this.getApplication().getMessageSource().getMessage(string, map);
    }
}

