/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.artifact;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonClass;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.artifact.ClassPropertyFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGriffonClass
implements GriffonClass {
    private static final String ERROR_NAME_BLANK = "Argument 'name' must not be blank";
    private static final String ERROR_ARTIFACT_TYPE_BLANK = "Argument 'artifactType' must not be blank";
    private static final String ERROR_TYPE_NULL = "Argument 'type' must not be null";
    private static final String ERROR_APPLICATION_NULL = "Argument 'application' must not be null";
    private final GriffonApplication application;
    private final Class<?> clazz;
    private final String artifactType;
    private final String fullName;
    private final String name;
    private final String packageName;
    private final String naturalName;
    private final String shortName;
    private final String propertyName;
    private final String logicalPropertyName;
    private final ClassPropertyFetcher classPropertyFetcher;
    protected final Set<String> eventsCache = new TreeSet<String>();
    protected final Logger log;

    public AbstractGriffonClass(@Nonnull GriffonApplication griffonApplication, @Nonnull Class<?> clazz, @Nonnull String string, @Nonnull String string2) {
        this.application = Objects.requireNonNull(griffonApplication, ERROR_APPLICATION_NULL);
        this.clazz = Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        this.artifactType = GriffonNameUtils.requireNonBlank(string, ERROR_ARTIFACT_TYPE_BLANK).trim();
        string2 = GriffonNameUtils.isBlank(string2) ? "" : string2.trim();
        this.fullName = clazz.getName();
        this.log = LoggerFactory.getLogger((String)(this.getClass().getSimpleName() + "[" + this.fullName + "]"));
        this.packageName = GriffonClassUtils.getPackageName(clazz);
        this.naturalName = GriffonNameUtils.getNaturalName(clazz.getName());
        this.shortName = GriffonClassUtils.getShortClassName(clazz);
        this.name = GriffonNameUtils.getLogicalName(clazz, string2);
        this.propertyName = GriffonNameUtils.getPropertyNameRepresentation(this.shortName);
        this.logicalPropertyName = GriffonNameUtils.isBlank(this.name) ? this.propertyName : GriffonNameUtils.getPropertyNameRepresentation(this.name);
        this.classPropertyFetcher = ClassPropertyFetcher.forClass(clazz);
    }

    @Override
    @Nonnull
    public GriffonApplication getApplication() {
        return this.application;
    }

    @Override
    @Nullable
    public Object getPropertyValue(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        return this.getPropertyOrStaticPropertyOrFieldValue(string, Object.class);
    }

    @Override
    public boolean hasProperty(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        return this.classPropertyFetcher.isReadableProperty(string);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getShortName() {
        return this.shortName;
    }

    @Override
    @Nonnull
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @Nonnull
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    @Nonnull
    public String getLogicalPropertyName() {
        return this.logicalPropertyName;
    }

    @Override
    @Nonnull
    public String getNaturalName() {
        return this.naturalName;
    }

    @Override
    @Nonnull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @Nonnull
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    @Nonnull
    public String getArtifactType() {
        return this.artifactType;
    }

    @Override
    @Nullable
    public <T> T getPropertyValue(@Nonnull String string, @Nonnull Class<T> clazz) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        return null;
    }

    public String toString() {
        return "Artifact[" + this.artifactType + "] > " + this.getName();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        GriffonClass griffonClass = (GriffonClass)object;
        return this.clazz.getName().equals(griffonClass.getClazz().getName());
    }

    public int hashCode() {
        return this.clazz.hashCode() + this.artifactType.hashCode();
    }

    public void resetCaches() {
        this.eventsCache.clear();
    }

    @Nonnull
    public String[] getEventNames() {
        if (this.eventsCache.isEmpty()) {
            for (Method method : this.getClazz().getMethods()) {
                String string = method.getName();
                if (this.eventsCache.contains(string) || !GriffonClassUtils.isPlainMethod(method) || !GriffonClassUtils.isEventHandler(string)) continue;
                this.eventsCache.add(string.substring(2));
            }
        }
        return this.eventsCache.toArray(new String[this.eventsCache.size()]);
    }

    public String[] getPropertiesWithFields() {
        return this.classPropertyFetcher.getPropertiesWithFields();
    }

    public Class<?> getPropertyType(String string) {
        return this.classPropertyFetcher.getPropertyType(string);
    }

    public boolean isReadableProperty(String string) {
        return this.classPropertyFetcher.isReadableProperty(string);
    }

    protected Object getPropertyOrStaticPropertyOrFieldValue(@Nonnull String string, @Nonnull Class<?> clazz) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        Object object = this.classPropertyFetcher.getPropertyValue(string);
        return this.classPropertyFetcher.returnOnlyIfInstanceOf(object, clazz);
    }
}

