/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.artifact;

import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassPropertyFetcher {
    private final Class<?> clazz;
    final Map<String, PropertyFetcher> staticFetchers = new LinkedHashMap<String, PropertyFetcher>();
    final Map<String, PropertyFetcher> instanceFetchers = new LinkedHashMap<String, PropertyFetcher>();
    private final ReferenceInstanceCallback callback;
    private PropertyDescriptor[] propertyDescriptors;
    private String[] propertiesWithFields;
    private static final Map<Class<?>, ClassPropertyFetcher> CACHED_CLASS_PROPERTY_FETCHERS = new ConcurrentHashMap();

    public static void clearClassPropertyFetcherCache() {
        CACHED_CLASS_PROPERTY_FETCHERS.clear();
    }

    public static ClassPropertyFetcher forClass(Class<?> clazz) {
        return ClassPropertyFetcher.forClass(clazz, null);
    }

    public static ClassPropertyFetcher forClass(final Class<?> clazz, ReferenceInstanceCallback referenceInstanceCallback) {
        ClassPropertyFetcher classPropertyFetcher = CACHED_CLASS_PROPERTY_FETCHERS.get(clazz);
        if (classPropertyFetcher == null) {
            if (referenceInstanceCallback == null) {
                referenceInstanceCallback = new ReferenceInstanceCallback(){
                    private Object o;

                    @Override
                    public Object getReferenceInstance() {
                        if (this.o == null) {
                            this.o = GriffonClassUtils.instantiateClass(clazz);
                        }
                        return this.o;
                    }
                };
            }
            classPropertyFetcher = new ClassPropertyFetcher(clazz, referenceInstanceCallback);
            CACHED_CLASS_PROPERTY_FETCHERS.put(clazz, classPropertyFetcher);
        }
        return classPropertyFetcher;
    }

    ClassPropertyFetcher(Class<?> clazz, ReferenceInstanceCallback referenceInstanceCallback) {
        this.clazz = clazz;
        this.callback = referenceInstanceCallback;
        this.init();
    }

    public Object getReference() {
        if (this.callback != null) {
            return this.callback.getReferenceInstance();
        }
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public boolean isReadableProperty(String string) {
        return this.staticFetchers.containsKey(string) || this.instanceFetchers.containsKey(string);
    }

    public String[] getPropertiesWithFields() {
        return this.propertiesWithFields;
    }

    private void init() {
        FieldCallback fieldCallback = new FieldCallback(){

            @Override
            public void doWith(Field field) {
                if (field.isSynthetic()) {
                    return;
                }
                int n = field.getModifiers();
                if (!Modifier.isPublic(n)) {
                    return;
                }
                String string = field.getName();
                if (string.indexOf(36) == -1) {
                    boolean bl = Modifier.isStatic(n);
                    if (bl) {
                        ClassPropertyFetcher.this.staticFetchers.put(string, new FieldReaderFetcher(field, bl));
                    } else {
                        ClassPropertyFetcher.this.instanceFetchers.put(string, new FieldReaderFetcher(field, bl));
                    }
                }
            }
        };
        MethodCallback methodCallback = new MethodCallback(){

            @Override
            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String string;
                if (method.isSynthetic()) {
                    return;
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    return;
                }
                if (Modifier.isStatic(method.getModifiers()) && method.getReturnType() != Void.class && method.getParameterTypes().length == 0 && (string = method.getName()).indexOf(36) == -1) {
                    if (string.length() > 3 && string.startsWith("get") && Character.isUpperCase(string.charAt(3))) {
                        string = string.substring(3);
                    } else if (string.length() > 2 && string.startsWith("is") && Character.isUpperCase(string.charAt(2)) && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                        string = string.substring(2);
                    }
                    GetterPropertyFetcher getterPropertyFetcher = new GetterPropertyFetcher(method, true);
                    ClassPropertyFetcher.this.staticFetchers.put(string, getterPropertyFetcher);
                    ClassPropertyFetcher.this.staticFetchers.put(GriffonNameUtils.uncapitalize(string), getterPropertyFetcher);
                }
            }
        };
        List<Class<?>> list = this.resolveAllClasses(this.clazz);
        for (Class<?> clazz : list) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                try {
                    fieldCallback.doWith(field);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + illegalAccessException);
                }
            }
            Method[] object22 = clazz.getDeclaredMethods();
            for (Method method : object22) {
                try {
                    methodCallback.doWith(method);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + illegalAccessException);
                }
            }
        }
        this.propertyDescriptors = GriffonClassUtils.getPropertyDescriptors(this.clazz);
        for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) continue;
            int n = Modifier.isStatic(method.getModifiers()) ? 1 : 0;
            if (n != 0) {
                this.staticFetchers.put(propertyDescriptor.getName(), new GetterPropertyFetcher(method, n != 0));
                continue;
            }
            this.instanceFetchers.put(propertyDescriptor.getName(), new GetterPropertyFetcher(method, n != 0));
        }
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz : list) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (PropertyDescriptor propertyDescriptor : GriffonClassUtils.getPropertyDescriptors(this.clazz)) {
                arrayList2.add(propertyDescriptor.getName());
            }
            for (Field field : clazz.getDeclaredFields()) {
                String string;
                int n;
                if (field.isSynthetic() || !Modifier.isPrivate(n = field.getModifiers()) || Modifier.isStatic(n) || "class".equals(string = field.getName()) || "metaClass".equals(string) || string.indexOf(36) != -1 || !arrayList2.contains(string)) continue;
                arrayList.add(string);
            }
        }
        this.propertiesWithFields = arrayList.toArray(new String[arrayList.size()]);
    }

    private List<Class<?>> resolveAllClasses(Class<?> clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public Object getPropertyValue(String string) {
        return this.getPropertyValue(string, false);
    }

    public Object getPropertyValue(String string, boolean bl) {
        PropertyFetcher propertyFetcher = this.resolveFetcher(string, bl);
        return this.getPropertyValueWithFetcher(string, propertyFetcher);
    }

    private Object getPropertyValueWithFetcher(String string, PropertyFetcher propertyFetcher) {
        if (propertyFetcher != null) {
            try {
                return propertyFetcher.get(this.callback);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public <T> T getStaticPropertyValue(String string, Class<T> clazz) {
        PropertyFetcher propertyFetcher = this.staticFetchers.get(string);
        if (propertyFetcher != null) {
            Object object = this.getPropertyValueWithFetcher(string, propertyFetcher);
            return this.returnOnlyIfInstanceOf(object, clazz);
        }
        return null;
    }

    public <T> T getPropertyValue(String string, Class<T> clazz) {
        return this.returnOnlyIfInstanceOf(this.getPropertyValue(string, false), clazz);
    }

    public <T> T returnOnlyIfInstanceOf(Object object, Class<T> clazz) {
        if (object != null && (clazz == Object.class || clazz.isAssignableFrom(object.getClass()))) {
            return (T)object;
        }
        return null;
    }

    private PropertyFetcher resolveFetcher(String string, boolean bl) {
        PropertyFetcher propertyFetcher = null;
        if (!bl) {
            propertyFetcher = this.staticFetchers.get(string);
        }
        if (propertyFetcher == null) {
            propertyFetcher = this.instanceFetchers.get(string);
        }
        return propertyFetcher;
    }

    public Class<?> getPropertyType(String string) {
        return this.getPropertyType(string, false);
    }

    public Class<?> getPropertyType(String string, boolean bl) {
        PropertyFetcher propertyFetcher = this.resolveFetcher(string, bl);
        if (propertyFetcher != null) {
            return propertyFetcher.getPropertyType(string);
        }
        return null;
    }

    private static void makeAccessible(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            try {
                accessibleObject.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    static class FieldReaderFetcher
    implements PropertyFetcher {
        private final Field field;
        private final boolean staticField;

        public FieldReaderFetcher(Field field, boolean bl) {
            this.field = field;
            this.staticField = bl;
            ClassPropertyFetcher.makeAccessible(field);
        }

        @Override
        public Object get(ReferenceInstanceCallback referenceInstanceCallback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticField) {
                return this.field.get(null);
            }
            if (referenceInstanceCallback != null) {
                return this.field.get(referenceInstanceCallback.getReferenceInstance());
            }
            return null;
        }

        @Override
        public Class<?> getPropertyType(String string) {
            return this.field.getType();
        }
    }

    static class GetterPropertyFetcher
    implements PropertyFetcher {
        private final Method readMethod;
        private final boolean staticMethod;

        GetterPropertyFetcher(Method method, boolean bl) {
            this.readMethod = method;
            this.staticMethod = bl;
            ClassPropertyFetcher.makeAccessible(method);
        }

        @Override
        public Object get(ReferenceInstanceCallback referenceInstanceCallback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticMethod) {
                return this.readMethod.invoke(null, new Object[0]);
            }
            if (referenceInstanceCallback != null) {
                return this.readMethod.invoke(referenceInstanceCallback.getReferenceInstance(), new Object[0]);
            }
            return null;
        }

        @Override
        public Class<?> getPropertyType(String string) {
            return this.readMethod.getReturnType();
        }
    }

    static interface PropertyFetcher {
        public Object get(ReferenceInstanceCallback var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public Class<?> getPropertyType(String var1);
    }

    public static interface ReferenceInstanceCallback {
        public Object getReferenceInstance();
    }
}

