/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.artifact;

import griffon.core.ApplicationClassLoader;
import griffon.core.artifact.ArtifactHandler;
import griffon.core.artifact.GriffonArtifact;
import griffon.inject.Typed;
import griffon.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.artifact.AbstractArtifactManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactManager
extends AbstractArtifactManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultArtifactManager.class);
    private final ApplicationClassLoader applicationClassLoader;

    @Inject
    public DefaultArtifactManager(@Nonnull ApplicationClassLoader applicationClassLoader) {
        this.applicationClassLoader = Objects.requireNonNull(applicationClassLoader, "Argument 'applicationClassLoader' must not be null");
    }

    @Override
    @Nonnull
    protected Map<String, List<Class<? extends GriffonArtifact>>> doLoadArtifactMetadata() {
        final LinkedHashMap<String, List<Class<? extends GriffonArtifact>>> linkedHashMap = new LinkedHashMap<String, List<Class<? extends GriffonArtifact>>>();
        for (Map.Entry<String, ArtifactHandler> entry : this.getArtifactHandlers().entrySet()) {
            final String string = entry.getKey();
            ArtifactHandler artifactHandler = entry.getValue();
            Class<?> clazz = artifactHandler.getClass().getAnnotation(Typed.class).value();
            ServiceLoaderUtils.load(this.applicationClassLoader.get(), "META-INF/griffon/", clazz, new ServiceLoaderUtils.LineProcessor(){

                @Override
                public void process(@Nonnull ClassLoader classLoader, @Nonnull Class<?> clazz, @Nonnull String string3) {
                    ArrayList arrayList = (ArrayList)linkedHashMap.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                        linkedHashMap.put(string, arrayList);
                    }
                    try {
                        String string2 = string3.trim();
                        Class<?> clazz2 = DefaultArtifactManager.this.applicationClassLoader.get().loadClass(string2);
                        arrayList.add(clazz2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IllegalArgumentException(classNotFoundException);
                    }
                }
            });
        }
        for (Map.Entry<String, ArtifactHandler<Object>> entry : linkedHashMap.entrySet()) {
            LOG.debug("Artifacts of type '{}' = {}", (Object)entry.getKey(), (Object)((List)((Object)entry.getValue())).size());
        }
        return linkedHashMap;
    }
}

