/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.artifact;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonModel;
import griffon.core.artifact.GriffonModelClass;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.artifact.DefaultGriffonClass;

public class DefaultGriffonModelClass
extends DefaultGriffonClass
implements GriffonModelClass {
    private static final String ERROR_MODEL_NULL = "Argument 'model' must not be null";
    private static final String ERROR_PROPERTY_NAME_BLANK = "Argument 'propertyName' must not be blank";
    protected final Set<String> propertiesCache = new TreeSet<String>();
    private static final Set<String> BINDABLE_PROPERTIES = new LinkedHashSet<String>(Arrays.asList("propertyChangeListeners", "vetoableChangeListeners"));

    public DefaultGriffonModelClass(@Nonnull GriffonApplication griffonApplication, @Nonnull Class<?> clazz) {
        super(griffonApplication, clazz, "model", "Model");
    }

    @Override
    public void resetCaches() {
        super.resetCaches();
        this.propertiesCache.clear();
    }

    @Override
    @Nonnull
    public String[] getPropertyNames() {
        if (this.propertiesCache.isEmpty()) {
            for (String string : this.getPropertiesWithFields()) {
                if (this.propertiesCache.contains(string) || GriffonClassUtils.isEventHandler(string) || STANDARD_PROPERTIES.contains(string) || BINDABLE_PROPERTIES.contains(string)) continue;
                this.propertiesCache.add(string);
            }
        }
        return this.propertiesCache.toArray(new String[this.propertiesCache.size()]);
    }

    @Override
    public void setModelPropertyValue(@Nonnull GriffonModel griffonModel, @Nonnull String string, @Nullable Object object) {
        Objects.requireNonNull(griffonModel, ERROR_MODEL_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_PROPERTY_NAME_BLANK);
        GriffonClassUtils.setPropertyValue(griffonModel, string, object);
    }

    @Override
    @Nullable
    public Object getModelPropertyValue(@Nonnull GriffonModel griffonModel, @Nonnull String string) {
        Objects.requireNonNull(griffonModel, ERROR_MODEL_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_PROPERTY_NAME_BLANK);
        return GriffonClassUtils.getPropertyValue(griffonModel, string);
    }
}

