/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.artifact;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonServiceClass;
import griffon.util.GriffonClassUtils;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.codehaus.griffon.runtime.core.artifact.DefaultGriffonClass;

public class DefaultGriffonServiceClass
extends DefaultGriffonClass
implements GriffonServiceClass {
    protected final Set<String> serviceCache = new TreeSet<String>();

    public DefaultGriffonServiceClass(@Nonnull GriffonApplication griffonApplication, @Nonnull Class<?> clazz) {
        super(griffonApplication, clazz, "service", "Service");
    }

    @Override
    public void resetCaches() {
        super.resetCaches();
        this.serviceCache.clear();
    }

    @Override
    @Nonnull
    public String[] getServiceNames() {
        if (this.serviceCache.isEmpty()) {
            for (Method method : this.getClazz().getMethods()) {
                String string = method.getName();
                if (this.serviceCache.contains(string) || !GriffonClassUtils.isPlainMethod(method) || GriffonClassUtils.isEventHandler(string)) continue;
                this.serviceCache.add(string);
            }
        }
        return this.serviceCache.toArray(new String[this.serviceCache.size()]);
    }
}

