/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.controller;

import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.core.controller.ActionManager;
import griffon.util.GriffonNameUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.AbstractObservable;

public abstract class AbstractAction
extends AbstractObservable
implements Action {
    private String name;
    private boolean enabled = true;
    private final ActionManager actionManager;
    private final GriffonController controller;
    private final String actionName;
    private boolean initialized;
    private final Object lock = new Object[0];

    public AbstractAction(@Nonnull ActionManager actionManager, @Nonnull GriffonController griffonController, @Nonnull String string) {
        this.actionManager = Objects.requireNonNull(actionManager, "Argument 'actionManager' must not be null");
        this.controller = Objects.requireNonNull(griffonController, "Argument 'controller' must not be null");
        this.actionName = GriffonNameUtils.requireNonBlank(string, "Argument 'actionName' must not be blank");
    }

    @Override
    @Nonnull
    public ActionManager getActionManager() {
        return this.actionManager;
    }

    @Override
    @Nonnull
    public GriffonController getController() {
        return this.controller;
    }

    @Override
    @Nonnull
    public String getActionName() {
        return this.actionName;
    }

    @Override
    @Nonnull
    public String getFullyQualifiedName() {
        return this.getController().getClass().getName() + "." + this.getActionName();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.firePropertyChange("enabled", this.enabled, this.enabled);
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@Nullable String string) {
        this.name = string;
        this.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public final void execute(Object ... objectArray) {
        if (this.isEnabled()) {
            this.doExecute(objectArray);
        }
    }

    protected abstract void doExecute(Object ... var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initialize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.doInitialize();
            this.initialized = true;
        }
    }

    protected abstract void doInitialize();
}

