/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.controller;

import griffon.core.Configuration;
import griffon.core.Context;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.core.artifact.GriffonController;
import griffon.core.artifact.GriffonControllerClass;
import griffon.core.controller.AbortActionExecution;
import griffon.core.controller.Action;
import griffon.core.controller.ActionExecutionStatus;
import griffon.core.controller.ActionHandler;
import griffon.core.controller.ActionInterceptor;
import griffon.core.controller.ActionManager;
import griffon.core.i18n.MessageSource;
import griffon.core.i18n.NoSuchMessageException;
import griffon.core.mvc.MVCGroup;
import griffon.core.threading.UIThreadManager;
import griffon.exceptions.GriffonException;
import griffon.exceptions.InstanceMethodInvocationException;
import griffon.inject.Contextual;
import griffon.transform.Threading;
import griffon.util.AnnotationUtils;
import griffon.util.CollectionUtils;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.griffon.runtime.core.controller.ActionDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionManager
implements ActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractActionManager.class);
    private static final String KEY_THREADING = "controller.threading";
    private static final String KEY_THREADING_DEFAULT = "controller.threading.default";
    private static final String KEY_DISABLE_THREADING_INJECTION = "griffon.disable.threading.injection";
    private static final String ERROR_CONTROLLER_NULL = "Argument 'controller' must not be null";
    private static final String ERROR_ACTION_NAME_BLANK = "Argument 'actionName' must not be blank";
    private static final String ERROR_ACTION_HANDLER_NULL = "Argument 'actionHandler' must not be null";
    private static final String ERROR_ACTION_NULL = "Argument 'action' must not be null";
    private final ActionCache actionCache = new ActionCache();
    private final Map<String, Threading.Policy> threadingPolicies = new ConcurrentHashMap<String, Threading.Policy>();
    private final List<ActionHandler> handlers = new CopyOnWriteArrayList<ActionHandler>();
    private final GriffonApplication application;

    @Inject
    public AbstractActionManager(@Nonnull GriffonApplication griffonApplication) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
    }

    @Nullable
    private static Method findActionAsMethod(@Nonnull GriffonController griffonController, @Nonnull String string) {
        for (Method method : griffonController.getClass().getMethods()) {
            if (!string.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE) continue;
            return method;
        }
        return null;
    }

    @Nonnull
    protected Configuration getConfiguration() {
        return this.application.getConfiguration();
    }

    @Nonnull
    protected MessageSource getMessageSource() {
        return this.application.getMessageSource();
    }

    @Nonnull
    protected UIThreadManager getUiThreadManager() {
        return this.application.getUIThreadManager();
    }

    @Nonnull
    protected Map<String, Threading.Policy> getThreadingPolicies() {
        return this.threadingPolicies;
    }

    @Override
    @Nonnull
    public Map<String, Action> actionsFor(@Nonnull GriffonController griffonController) {
        Objects.requireNonNull(griffonController, ERROR_CONTROLLER_NULL);
        Map<String, ActionWrapper> map = this.actionCache.get(griffonController);
        if (map.isEmpty()) {
            LOG.trace("No actions defined for controller {}", (Object)griffonController);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    @Nullable
    public Action actionFor(@Nonnull GriffonController griffonController, @Nonnull String string) {
        Objects.requireNonNull(griffonController, ERROR_CONTROLLER_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_ACTION_NAME_BLANK);
        return this.actionCache.get(griffonController).get(this.normalizeName(string));
    }

    @Override
    public void createActions(@Nonnull GriffonController griffonController) {
        GriffonControllerClass griffonControllerClass = (GriffonControllerClass)griffonController.getGriffonClass();
        for (String string : griffonControllerClass.getActionNames()) {
            Method method = AbstractActionManager.findActionAsMethod(griffonController, string);
            if (method == null) {
                throw new GriffonException(griffonController.getClass().getCanonicalName() + " does not define an action named " + string);
            }
            ActionWrapper actionWrapper = this.wrapAction(this.createAndConfigureAction(griffonController, string), method);
            String string2 = actionWrapper.getFullyQualifiedName();
            for (ActionHandler actionHandler : this.handlers) {
                LOG.debug("Configuring action {} with {}", (Object)string2, (Object)actionHandler);
                actionHandler.configure(actionWrapper, method);
            }
            Map<String, ActionWrapper> map = this.actionCache.get(griffonController);
            if (map.isEmpty()) {
                map = new TreeMap<String, ActionWrapper>();
                this.actionCache.set(griffonController, map);
            }
            String object2 = this.normalizeName(string);
            LOG.trace("Action for {} stored as {}", (Object)string2, (Object)object2);
            map.put(object2, actionWrapper);
        }
    }

    @Nonnull
    private ActionWrapper wrapAction(@Nonnull Action action, @Nonnull Method method) {
        return new ActionWrapper(action, method);
    }

    @Override
    public void updateActions() {
        for (Action action : this.actionCache.allActions()) {
            this.updateAction(action);
        }
    }

    @Override
    public void updateActions(@Nonnull GriffonController griffonController) {
        for (Action action : this.actionsFor(griffonController).values()) {
            this.updateAction(action);
        }
    }

    @Override
    public void updateAction(@Nonnull Action action) {
        Objects.requireNonNull(action, ERROR_ACTION_NULL);
        String string = action.getFullyQualifiedName();
        for (ActionHandler actionHandler : this.handlers) {
            LOG.trace("Calling {}.update() on {}", (Object)actionHandler, (Object)string);
            actionHandler.update(action);
        }
    }

    @Override
    public void updateAction(@Nonnull GriffonController griffonController, @Nonnull String string) {
        Objects.requireNonNull(griffonController, ERROR_CONTROLLER_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_ACTION_NAME_BLANK);
        this.updateAction(this.actionFor(griffonController, string));
    }

    @Override
    public void invokeAction(final @Nonnull Action action, final Object ... objectArray) {
        Objects.requireNonNull(action, ERROR_ACTION_NULL);
        final GriffonController griffonController = action.getController();
        final String string = action.getActionName();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] objectArray2 = objectArray;
                ArrayList arrayList = new ArrayList(AbstractActionManager.this.handlers);
                ArrayList<ActionHandler> arrayList2 = new ArrayList<ActionHandler>();
                String string2 = action.getFullyQualifiedName();
                ActionExecutionStatus actionExecutionStatus = ActionExecutionStatus.OK;
                try {
                    LOG.trace("Resolving contextual arguments for " + string2);
                    objectArray2 = AbstractActionManager.this.injectFromContext(action, objectArray2);
                }
                catch (IllegalStateException illegalStateException) {
                    LOG.debug("Execution of " + string2 + " was aborted", (Throwable)illegalStateException);
                    throw illegalStateException;
                }
                if (LOG.isDebugEnabled()) {
                    int n = arrayList.size();
                    LOG.debug("Executing " + n + " handler" + (n != 1 ? "s" : "") + " for " + string2);
                }
                for (ActionHandler actionHandler : arrayList) {
                    arrayList2.add(actionHandler);
                    try {
                        LOG.trace("Calling {}.before() on {}", (Object)actionHandler, (Object)string2);
                        objectArray2 = actionHandler.before(action, objectArray2);
                    }
                    catch (AbortActionExecution abortActionExecution) {
                        actionExecutionStatus = ActionExecutionStatus.ABORTED;
                        LOG.debug("Execution of {} was aborted by {}", (Object)string2, (Object)actionHandler);
                        break;
                    }
                }
                LOG.trace("Status before execution of {} is {}", (Object)string2, (Object)actionExecutionStatus);
                Object object = null;
                boolean bl = false;
                if (actionExecutionStatus == ActionExecutionStatus.OK) {
                    try {
                        AbstractActionManager.this.doInvokeAction(griffonController, string, objectArray2);
                    }
                    catch (RuntimeException runtimeException) {
                        actionExecutionStatus = ActionExecutionStatus.EXCEPTION;
                        object = (RuntimeException)GriffonExceptionHandler.sanitize(runtimeException);
                        LOG.warn("An exception occurred when executing {}", (Object)string2, object);
                    }
                    LOG.trace("Status after execution of {} is {}", (Object)string2, (Object)actionExecutionStatus);
                    if (object != null) {
                        for (ActionHandler actionHandler : CollectionUtils.reverse(arrayList2)) {
                            LOG.trace("Calling {}.exception() on {}", (Object)actionHandler, (Object)string2);
                            bl = actionHandler.exception((Exception)object, action, objectArray2);
                        }
                    }
                }
                for (ActionHandler actionHandler : CollectionUtils.reverse(arrayList2)) {
                    LOG.trace("Calling {}.after() on {}", (Object)actionHandler, (Object)string2);
                    actionHandler.after(actionExecutionStatus, action, objectArray2);
                }
                if (object != null && !bl) {
                    throw object;
                }
            }
        };
        this.invokeAction(griffonController, string, runnable);
    }

    @Nonnull
    private Object[] injectFromContext(@Nonnull Action action, @Nonnull Object[] objectArray) {
        ActionWrapper actionWrapper = null;
        actionWrapper = action instanceof ActionWrapper ? (ActionWrapper)action : this.wrapAction(action, AbstractActionManager.findActionAsMethod(action.getController(), action.getActionName()));
        MVCGroup mVCGroup = action.getController().getMvcGroup();
        if (mVCGroup == null) {
            return objectArray;
        }
        Context context = mVCGroup.getContext();
        if (actionWrapper.hasContextualArgs) {
            Object[] objectArray2 = new Object[actionWrapper.argumentsInfo.size()];
            for (int i = 0; i < objectArray2.length; ++i) {
                ArgInfo argInfo = (ArgInfo)actionWrapper.argumentsInfo.get(i);
                Object object = objectArray2[i] = argInfo.contextual ? context.get(argInfo.name) : objectArray[i];
                if (argInfo.contextual && objectArray2[i] != null) {
                    context.put(argInfo.name, objectArray2[i]);
                }
                if (!argInfo.contextual || argInfo.nullable || objectArray2[i] != null) continue;
                throw new IllegalStateException("Could not find an instance of type " + argInfo.type.getName() + " under key '" + argInfo.name + "' in the context of MVCGroup[" + mVCGroup.getMvcType() + ":" + mVCGroup.getMvcId() + "] to be injected as argument " + i + " at " + action.getFullyQualifiedName() + "(). Argument does not accept null values.");
            }
            return objectArray2;
        }
        return objectArray;
    }

    @Override
    public void invokeAction(@Nonnull GriffonController griffonController, @Nonnull String string, Object ... objectArray) {
        Objects.requireNonNull(griffonController, ERROR_CONTROLLER_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_ACTION_NAME_BLANK);
        this.invokeAction(this.actionFor(griffonController, string), objectArray);
    }

    protected void doInvokeAction(@Nonnull GriffonController griffonController, @Nonnull String string, @Nonnull Object[] objectArray) {
        try {
            GriffonClassUtils.invokeInstanceMethod((Object)griffonController, string, objectArray);
        }
        catch (InstanceMethodInvocationException instanceMethodInvocationException) {
            if (instanceMethodInvocationException.getCause() instanceof NoSuchMethodException) {
                if (objectArray.length == 1 && objectArray[0] != null && EventObject.class.isAssignableFrom(objectArray[0].getClass())) {
                    GriffonClassUtils.invokeExactInstanceMethod((Object)griffonController, string, GriffonClassUtils.EMPTY_ARGS);
                }
                throw instanceMethodInvocationException;
            }
            throw instanceMethodInvocationException;
        }
    }

    private void invokeAction(@Nonnull GriffonController griffonController, @Nonnull String string, @Nonnull Runnable runnable) {
        String string2 = griffonController.getClass().getName() + "." + string;
        Threading.Policy policy = this.threadingPolicies.get(string2);
        if (policy == null) {
            policy = this.isThreadingDisabled(string2) ? Threading.Policy.SKIP : this.resolveThreadingPolicy(griffonController, string);
            this.threadingPolicies.put(string2, policy);
        }
        LOG.debug("Executing {} with policy {}", (Object)string2, (Object)policy);
        switch (policy) {
            case OUTSIDE_UITHREAD: {
                this.getUiThreadManager().runOutsideUI(runnable);
                break;
            }
            case INSIDE_UITHREAD_SYNC: {
                this.getUiThreadManager().runInsideUISync(runnable);
                break;
            }
            case INSIDE_UITHREAD_ASYNC: {
                this.getUiThreadManager().runInsideUIAsync(runnable);
                break;
            }
            default: {
                runnable.run();
            }
        }
    }

    @Nonnull
    private Threading.Policy resolveThreadingPolicy(@Nonnull GriffonController griffonController, @Nonnull String string) {
        Method method = AbstractActionManager.findActionAsMethod(griffonController, string);
        if (method != null) {
            Threading threading = method.getAnnotation(Threading.class);
            return threading == null ? this.resolveThreadingPolicy(griffonController) : threading.value();
        }
        return Threading.Policy.OUTSIDE_UITHREAD;
    }

    @Nonnull
    private Threading.Policy resolveThreadingPolicy(@Nonnull GriffonController griffonController) {
        Threading threading = AnnotationUtils.findAnnotation(griffonController.getClass(), Threading.class);
        return threading == null ? this.resolveThreadingPolicy() : threading.value();
    }

    @Nonnull
    private Threading.Policy resolveThreadingPolicy() {
        String string;
        Object object = this.getConfiguration().get(KEY_THREADING_DEFAULT);
        if (object == null) {
            return Threading.Policy.OUTSIDE_UITHREAD;
        }
        if (object instanceof Threading.Policy) {
            return (Threading.Policy)((Object)object);
        }
        switch (string = String.valueOf(object).toLowerCase()) {
            case "sync": 
            case "inside sync": 
            case "inside uithread sync": 
            case "inside_uithread_sync": {
                return Threading.Policy.INSIDE_UITHREAD_SYNC;
            }
            case "async": 
            case "inside async": 
            case "inside uithread async": 
            case "inside_uithread_async": {
                return Threading.Policy.INSIDE_UITHREAD_ASYNC;
            }
            case "outside": 
            case "outside uithread": 
            case "outside_uithread": {
                return Threading.Policy.OUTSIDE_UITHREAD;
            }
            case "skip": {
                return Threading.Policy.SKIP;
            }
        }
        throw new IllegalArgumentException("Value '" + string + "' cannot be translated into " + Threading.Policy.class.getName());
    }

    private boolean isThreadingDisabled(@Nonnull String string) {
        if (this.getConfiguration().getAsBoolean(KEY_DISABLE_THREADING_INJECTION, false)) {
            return true;
        }
        Map<String, Object> map = this.getConfiguration().asFlatMap();
        String string2 = "controller.threading." + string;
        while (!KEY_THREADING.equals(string2)) {
            Object object = map.get(string2);
            string2 = string2.substring(0, string2.lastIndexOf("."));
            if (object == null || TypeUtils.castToBoolean(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addActionHandler(@Nonnull ActionHandler actionHandler) {
        Objects.requireNonNull(actionHandler, ERROR_ACTION_HANDLER_NULL);
        if (this.handlers.contains(actionHandler)) {
            return;
        }
        this.handlers.add(actionHandler);
    }

    @Override
    public void addActionInterceptor(@Nonnull ActionInterceptor actionInterceptor) {
        throw new UnsupportedOperationException(ActionInterceptor.class.getName() + " have been deprecated and are no longer supported");
    }

    @Nonnull
    protected Action createAndConfigureAction(@Nonnull GriffonController griffonController, @Nonnull String string) {
        Objects.requireNonNull(griffonController, ERROR_CONTROLLER_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_ACTION_NAME_BLANK);
        Action action = this.createControllerAction(griffonController, string);
        String string2 = GriffonNameUtils.capitalize(this.normalizeName(string));
        String string3 = griffonController.getClass().getName() + ".action.";
        String string4 = this.msg(string3, string2, "name", GriffonNameUtils.getNaturalName(string2));
        if (!GriffonNameUtils.isBlank(string4)) {
            LOG.trace("{}{}.name = {}", new Object[]{string3, string2, string4});
            action.setName(string4);
        }
        this.doConfigureAction(action, griffonController, string2, string3);
        action.initialize();
        return action;
    }

    protected abstract void doConfigureAction(@Nonnull Action var1, @Nonnull GriffonController var2, @Nonnull String var3, @Nonnull String var4);

    @Nonnull
    protected abstract Action createControllerAction(@Nonnull GriffonController var1, @Nonnull String var2);

    @Override
    @Nonnull
    public String normalizeName(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_ACTION_NAME_BLANK);
        if (string.endsWith("Action")) {
            string = string.substring(0, string.length() - "Action".length());
        }
        return GriffonNameUtils.uncapitalize(string);
    }

    @Nullable
    protected String msg(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, @Nullable String string4) {
        try {
            return this.getMessageSource().getMessage(string + string2 + "." + string3);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            return this.getMessageSource().getMessage("application.action." + string2 + "." + string3, string4);
        }
    }

    private static class ActionCache {
        private final Map<WeakReference<GriffonController>, Map<String, ActionWrapper>> cache = new ConcurrentHashMap<WeakReference<GriffonController>, Map<String, ActionWrapper>>();

        private ActionCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public Map<String, ActionWrapper> get(@Nonnull GriffonController griffonController) {
            Map<WeakReference<GriffonController>, Map<String, ActionWrapper>> map = this.cache;
            synchronized (map) {
                for (Map.Entry<WeakReference<GriffonController>, Map<String, ActionWrapper>> entry : this.cache.entrySet()) {
                    GriffonController griffonController2 = (GriffonController)entry.getKey().get();
                    if (griffonController2 != griffonController) continue;
                    return entry.getValue();
                }
            }
            return Collections.emptyMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(@Nonnull GriffonController griffonController, @Nonnull Map<String, ActionWrapper> map) {
            WeakReference<GriffonController> weakReference = null;
            Map<WeakReference<GriffonController>, Map<String, ActionWrapper>> map2 = this.cache;
            synchronized (map2) {
                for (WeakReference<GriffonController> weakReference2 : this.cache.keySet()) {
                    if (weakReference2.get() != griffonController) continue;
                    weakReference = weakReference2;
                    break;
                }
            }
            if (null != weakReference) {
                this.cache.remove(weakReference);
            }
            this.cache.put(new WeakReference<GriffonController>(griffonController), map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Action> allActions() {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            Map<WeakReference<GriffonController>, Map<String, ActionWrapper>> map = this.cache;
            synchronized (map) {
                for (Map<String, ActionWrapper> map2 : this.cache.values()) {
                    arrayList.addAll(map2.values());
                }
            }
            return arrayList;
        }
    }

    private static class ArgInfo {
        private Class<?> type;
        private String name;
        private boolean nullable = true;
        private boolean contextual = false;

        private ArgInfo() {
        }
    }

    private static class ActionWrapper
    extends ActionDecorator {
        private final List<ArgInfo> argumentsInfo = new ArrayList<ArgInfo>();
        private boolean hasContextualArgs;

        public ActionWrapper(@Nonnull Action action, @Nonnull Method method) {
            super(action);
            Class<?>[] classArray = method.getParameterTypes();
            Annotation[][] annotationArray = method.getParameterAnnotations();
            this.hasContextualArgs = method.getAnnotation(Contextual.class) != null;
            for (int i = 0; i < classArray.length; ++i) {
                ArgInfo argInfo = new ArgInfo();
                argInfo.type = classArray[i];
                argInfo.name = argInfo.type.getCanonicalName();
                Annotation[] annotationArray2 = annotationArray[i];
                if (annotationArray2 != null) {
                    for (Annotation annotation : annotationArray2) {
                        Named named;
                        if (Contextual.class.isAssignableFrom(annotation.annotationType())) {
                            this.hasContextualArgs = true;
                            argInfo.contextual = true;
                        }
                        if (Nonnull.class.isAssignableFrom(annotation.annotationType())) {
                            argInfo.nullable = false;
                        }
                        if (!Named.class.isAssignableFrom(annotation.annotationType()) || GriffonNameUtils.isBlank((named = (Named)annotation).value())) continue;
                        argInfo.name = named.value();
                    }
                }
                this.argumentsInfo.add(argInfo);
            }
        }
    }
}

