/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.controller;

import griffon.core.artifact.GriffonController;
import griffon.core.controller.ActionManager;
import griffon.core.threading.UIThreadManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.griffon.runtime.core.controller.AbstractAction;
import org.codehaus.griffon.runtime.core.controller.DefaultToolkitAction;

public class DefaultAction
extends AbstractAction {
    private final DefaultToolkitAction toolkitAction;

    public DefaultAction(final @Nonnull UIThreadManager uIThreadManager, final @Nonnull ActionManager actionManager, final @Nonnull GriffonController griffonController, final @Nonnull String string) {
        super(actionManager, griffonController, string);
        Objects.requireNonNull(uIThreadManager, "Argument 'uiThreadManager' must not be null");
        this.toolkitAction = new DefaultToolkitAction(new Runnable(){

            @Override
            public void run() {
                actionManager.invokeAction(griffonController, string, new Object[0]);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                uIThreadManager.runInsideUIAsync(new Runnable(){

                    @Override
                    public void run() {
                        DefaultAction.this.toolkitAction.setName(String.valueOf(propertyChangeEvent.getNewValue()));
                    }
                });
            }
        });
    }

    @Override
    @Nonnull
    public Object getToolkitAction() {
        return this.toolkitAction;
    }

    @Override
    protected void doExecute(Object ... objectArray) {
        this.toolkitAction.execute();
    }

    @Override
    protected void doInitialize() {
        this.toolkitAction.setName(this.getName());
    }
}

