/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.env;

import griffon.core.env.Environment;
import griffon.core.env.Metadata;
import javax.inject.Inject;
import javax.inject.Provider;

public class EnvironmentProvider
implements Provider<Environment> {
    @Inject
    private Metadata metadata;

    private static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    public Environment get() {
        String string = System.getProperty("griffon.env");
        if (this.metadata != null && EnvironmentProvider.isBlank(string)) {
            string = this.metadata.getEnvironment();
        }
        if (EnvironmentProvider.isBlank(string)) {
            return Environment.DEVELOPMENT;
        }
        Environment environment = Environment.resolveEnvironment(string);
        if (environment == null) {
            try {
                environment = Environment.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (environment == null) {
            environment = Environment.CUSTOM;
            environment.setName(string);
        }
        return environment;
    }
}

