/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.env;

import griffon.core.env.Metadata;
import griffon.core.env.RunMode;
import javax.inject.Inject;
import javax.inject.Provider;

public class RunModeProvider
implements Provider<RunMode> {
    @Inject
    private Metadata metadata;

    private static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    public RunMode get() {
        String string = System.getProperty("griffon.runmode");
        if (this.metadata != null && RunModeProvider.isBlank(string)) {
            string = this.metadata.getRunMode();
        }
        if (RunModeProvider.isBlank(string)) {
            return RunMode.STANDALONE;
        }
        RunMode runMode = RunMode.resolveRunMode(string);
        if (runMode == null) {
            try {
                runMode = RunMode.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (runMode == null) {
            runMode = RunMode.CUSTOM;
            runMode.setName(string);
        }
        return runMode;
    }
}

