/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.event;

import griffon.core.CallableWithArgs;
import griffon.core.RunnableWithArgs;
import griffon.core.event.Event;
import griffon.core.event.EventPublisher;
import griffon.core.event.EventRouter;
import griffon.util.GriffonNameUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public abstract class AbstractEventPublisher
implements EventPublisher {
    private static final String ERROR_EVENT_NAME_BLANK = "Argument 'eventName' must not be blank";
    private static final String ERROR_LISTENER_NULL = "Argument 'listener' must not be null";
    private static final String ERROR_EVENT_CLASS_NULL = "Argument 'eventClass' must not be null";
    private static final String ERROR_EVENT_NULL = "Argument 'event' must not be null";
    private EventRouter eventRouter;

    @Inject
    public void setEventRouter(@Nonnull EventRouter eventRouter) {
        this.eventRouter = Objects.requireNonNull(eventRouter, "Argument 'eventRouter' must not be null");
    }

    @Override
    public boolean isEventPublishingEnabled() {
        return this.eventRouter.isEventPublishingEnabled();
    }

    @Override
    public void setEventPublishingEnabled(boolean bl) {
        this.eventRouter.setEventPublishingEnabled(bl);
    }

    @Override
    public <E extends Event> void removeEventListener(@Nonnull Class<E> clazz, @Nonnull CallableWithArgs<?> callableWithArgs) {
        Objects.requireNonNull(clazz, ERROR_EVENT_CLASS_NULL);
        Objects.requireNonNull(callableWithArgs, ERROR_LISTENER_NULL);
        this.eventRouter.removeEventListener(clazz, callableWithArgs);
    }

    @Override
    public <E extends Event> void removeEventListener(@Nonnull Class<E> clazz, @Nonnull RunnableWithArgs runnableWithArgs) {
        Objects.requireNonNull(clazz, ERROR_EVENT_CLASS_NULL);
        Objects.requireNonNull(runnableWithArgs, ERROR_LISTENER_NULL);
        this.eventRouter.removeEventListener(clazz, runnableWithArgs);
    }

    @Override
    public void addEventListener(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_LISTENER_NULL);
        this.eventRouter.addEventListener(object);
    }

    @Override
    public void addEventListener(@Nonnull String string, @Nonnull CallableWithArgs<?> callableWithArgs) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        Objects.requireNonNull(callableWithArgs, ERROR_LISTENER_NULL);
        this.eventRouter.addEventListener(string, callableWithArgs);
    }

    @Override
    public void addEventListener(@Nonnull String string, @Nonnull RunnableWithArgs runnableWithArgs) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        Objects.requireNonNull(runnableWithArgs, ERROR_LISTENER_NULL);
        this.eventRouter.addEventListener(string, runnableWithArgs);
    }

    @Override
    public void publishEvent(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        this.eventRouter.publishEvent(string);
    }

    @Override
    public void publishEventOutsideUI(@Nonnull Event event) {
        Objects.requireNonNull(event, ERROR_EVENT_NULL);
        this.eventRouter.publishEventOutsideUI(event);
    }

    @Override
    public void removeEventListener(@Nonnull Map<String, Object> map) {
        Objects.requireNonNull(map, ERROR_LISTENER_NULL);
        this.eventRouter.removeEventListener(map);
    }

    @Override
    public <E extends Event> void addEventListener(@Nonnull Class<E> clazz, @Nonnull CallableWithArgs<?> callableWithArgs) {
        Objects.requireNonNull(clazz, ERROR_EVENT_CLASS_NULL);
        Objects.requireNonNull(callableWithArgs, ERROR_LISTENER_NULL);
        this.eventRouter.addEventListener(clazz, callableWithArgs);
    }

    @Override
    public <E extends Event> void addEventListener(@Nonnull Class<E> clazz, @Nonnull RunnableWithArgs runnableWithArgs) {
        Objects.requireNonNull(clazz, ERROR_EVENT_CLASS_NULL);
        Objects.requireNonNull(runnableWithArgs, ERROR_LISTENER_NULL);
        this.eventRouter.addEventListener(clazz, runnableWithArgs);
    }

    @Override
    public void publishEventOutsideUI(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        this.eventRouter.publishEventOutsideUI(string);
    }

    @Override
    public void publishEventOutsideUI(@Nonnull String string, @Nullable List<?> list) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        this.eventRouter.publishEventOutsideUI(string, list);
    }

    @Override
    public void publishEvent(@Nonnull String string, @Nullable List<?> list) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        this.eventRouter.publishEvent(string, list);
    }

    @Override
    public void publishEventAsync(@Nonnull String string, @Nullable List<?> list) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        this.eventRouter.publishEventAsync(string, list);
    }

    @Override
    public void removeEventListener(@Nonnull String string, @Nonnull CallableWithArgs<?> callableWithArgs) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        Objects.requireNonNull(callableWithArgs, ERROR_LISTENER_NULL);
        this.eventRouter.removeEventListener(string, callableWithArgs);
    }

    @Override
    public void removeEventListener(@Nonnull String string, @Nonnull RunnableWithArgs runnableWithArgs) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        Objects.requireNonNull(runnableWithArgs, ERROR_LISTENER_NULL);
        this.eventRouter.removeEventListener(string, runnableWithArgs);
    }

    @Override
    public void removeEventListener(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_LISTENER_NULL);
        this.eventRouter.removeEventListener(object);
    }

    @Override
    public void addEventListener(@Nonnull Map<String, Object> map) {
        Objects.requireNonNull(map, ERROR_LISTENER_NULL);
        this.eventRouter.addEventListener(map);
    }

    @Override
    public void publishEvent(@Nonnull Event event) {
        Objects.requireNonNull(event, ERROR_EVENT_NULL);
        this.eventRouter.publishEvent(event);
    }

    @Override
    public void publishEventAsync(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        this.eventRouter.publishEventAsync(string);
    }

    @Override
    public void publishEventAsync(@Nonnull Event event) {
        Objects.requireNonNull(event, ERROR_EVENT_NULL);
        this.eventRouter.publishEventAsync(event);
    }

    @Override
    @Nonnull
    public Collection<Object> getEventListeners() {
        return this.eventRouter.getEventListeners();
    }

    @Override
    @Nonnull
    public Collection<Object> getEventListeners(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        return this.eventRouter.getEventListeners(string);
    }
}

