/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.event;

import griffon.core.CallableWithArgs;
import griffon.core.ExceptionHandler;
import griffon.core.ExecutorServiceManager;
import griffon.core.RunnableWithArgs;
import griffon.core.event.Event;
import griffon.core.event.EventRouter;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.MethodDescriptor;
import griffon.util.MethodUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventRouter
implements EventRouter {
    protected static final Object[] LOCK = new Object[0];
    private static final String ERROR_EVENT_NAME_BLANK = "Argument 'eventName' must not be blank";
    private static final String ERROR_EVENT_HANDLER_BLANK = "Argument 'eventHandler' must not be blank";
    private static final String ERROR_MODE_BLANK = "Argument 'mode' must not be blank";
    private static final String ERROR_LISTENER_NULL = "Argument 'listener' must not be null";
    private static final String ERROR_EVENT_CLASS_NULL = "Argument 'eventClass' must not be null";
    private static final String ERROR_EVENT_NULL = "Argument 'event' must not be null";
    private static final String ERROR_CALLABLE_NULL = "Argument 'callable' must not be null";
    private static final String ERROR_RUNNABLE_NULL = "Argument 'runnable' must not be null";
    private static final String ERROR_PARAMS_NULL = "Argument 'params' must not be null";
    private static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    private static final String ERROR_OWNER_NULL = "Argument 'owner' must not be null";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventRouter.class);
    protected final Map<String, List<Object>> instanceListeners = new ConcurrentHashMap<String, List<Object>>();
    protected final Map<String, List<Object>> functionalListeners = new ConcurrentHashMap<String, List<Object>>();
    private final MethodCache methodCache = new MethodCache();
    private boolean enabled = true;
    protected static final AtomicInteger EVENT_ROUTER_ID = new AtomicInteger(1);
    protected ExecutorServiceManager executorServiceManager;
    protected final ExecutorService executorService;
    protected final int eventRouterId = EVENT_ROUTER_ID.getAndIncrement();
    @Inject
    private ExceptionHandler exceptionHandler;

    public AbstractEventRouter() {
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new DefaultThreadFactory(this.eventRouterId));
    }

    @Inject
    public void setExecutorServiceManager(@Nonnull ExecutorServiceManager executorServiceManager) {
        Objects.requireNonNull(executorServiceManager, "Argument 'executorServiceManager' must not be null");
        if (this.executorServiceManager != null) {
            this.executorServiceManager.remove(this.executorService);
        }
        this.executorServiceManager = executorServiceManager;
        this.executorServiceManager.add(this.executorService);
    }

    protected void runInsideExecutorService(final @Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, ERROR_RUNNABLE_NULL);
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    AbstractEventRouter.this.exceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEventPublishingEnabled() {
        Object[] objectArray = LOCK;
        synchronized (LOCK) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventPublishingEnabled(boolean bl) {
        Object[] objectArray = LOCK;
        synchronized (LOCK) {
            this.enabled = bl;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void publishEvent(@Nonnull String string) {
        this.publishEvent(string, Collections.EMPTY_LIST);
    }

    @Override
    public void publishEvent(@Nonnull String string, @Nullable List<?> list) {
        if (!this.isEventPublishingEnabled()) {
            return;
        }
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        this.buildPublisher(string, list, "synchronously").run();
    }

    @Override
    public void publishEventOutsideUI(@Nonnull String string) {
        this.publishEventOutsideUI(string, Collections.EMPTY_LIST);
    }

    @Override
    public void publishEventOutsideUI(@Nonnull String string, @Nullable List<?> list) {
        if (!this.isEventPublishingEnabled()) {
            return;
        }
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        Runnable runnable = this.buildPublisher(string, list, "outside UI");
        this.doPublishOutsideUI(runnable);
    }

    protected abstract void doPublishOutsideUI(@Nonnull Runnable var1);

    @Override
    public void publishEventAsync(@Nonnull String string) {
        this.publishEventAsync(string, Collections.EMPTY_LIST);
    }

    @Override
    public void publishEventAsync(@Nonnull String string, @Nullable List<?> list) {
        if (!this.isEventPublishingEnabled()) {
            return;
        }
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        Runnable runnable = this.buildPublisher(string, list, "asynchronously");
        this.doPublishAsync(runnable);
    }

    protected abstract void doPublishAsync(@Nonnull Runnable var1);

    @Override
    public void publishEvent(@Nonnull Event event) {
        Objects.requireNonNull(event, ERROR_EVENT_NULL);
        this.publishEvent(event.getClass().getSimpleName(), Arrays.asList(event));
    }

    @Override
    public void publishEventOutsideUI(@Nonnull Event event) {
        Objects.requireNonNull(event, ERROR_EVENT_NULL);
        this.publishEventOutsideUI(event.getClass().getSimpleName(), Arrays.asList(event));
    }

    @Override
    public void publishEventAsync(@Nonnull Event event) {
        Objects.requireNonNull(event, ERROR_EVENT_NULL);
        this.publishEventAsync(event.getClass().getSimpleName(), Arrays.asList(event));
    }

    @Override
    public <E extends Event> void removeEventListener(@Nonnull Class<E> clazz, @Nonnull CallableWithArgs<?> callableWithArgs) {
        Objects.requireNonNull(clazz, ERROR_EVENT_CLASS_NULL);
        this.removeEventListener(clazz.getSimpleName(), callableWithArgs);
    }

    @Override
    public <E extends Event> void removeEventListener(@Nonnull Class<E> clazz, @Nonnull RunnableWithArgs runnableWithArgs) {
        Objects.requireNonNull(clazz, ERROR_EVENT_CLASS_NULL);
        this.removeEventListener(clazz.getSimpleName(), runnableWithArgs);
    }

    protected void fireEvent(@Nonnull RunnableWithArgs runnableWithArgs, @Nonnull List<?> list) {
        Objects.requireNonNull(runnableWithArgs, ERROR_RUNNABLE_NULL);
        Objects.requireNonNull(list, ERROR_PARAMS_NULL);
        runnableWithArgs.run(this.asArray(list));
    }

    protected void fireEvent(@Nonnull CallableWithArgs<?> callableWithArgs, @Nonnull List<?> list) {
        Objects.requireNonNull(callableWithArgs, ERROR_CALLABLE_NULL);
        Objects.requireNonNull(list, ERROR_PARAMS_NULL);
        callableWithArgs.call(this.asArray(list));
    }

    protected void fireEvent(@Nonnull Object object, @Nonnull String string, @Nonnull List<?> list) {
        Objects.requireNonNull(object, ERROR_INSTANCE_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_HANDLER_BLANK);
        Objects.requireNonNull(list, ERROR_PARAMS_NULL);
        Class<?>[] classArray = GriffonClassUtils.convertToTypeArray(this.asArray(list));
        MethodDescriptor methodDescriptor = new MethodDescriptor(string, classArray);
        Method method = this.methodCache.findMatchingMethodFor(object.getClass(), methodDescriptor);
        if (method != null) {
            MethodUtils.invokeSafe(method, object, this.asArray(list));
        }
    }

    @Override
    public <E extends Event> void addEventListener(@Nonnull Class<E> clazz, @Nonnull CallableWithArgs<?> callableWithArgs) {
        Objects.requireNonNull(clazz, ERROR_EVENT_CLASS_NULL);
        this.addEventListener(clazz.getSimpleName(), callableWithArgs);
    }

    @Override
    public <E extends Event> void addEventListener(@Nonnull Class<E> clazz, @Nonnull RunnableWithArgs runnableWithArgs) {
        Objects.requireNonNull(clazz, ERROR_EVENT_CLASS_NULL);
        this.addEventListener(clazz.getSimpleName(), runnableWithArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_LISTENER_NULL);
        if (object instanceof RunnableWithArgs) {
            throw new IllegalArgumentException("Cannot add an event listener of type " + RunnableWithArgs.class.getName() + " because the target event name is missing. " + object);
        }
        if (object instanceof CallableWithArgs) {
            throw new IllegalArgumentException("Cannot add an event listener of type " + CallableWithArgs.class.getName() + " because the target event name is missing. " + object);
        }
        if (object instanceof Map) {
            this.addEventListener((Map)object);
            return;
        }
        if (!this.methodCache.isEventListener(object.getClass())) {
            return;
        }
        boolean bl = false;
        for (String string : this.methodCache.fetchMethodMetadata(object.getClass()).keySet()) {
            List<Object> list = this.instanceListeners.get(string = string.substring(2));
            if (list == null) {
                list = new ArrayList<Object>();
                this.instanceListeners.put(string, list);
            }
            List<Object> list2 = list;
            synchronized (list2) {
                if (!list.contains(object)) {
                    bl = true;
                    list.add(object);
                }
            }
        }
        if (bl) {
            try {
                LOG.debug("Adding listener {}", object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOG.debug("Adding listener {}", (Object)object.getClass().getName());
            }
        }
    }

    @Override
    public void addEventListener(@Nonnull Map<String, Object> map) {
        Objects.requireNonNull(map, ERROR_LISTENER_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof RunnableWithArgs) {
                this.addEventListener(entry.getKey(), (RunnableWithArgs)object);
                continue;
            }
            if (object instanceof CallableWithArgs) {
                this.addEventListener(entry.getKey(), (CallableWithArgs)object);
                continue;
            }
            throw new IllegalArgumentException("Unsupported functional event listener " + object);
        }
    }

    @Override
    public void removeEventListener(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_LISTENER_NULL);
        if (object instanceof RunnableWithArgs) {
            throw new IllegalArgumentException("Cannot remove an event listener of type " + RunnableWithArgs.class.getName() + " because the target event name is missing. " + object);
        }
        if (object instanceof CallableWithArgs) {
            throw new IllegalArgumentException("Cannot remove an event listener of type " + CallableWithArgs.class.getName() + " because the target event name is missing. " + object);
        }
        if (object instanceof Map) {
            this.removeEventListener((Map)object);
            return;
        }
        boolean bl = false;
        for (String string : this.methodCache.fetchMethodMetadata(object.getClass()).keySet()) {
            List<Object> list = this.instanceListeners.get(string = string.substring(2));
            if (list == null || !list.contains(object)) continue;
            list.remove(object);
            bl = true;
            if (!list.isEmpty()) continue;
            this.instanceListeners.remove(string);
        }
        boolean bl2 = this.removeNestedListeners(object);
        if (bl || bl2) {
            try {
                LOG.debug("Removing listener {}", object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOG.debug("Removing listener {}", (Object)object.getClass().getName());
            }
        }
    }

    @Override
    public void removeEventListener(@Nonnull Map<String, Object> map) {
        Objects.requireNonNull(map, ERROR_LISTENER_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof RunnableWithArgs) {
                this.removeEventListener(entry.getKey(), (RunnableWithArgs)object);
                continue;
            }
            if (object instanceof CallableWithArgs) {
                this.removeEventListener(entry.getKey(), (CallableWithArgs)object);
                continue;
            }
            throw new IllegalArgumentException("Unsupported functional event listener " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(@Nonnull String string, @Nonnull CallableWithArgs<?> callableWithArgs) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        Objects.requireNonNull(callableWithArgs, ERROR_LISTENER_NULL);
        Map<String, List<Object>> map = this.functionalListeners;
        synchronized (map) {
            List<Object> list = this.functionalListeners.get(GriffonNameUtils.capitalize(string));
            if (list == null) {
                list = new ArrayList<Object>();
                this.functionalListeners.put(GriffonNameUtils.capitalize(string), list);
            }
            if (list.contains(callableWithArgs)) {
                return;
            }
            LOG.debug("Adding listener {} on {}", (Object)callableWithArgs.getClass().getName(), (Object)GriffonNameUtils.capitalize(string));
            list.add(callableWithArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(@Nonnull String string, @Nonnull RunnableWithArgs runnableWithArgs) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        Objects.requireNonNull(runnableWithArgs, ERROR_LISTENER_NULL);
        Map<String, List<Object>> map = this.functionalListeners;
        synchronized (map) {
            List<Object> list = this.functionalListeners.get(GriffonNameUtils.capitalize(string));
            if (list == null) {
                list = new ArrayList<Object>();
                this.functionalListeners.put(GriffonNameUtils.capitalize(string), list);
            }
            if (list.contains(runnableWithArgs)) {
                return;
            }
            LOG.debug("Adding listener {} on {}", (Object)runnableWithArgs.getClass().getName(), (Object)GriffonNameUtils.capitalize(string));
            list.add(runnableWithArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(@Nonnull String string, @Nonnull CallableWithArgs<?> callableWithArgs) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        Objects.requireNonNull(callableWithArgs, ERROR_LISTENER_NULL);
        Map<String, List<Object>> map = this.functionalListeners;
        synchronized (map) {
            List<Object> list = this.functionalListeners.get(GriffonNameUtils.capitalize(string));
            if (list != null) {
                LOG.debug("Removing listener {} on {}", (Object)callableWithArgs.getClass().getName(), (Object)GriffonNameUtils.capitalize(string));
                list.remove(callableWithArgs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(@Nonnull String string, @Nonnull RunnableWithArgs runnableWithArgs) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        Objects.requireNonNull(runnableWithArgs, ERROR_LISTENER_NULL);
        Map<String, List<Object>> map = this.functionalListeners;
        synchronized (map) {
            List<Object> list = this.functionalListeners.get(GriffonNameUtils.capitalize(string));
            if (list != null) {
                LOG.debug("Removing listener {} on {}", (Object)runnableWithArgs.getClass().getName(), (Object)GriffonNameUtils.capitalize(string));
                list.remove(runnableWithArgs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Collection<Object> getEventListeners() {
        ArrayList arrayList = new ArrayList();
        Map<String, List<Object>> map = this.instanceListeners;
        synchronized (map) {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (List<Object> list : this.instanceListeners.values()) {
                hashSet.addAll(list);
            }
            arrayList.addAll(hashSet);
        }
        map = this.functionalListeners;
        synchronized (map) {
            for (List list : this.functionalListeners.values()) {
                arrayList.addAll(list);
            }
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    @Nonnull
    public Collection<Object> getEventListeners(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_EVENT_NAME_BLANK);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Object> list = this.instanceListeners.get(string);
        if (list != null) {
            arrayList.addAll(list);
        }
        if ((list = this.functionalListeners.get(string)) != null) {
            arrayList.addAll(list);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    protected Runnable buildPublisher(final @Nonnull String string, final @Nonnull List<?> list, final @Nonnull String string2) {
        Objects.requireNonNull(string, ERROR_EVENT_NULL);
        Objects.requireNonNull(list, ERROR_PARAMS_NULL);
        GriffonNameUtils.requireNonBlank(string2, ERROR_MODE_BLANK);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String string3 = GriffonNameUtils.capitalize(string);
                LOG.debug("Triggering event '{}' {}", (Object)string3, (Object)string2);
                String string22 = "on" + string3;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                List<Object> list3 = AbstractEventRouter.this.instanceListeners.get(string3);
                if (list3 != null) {
                    arrayList.addAll(list3);
                }
                Map<String, List<Object>> map = AbstractEventRouter.this.functionalListeners;
                synchronized (map) {
                    List<Object> list2 = AbstractEventRouter.this.functionalListeners.get(string3);
                    if (list2 != null) {
                        for (Object object : list2) {
                            arrayList.add(object);
                        }
                    }
                }
                for (Object e : arrayList) {
                    if (e instanceof RunnableWithArgs) {
                        AbstractEventRouter.this.fireEvent((RunnableWithArgs)e, list);
                        continue;
                    }
                    if (e instanceof CallableWithArgs) {
                        AbstractEventRouter.this.fireEvent((CallableWithArgs)e, list);
                        continue;
                    }
                    AbstractEventRouter.this.fireEvent(e, string22, list);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeNestedListeners(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_OWNER_NULL);
        boolean bl = false;
        Map<String, List<Object>> map = this.functionalListeners;
        synchronized (map) {
            for (Map.Entry<String, List<Object>> entry : this.functionalListeners.entrySet()) {
                String string = entry.getKey();
                List<Object> list = entry.getValue();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object object2 : list) {
                    if (!this.isNestedListener(object2, object)) continue;
                    arrayList.add(object2);
                }
                bl = arrayList.size() > 0;
                for (Object object2 : arrayList) {
                    LOG.debug("Removing listener {} on {}", (Object)object2.getClass().getName(), (Object)GriffonNameUtils.capitalize(string));
                    list.remove(object2);
                }
            }
        }
        return bl;
    }

    protected boolean isNestedListener(@Nonnull Object object, @Nonnull Object object2) {
        Objects.requireNonNull(object, ERROR_LISTENER_NULL);
        Objects.requireNonNull(object2, ERROR_OWNER_NULL);
        Class<?> clazz = object.getClass();
        return (clazz.isMemberClass() || clazz.isAnonymousClass() || clazz.isLocalClass()) && object2.getClass().equals(clazz.getEnclosingClass()) && object2.equals(GriffonClassUtils.getFieldValue(object, "this$0"));
    }

    protected Object[] asArray(@Nonnull List<?> list) {
        return list.toArray(new Object[list.size()]);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private DefaultThreadFactory(int n) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "event-router-" + n + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    protected static class MethodInfo {
        private final MethodDescriptor descriptor;
        private final Method method;

        public MethodInfo(MethodDescriptor methodDescriptor, Method method) {
            this.descriptor = methodDescriptor;
            this.method = method;
        }

        public MethodDescriptor getDescriptor() {
            return this.descriptor;
        }

        public Method getMethod() {
            return this.method;
        }
    }

    protected static class MethodCache {
        private final Map<Class<?>, Map<String, List<MethodInfo>>> methodMap = new ConcurrentHashMap();

        protected MethodCache() {
        }

        public boolean isEventListener(@Nonnull Class<?> clazz) {
            Map<String, List<MethodInfo>> map = this.methodMap.get(clazz);
            if (map == null) {
                map = this.fetchMethodMetadata(clazz);
                if (!map.isEmpty()) {
                    this.methodMap.put(clazz, map);
                } else {
                    map = null;
                }
            }
            return map != null;
        }

        @Nullable
        public Method findMatchingMethodFor(@Nonnull Class<?> clazz, @Nonnull MethodDescriptor methodDescriptor) {
            Map<String, List<MethodInfo>> map = this.methodMap.get(clazz);
            List<MethodInfo> list = map.get(methodDescriptor.getName());
            if (list != null) {
                for (MethodInfo methodInfo : list) {
                    if (!methodInfo.descriptor.matches(methodDescriptor)) continue;
                    return methodInfo.method;
                }
            }
            return null;
        }

        private Map<String, List<MethodInfo>> fetchMethodMetadata(Class<?> clazz) {
            LinkedHashMap<String, List<MethodInfo>> linkedHashMap = new LinkedHashMap<String, List<MethodInfo>>();
            for (Method method : clazz.getMethods()) {
                MethodDescriptor methodDescriptor = MethodDescriptor.forMethod(method);
                if (!GriffonClassUtils.isEventHandler(methodDescriptor)) continue;
                String string = method.getName();
                ArrayList<MethodInfo> arrayList = (ArrayList<MethodInfo>)linkedHashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<MethodInfo>();
                    linkedHashMap.put(string, arrayList);
                }
                arrayList.add(new MethodInfo(methodDescriptor, method));
            }
            return linkedHashMap;
        }
    }
}

