/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.event;

import griffon.core.threading.UIThreadManager;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.event.AbstractEventRouter;

public class DefaultEventRouter
extends AbstractEventRouter {
    private final BlockingQueue<Runnable> deferredEvents = new LinkedBlockingQueue<Runnable>();
    private static final String ERROR_PUBLISHER_NULL = "Argument 'publisher' must not be null";
    private UIThreadManager uiThreadManager;

    @Inject
    public void setUIThreadManager(@Nonnull UIThreadManager uIThreadManager) {
        this.uiThreadManager = Objects.requireNonNull(uIThreadManager, "Argument 'uiThreadManager' must not be null");
    }

    @Override
    protected void doPublishOutsideUI(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, ERROR_PUBLISHER_NULL);
        if (!this.uiThreadManager.isUIThread()) {
            runnable.run();
        } else {
            this.runInsideExecutorService(runnable);
        }
    }

    @Override
    protected void doPublishAsync(@Nonnull Runnable runnable) {
        this.executorService.submit(runnable);
    }
}

