/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.i18n;

import griffon.core.CallableWithArgs;
import griffon.core.i18n.MessageSource;
import griffon.core.i18n.NoSuchMessageException;
import griffon.util.GriffonNameUtils;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMessageSource
implements MessageSource {
    protected static final String ERROR_KEY_BLANK = "Argument 'key' must not be blank";
    protected static final String ERROR_LOCALE_NULL = "Argument 'locale' must not be null";
    protected static final String ERROR_ARGS_NULL = "Argument 'args' must not be null";
    protected static final String ERROR_MESSAGE_NULL = "Argument 'message' must not be null";
    protected static final Object[] EMPTY_OBJECT_ARGS = new Object[0];

    @Override
    @Nonnull
    public String getMessage(@Nonnull String string) throws NoSuchMessageException {
        return this.getMessage(string, EMPTY_OBJECT_ARGS, Locale.getDefault());
    }

    @Override
    @Nonnull
    public String getMessage(@Nonnull String string, @Nonnull Locale locale) throws NoSuchMessageException {
        return this.getMessage(string, EMPTY_OBJECT_ARGS, locale);
    }

    @Override
    @Nonnull
    public String getMessage(@Nonnull String string, @Nonnull Object[] objectArray) throws NoSuchMessageException {
        return this.getMessage(string, objectArray, Locale.getDefault());
    }

    @Override
    @Nonnull
    public String getMessage(@Nonnull String string, @Nonnull Object[] objectArray, @Nonnull Locale locale) throws NoSuchMessageException {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        Objects.requireNonNull(objectArray, ERROR_ARGS_NULL);
        Objects.requireNonNull(locale, ERROR_LOCALE_NULL);
        Object object = this.resolveMessageValue(string, locale);
        Object object2 = this.evalMessageWithArguments(object, objectArray);
        if (object2 != null) {
            return object2.toString();
        }
        throw new NoSuchMessageException(string, locale);
    }

    @Override
    @Nonnull
    public String getMessage(@Nonnull String string, @Nonnull List<?> list) throws NoSuchMessageException {
        return this.getMessage(string, this.toObjectArray(list), Locale.getDefault());
    }

    @Override
    @Nonnull
    public String getMessage(@Nonnull String string, @Nonnull List<?> list, @Nonnull Locale locale) throws NoSuchMessageException {
        return this.getMessage(string, this.toObjectArray(list), locale);
    }

    @Override
    @Nullable
    public String getMessage(@Nonnull String string, @Nullable String string2) {
        return this.getMessage(string, EMPTY_OBJECT_ARGS, Locale.getDefault(), string2);
    }

    @Override
    @Nullable
    public String getMessage(@Nonnull String string, @Nonnull Locale locale, @Nullable String string2) {
        return this.getMessage(string, EMPTY_OBJECT_ARGS, locale, string2);
    }

    @Override
    @Nullable
    public String getMessage(@Nonnull String string, @Nonnull Object[] objectArray, @Nullable String string2) {
        return this.getMessage(string, objectArray, Locale.getDefault(), string2);
    }

    @Override
    @Nullable
    public String getMessage(@Nonnull String string, @Nonnull Object[] objectArray, @Nonnull Locale locale, @Nullable String string2) {
        try {
            return this.getMessage(string, objectArray, locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            return null == string2 ? string : string2;
        }
    }

    @Override
    @Nullable
    public String getMessage(@Nonnull String string, @Nonnull List<?> list, @Nullable String string2) {
        return this.getMessage(string, this.toObjectArray(list), Locale.getDefault(), string2);
    }

    @Override
    @Nullable
    public String getMessage(@Nonnull String string, @Nonnull List<?> list, @Nonnull Locale locale, @Nullable String string2) {
        return this.getMessage(string, this.toObjectArray(list), locale, string2);
    }

    @Override
    @Nonnull
    public String getMessage(@Nonnull String string, @Nonnull Map<String, Object> map) throws NoSuchMessageException {
        return this.getMessage(string, map, Locale.getDefault());
    }

    @Override
    @Nonnull
    public String getMessage(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull Locale locale) throws NoSuchMessageException {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        Objects.requireNonNull(map, ERROR_ARGS_NULL);
        Objects.requireNonNull(locale, ERROR_LOCALE_NULL);
        Object object = this.resolveMessageValue(string, locale);
        Object object2 = this.evalMessageWithArguments(object, map);
        if (object2 != null) {
            return object2.toString();
        }
        throw new NoSuchMessageException(string, locale);
    }

    @Override
    @Nullable
    public String getMessage(@Nonnull String string, @Nonnull Map<String, Object> map, @Nullable String string2) {
        return this.getMessage(string, map, Locale.getDefault(), string2);
    }

    @Override
    @Nullable
    public String getMessage(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull Locale locale, @Nullable String string2) {
        try {
            return this.getMessage(string, map, locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            return null == string2 ? string : string2;
        }
    }

    @Override
    @Nonnull
    public Object resolveMessageValue(@Nonnull String string, @Nonnull Locale locale) throws NoSuchMessageException {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        Objects.requireNonNull(locale, ERROR_LOCALE_NULL);
        try {
            String string2;
            Object object = this.doResolveMessageValue(string, locale);
            if (object instanceof CharSequence && (string2 = object.toString()).length() >= 4 && string2.startsWith("@[") && string2.endsWith("]")) {
                String string3 = string2.substring(2, string2.length() - 1);
                object = this.resolveMessageValue(string3, locale);
            }
            return object;
        }
        catch (MissingResourceException missingResourceException) {
            throw new NoSuchMessageException(string, locale);
        }
    }

    @Override
    @Nonnull
    public String formatMessage(@Nonnull String string, @Nonnull List<?> list) {
        Objects.requireNonNull(string, ERROR_MESSAGE_NULL);
        Objects.requireNonNull(list, ERROR_ARGS_NULL);
        return this.formatMessage(string, list.toArray(new Object[list.size()]));
    }

    @Override
    @Nonnull
    public String formatMessage(@Nonnull String string, @Nonnull Object[] objectArray) {
        Objects.requireNonNull(string, ERROR_MESSAGE_NULL);
        Objects.requireNonNull(objectArray, ERROR_ARGS_NULL);
        if (objectArray.length == 0) {
            return string;
        }
        return MessageFormat.format(string, objectArray);
    }

    @Override
    @Nonnull
    public String formatMessage(@Nonnull String string, @Nonnull Map<String, Object> map) {
        Objects.requireNonNull(string, ERROR_MESSAGE_NULL);
        Objects.requireNonNull(map, ERROR_ARGS_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue() != null ? entry.getValue().toString() : null;
            if (string3 == null) continue;
            string = string.replace("{:" + string2 + "}", string3);
        }
        return string;
    }

    @Nonnull
    protected abstract Object doResolveMessageValue(@Nonnull String var1, @Nonnull Locale var2) throws NoSuchMessageException;

    @Nullable
    protected Object evalMessageWithArguments(@Nonnull Object object, @Nonnull Object[] objectArray) {
        if (object instanceof CallableWithArgs) {
            CallableWithArgs callableWithArgs = (CallableWithArgs)object;
            return callableWithArgs.call(objectArray);
        }
        if (object instanceof CharSequence) {
            return this.formatMessage(String.valueOf(object), objectArray);
        }
        return null;
    }

    @Nullable
    protected Object evalMessageWithArguments(@Nonnull Object object, @Nonnull Map<String, Object> map) {
        if (object instanceof CallableWithArgs) {
            CallableWithArgs callableWithArgs = (CallableWithArgs)object;
            return callableWithArgs.call(map);
        }
        if (object instanceof CharSequence) {
            return this.formatMessage(String.valueOf(object), map);
        }
        return null;
    }

    @Nonnull
    protected Object[] toObjectArray(@Nonnull List<?> list) {
        if (list.isEmpty()) {
            return EMPTY_OBJECT_ARGS;
        }
        return list.toArray(new Object[list.size()]);
    }
}

