/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.i18n;

import griffon.core.i18n.MessageSource;
import griffon.core.i18n.NoSuchMessageException;
import griffon.util.CompositeResourceBundle;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import org.codehaus.griffon.runtime.core.i18n.AbstractMessageSource;

public class CompositeMessageSource
extends AbstractMessageSource {
    private final MessageSource[] messageSources;

    public CompositeMessageSource(@Nonnull Collection<MessageSource> collection) {
        this(CompositeMessageSource.toMessageSourceArray(collection));
    }

    public CompositeMessageSource(@Nonnull MessageSource[] messageSourceArray) {
        this.messageSources = Objects.requireNonNull(messageSourceArray, "Argument 'messageSources' must not be null");
    }

    private static MessageSource[] toMessageSourceArray(@Nonnull Collection<MessageSource> collection) {
        Objects.requireNonNull(collection, "Argument 'messageSources' must not be null");
        GriffonClassUtils.requireNonEmpty(collection, "Argument 'messageSources' must not be empty");
        return collection.toArray(new MessageSource[collection.size()]);
    }

    @Override
    @Nonnull
    protected Object doResolveMessageValue(@Nonnull String string, @Nonnull Locale locale) throws NoSuchMessageException {
        GriffonNameUtils.requireNonBlank(string, "Argument 'key' must not be blank");
        Objects.requireNonNull(locale, "Argument 'locale' must not be null");
        for (MessageSource messageSource : this.messageSources) {
            try {
                return messageSource.getMessage(string, locale);
            }
            catch (NoSuchMessageException noSuchMessageException) {
            }
        }
        throw new NoSuchMessageException(string, locale);
    }

    @Override
    @Nonnull
    public ResourceBundle asResourceBundle() {
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        for (MessageSource messageSource : this.messageSources) {
            arrayList.add(messageSource.asResourceBundle());
        }
        return new CompositeResourceBundle(arrayList);
    }
}

