/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.injection;

import griffon.core.injection.Binding;
import griffon.core.injection.Module;
import griffon.util.GriffonClassUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.griffon.runtime.core.injection.AnnotatedBindingBuilder;
import org.codehaus.griffon.runtime.core.injection.BindingBuilder;
import org.codehaus.griffon.runtime.core.injection.Bindings;

public abstract class AbstractModule
implements Module {
    protected final List<Binding<?>> bindings = new ArrayList();
    protected BindingBuilder<?> currentBinding;
    protected boolean configured;

    @Override
    public final void configure() {
        GriffonClassUtils.requireState(!this.configured, "Module " + this + " has already been configured");
        this.doConfigure();
        this.configured = true;
    }

    protected abstract void doConfigure();

    @Override
    @Nonnull
    public final List<Binding<?>> getBindings() {
        if (!this.configured) {
            this.configure();
        }
        if (this.currentBinding != null) {
            this.bindings.add(this.currentBinding.getBinding());
            this.currentBinding = null;
        }
        return this.bindings;
    }

    protected <T> AnnotatedBindingBuilder<T> bind(@Nonnull Class<T> clazz) {
        Objects.requireNonNull(clazz, "Argument 'class' must not be null");
        if (this.currentBinding != null) {
            this.bindings.add(this.currentBinding.getBinding());
        }
        AnnotatedBindingBuilder<?> annotatedBindingBuilder = Bindings.bind(clazz);
        this.currentBinding = annotatedBindingBuilder;
        return annotatedBindingBuilder;
    }
}

