/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.injection;

import griffon.core.injection.Binding;
import griffon.core.injection.InstanceBinding;
import griffon.core.injection.ProviderBinding;
import griffon.core.injection.ProviderTypeBinding;
import griffon.core.injection.TargetBinding;
import griffon.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.inject.Qualifier;
import org.codehaus.griffon.runtime.core.injection.AnnotatedBindingBuilder;
import org.codehaus.griffon.runtime.core.injection.LinkedBindingBuilder;
import org.codehaus.griffon.runtime.core.injection.SingletonBindingBuilder;

public class Bindings {
    public static <T> AnnotatedBindingBuilder<T> bind(@Nonnull Class<T> clazz) {
        Objects.requireNonNull(clazz, "Argument 'class' must not be null");
        return new AnnotatedBindingBuilderImpl(clazz);
    }

    private static class ProviderTypeBindingImpl<T>
    extends AbstractBindingImpl<T>
    implements ProviderTypeBinding<T> {
        private final Class<? extends Provider<T>> providerType;

        private ProviderTypeBindingImpl(@Nonnull Class<T> clazz, @Nonnull Class<? extends Provider<T>> clazz2, @Nonnull Annotation annotation, boolean bl) {
            super(clazz, annotation, bl);
            this.providerType = clazz2;
            this.updateClassifier(clazz2);
        }

        private ProviderTypeBindingImpl(@Nonnull Class<T> clazz, @Nonnull Class<? extends Provider<T>> clazz2, @Nonnull Class<? extends Annotation> clazz3, boolean bl) {
            super(clazz, clazz3, bl);
            this.providerType = clazz2;
            this.updateClassifierType(clazz2);
        }

        @Override
        @Nonnull
        public Class<? extends Provider<T>> getProviderType() {
            return this.providerType;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ProviderTypeBinding[");
            stringBuilder.append("source=").append(this.source.getName());
            if (this.classifier != null) {
                stringBuilder.append(", classifier=").append(this.classifier);
            } else if (this.classifierType != null) {
                stringBuilder.append(", classifierType=").append(this.classifierType.getName());
            }
            stringBuilder.append(", providerType=").append(this.providerType.getName());
            stringBuilder.append(", singleton=").append(this.singleton);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static class ProviderBindingImpl<T>
    extends AbstractBindingImpl<T>
    implements ProviderBinding<T> {
        private final Provider<T> provider;

        private ProviderBindingImpl(@Nonnull Class<T> clazz, @Nonnull Provider<T> provider, @Nonnull Annotation annotation, boolean bl) {
            super(clazz, annotation, bl);
            this.provider = provider;
            this.updateClassifier(provider.getClass());
        }

        private ProviderBindingImpl(@Nonnull Class<T> clazz, @Nonnull Provider<T> provider, @Nonnull Class<? extends Annotation> clazz2, boolean bl) {
            super(clazz, clazz2, bl);
            this.provider = provider;
            this.updateClassifierType(provider.getClass());
        }

        @Override
        @Nonnull
        public Provider<T> getProvider() {
            return this.provider;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ProviderBinding[");
            stringBuilder.append("source=").append(this.source.getName());
            if (this.classifier != null) {
                stringBuilder.append(", classifier=").append(this.classifier);
            } else if (this.classifierType != null) {
                stringBuilder.append(", classifierType=").append(this.classifierType.getName());
            }
            stringBuilder.append(", provider=").append(this.provider);
            stringBuilder.append(", singleton=").append(this.singleton);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static class InstanceBindingImpl<T>
    extends AbstractBindingImpl<T>
    implements InstanceBinding<T> {
        private final T instance;

        protected InstanceBindingImpl(@Nonnull Class<T> clazz, @Nonnull Annotation annotation, @Nonnull T t) {
            super(clazz, annotation, true);
            this.instance = t;
            this.updateClassifier(t.getClass());
        }

        protected InstanceBindingImpl(@Nonnull Class<T> clazz, @Nonnull Class<? extends Annotation> clazz2, @Nonnull T t) {
            super(clazz, clazz2, true);
            this.instance = t;
            this.updateClassifierType(t.getClass());
        }

        @Override
        @Nonnull
        public T getInstance() {
            return this.instance;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("InstanceBinding[");
            stringBuilder.append("source=").append(this.source.getName());
            if (this.classifier != null) {
                stringBuilder.append(", classifier=").append(this.classifier);
            } else if (this.classifierType != null) {
                stringBuilder.append(", classifierType=").append(this.classifierType.getName());
            }
            stringBuilder.append(", instance=").append(this.instance);
            stringBuilder.append(", singleton=").append(this.singleton);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static class TargetBindingImpl<T>
    extends AbstractBindingImpl<T>
    implements TargetBinding<T> {
        private final Class<? extends T> target;

        private TargetBindingImpl(@Nonnull Class<T> clazz, @Nonnull Class<? extends T> clazz2, @Nonnull Annotation annotation, boolean bl) {
            super(clazz, annotation, bl);
            this.target = clazz2;
            this.updateClassifier(clazz2);
        }

        private TargetBindingImpl(@Nonnull Class<T> clazz, @Nonnull Class<? extends T> clazz2, @Nonnull Class<? extends Annotation> clazz3, boolean bl) {
            super(clazz, clazz3, bl);
            this.target = clazz2;
            this.updateClassifierType(clazz2);
        }

        @Override
        @Nonnull
        public Class<? extends T> getTarget() {
            return this.target;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("TargetBinding[");
            stringBuilder.append("source=").append(this.source.getName());
            if (this.classifier != null) {
                stringBuilder.append(", classifier=").append(this.classifier);
            } else if (this.classifierType != null) {
                stringBuilder.append(", classifierType=").append(this.classifierType.getName());
            }
            stringBuilder.append(", target=").append(this.target.getName());
            stringBuilder.append(", singleton=").append(this.singleton);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static abstract class AbstractBindingImpl<T>
    implements Binding<T> {
        protected final Class<T> source;
        protected final boolean singleton;
        protected Annotation classifier;
        protected Class<? extends Annotation> classifierType;

        protected AbstractBindingImpl(@Nonnull Class<T> clazz, @Nonnull Annotation annotation, boolean bl) {
            this.source = clazz;
            this.singleton = bl;
            this.classifier = annotation;
            this.classifierType = annotation.getClass();
        }

        protected AbstractBindingImpl(@Nonnull Class<T> clazz, @Nonnull Class<? extends Annotation> clazz2, boolean bl) {
            this.source = clazz;
            this.singleton = bl;
            this.classifierType = clazz2;
        }

        @Override
        @Nonnull
        public Class<T> getSource() {
            return this.source;
        }

        @Override
        @Nullable
        public Class<? extends Annotation> getClassifierType() {
            return this.classifierType;
        }

        @Override
        @Nullable
        public Annotation getClassifier() {
            return this.classifier;
        }

        @Override
        public boolean isSingleton() {
            return this.singleton;
        }

        protected void updateClassifier(Class<?> clazz) {
            List<Annotation> list;
            if (this.classifier == null && !(list = AnnotationUtils.harvestQualifiers(clazz)).isEmpty()) {
                this.classifier = list.get(0);
            }
        }

        protected void updateClassifierType(Class<?> clazz) {
            List<Annotation> list;
            if (this.classifierType == null && !(list = AnnotationUtils.harvestQualifiers(clazz)).isEmpty()) {
                this.classifier = list.get(0);
            }
        }
    }

    private static class AnnotatedBindingBuilderImpl<T>
    extends LinkedBindingBuilderImpl<T>
    implements AnnotatedBindingBuilder<T> {
        private final Class<T> source;
        private Annotation classifier;
        private Class<? extends Annotation> classifierType;

        private AnnotatedBindingBuilderImpl(@Nonnull Class<T> clazz) {
            this.source = Objects.requireNonNull(clazz, "Argument 'source' must not be null");
        }

        @Override
        @Nonnull
        public Binding<T> getBinding() {
            if (this.instance != null) {
                return this.classifier != null ? new InstanceBindingImpl<Object>(this.source, this.classifier, this.instance) : new InstanceBindingImpl<Object>(this.source, this.classifierType, this.instance);
            }
            if (this.providerType != null) {
                return this.classifier != null ? new ProviderTypeBindingImpl(this.source, this.providerType, this.classifier, this.singleton) : new ProviderTypeBindingImpl(this.source, this.providerType, this.classifierType, this.singleton);
            }
            if (this.provider != null) {
                return this.classifier != null ? new ProviderBindingImpl(this.source, this.provider, this.classifier, this.singleton) : new ProviderBindingImpl(this.source, this.provider, this.classifierType, this.singleton);
            }
            if (this.target != null) {
                return this.classifier != null ? new TargetBindingImpl(this.source, this.target, this.classifier, this.singleton) : new TargetBindingImpl(this.source, this.target, this.classifierType, this.singleton);
            }
            return this.classifier != null ? new TargetBindingImpl(this.source, this.source, this.classifier, this.singleton) : new TargetBindingImpl(this.source, this.source, this.classifierType, this.singleton);
        }

        @Override
        @Nonnull
        public LinkedBindingBuilder<T> withClassifier(@Nonnull Class<? extends Annotation> clazz) {
            Objects.requireNonNull(clazz, "Argument 'annotationType' must not be null");
            AnnotationUtils.requireAnnotation(clazz, Qualifier.class);
            this.classifierType = clazz;
            return this;
        }

        @Override
        @Nonnull
        public LinkedBindingBuilder<T> withClassifier(@Nonnull Annotation annotation) {
            Objects.requireNonNull(annotation, "Argument 'annotation' must not be null");
            this.classifier = annotation;
            this.withClassifier(annotation.getClass());
            return this;
        }
    }

    private static abstract class LinkedBindingBuilderImpl<T>
    extends SingletonBindingBuilderImpl<T>
    implements LinkedBindingBuilder<T> {
        protected Class<? extends T> target;
        protected T instance;
        protected Provider<T> provider;
        protected Class<? extends Provider<T>> providerType;

        private LinkedBindingBuilderImpl() {
        }

        @Override
        @Nonnull
        public SingletonBindingBuilder<T> to(@Nonnull Class<? extends T> clazz) {
            this.target = Objects.requireNonNull(clazz, "Argument 'target' must not be null");
            return this;
        }

        @Override
        public void toInstance(@Nonnull T t) {
            this.instance = Objects.requireNonNull(t, "Argument 'instance' must not be null");
        }

        @Override
        @Nonnull
        public SingletonBindingBuilder<T> toProvider(@Nonnull Provider<T> provider) {
            this.provider = Objects.requireNonNull(provider, "Argument 'provider' must not be null");
            return this;
        }

        @Override
        @Nonnull
        public SingletonBindingBuilder<T> toProvider(@Nonnull Class<? extends Provider<T>> clazz) {
            this.providerType = Objects.requireNonNull(clazz, "Argument 'providerType' must not be null");
            return this;
        }
    }

    private static abstract class SingletonBindingBuilderImpl<T>
    implements SingletonBindingBuilder<T> {
        protected boolean singleton;

        private SingletonBindingBuilderImpl() {
        }

        @Override
        public void asSingleton() {
            this.singleton = true;
        }
    }
}

