/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.injection;

import griffon.util.GriffonClassUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class InjectionUnitOfWork {
    private static final ThreadLocal<List<Object>> CONTEXT = new ThreadLocal();
    private static final String ERROR_NO_UNITOFWORK_IN_PROCESS = "There is no InjectionUnitOfWork in process!";

    public static void start() {
        GriffonClassUtils.requireState(CONTEXT.get() == null, "There is already an existing InjectionUnitOfWork in process!");
        CONTEXT.set(new ArrayList());
    }

    @Nonnull
    public static List<Object> finish() {
        List<Object> list = CONTEXT.get();
        GriffonClassUtils.requireState(list != null, ERROR_NO_UNITOFWORK_IN_PROCESS);
        CONTEXT.set(null);
        return list;
    }

    public static void track(@Nonnull Object object) {
        Objects.requireNonNull(object, "Argument 'instance' must not be null");
        List<Object> list = CONTEXT.get();
        GriffonClassUtils.requireState(list != null, ERROR_NO_UNITOFWORK_IN_PROCESS);
        list.add(object);
    }
}

