/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.mvc;

import griffon.core.Context;
import griffon.core.artifact.GriffonController;
import griffon.core.artifact.GriffonModel;
import griffon.core.artifact.GriffonMvcArtifact;
import griffon.core.artifact.GriffonView;
import griffon.core.mvc.MVCFunction;
import griffon.core.mvc.MVCGroup;
import griffon.core.mvc.MVCGroupConfiguration;
import griffon.core.mvc.MVCGroupFunction;
import griffon.core.mvc.MVCGroupManager;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.griffon.runtime.core.mvc.AbstractMVCHandler;

public abstract class AbstractMVCGroup
extends AbstractMVCHandler
implements MVCGroup {
    protected final MVCGroupConfiguration configuration;
    protected final String mvcId;
    protected final Context context;
    protected final Map<String, Object> members = new LinkedHashMap<String, Object>();
    protected final Map<String, MVCGroup> children = new LinkedHashMap<String, MVCGroup>();
    private final Object[] lock = new Object[0];
    protected MVCGroup parentGroup;
    private boolean alive;
    private final List<Object> injectedInstances = new ArrayList<Object>();

    public AbstractMVCGroup(@Nonnull MVCGroupManager mVCGroupManager, @Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nullable String string, @Nonnull Map<String, Object> map, @Nullable MVCGroup mVCGroup) {
        super(mVCGroupManager);
        this.configuration = Objects.requireNonNull(mVCGroupConfiguration, "Argument 'configuration' must not be null");
        this.mvcId = GriffonNameUtils.isBlank(string) ? mVCGroupConfiguration.getMvcType() + "-" + UUID.randomUUID().toString() : string;
        this.members.putAll(Objects.requireNonNull(map, "Argument 'members' must not be null"));
        this.alive = true;
        this.parentGroup = mVCGroup;
        this.context = mVCGroupManager.newContext(mVCGroup);
        for (Object object : this.members.values()) {
            if (!(object instanceof GriffonMvcArtifact)) continue;
            GriffonClassUtils.setPropertyOrFieldValue(object, "mvcGroup", this);
        }
    }

    @Nonnull
    public List<Object> getInjectedInstances() {
        return this.injectedInstances;
    }

    @Override
    @Nonnull
    public Context getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public MVCGroup getParentGroup() {
        return this.parentGroup;
    }

    @Override
    @Nonnull
    public MVCGroupConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nonnull
    public String getMvcType() {
        return this.configuration.getMvcType();
    }

    @Override
    @Nonnull
    public String getMvcId() {
        return this.mvcId;
    }

    @Override
    @Nullable
    public GriffonModel getModel() {
        return (GriffonModel)this.getMember("model");
    }

    @Override
    @Nullable
    public GriffonView getView() {
        return (GriffonView)this.getMember("view");
    }

    @Override
    @Nullable
    public GriffonController getController() {
        return (GriffonController)this.getMember("controller");
    }

    @Override
    @Nullable
    public Object getMember(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'name' must not be blank");
        this.checkIfAlive();
        return this.members.get(string);
    }

    @Override
    @Nonnull
    public Map<String, Object> getMembers() {
        this.checkIfAlive();
        return Collections.unmodifiableMap(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroy() {
        if (!this.isAlive()) return;
        ArrayList<String> arrayList = new ArrayList<String>(this.children.keySet());
        Collections.reverse(arrayList);
        for (String string : arrayList) {
            this.getMvcGroupManager().destroyMVCGroup(string);
        }
        this.getMvcGroupManager().destroyMVCGroup(this.mvcId);
        this.members.clear();
        this.children.clear();
        if (this.parentGroup != null) {
            this.parentGroup.notifyMVCGroupDestroyed(this.mvcId);
        }
        this.parentGroup = null;
        this.context.destroy();
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.alive = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void notifyMVCGroupDestroyed(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'mvcId' must not be blank");
        this.children.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlive() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.alive;
        }
    }

    protected void checkIfAlive() {
        GriffonClassUtils.requireState(this.isAlive(), "Group " + this.getMvcType() + ":" + this.mvcId + " has been destroyed already.");
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return this.manageChildGroup(super.createMVCGroup(this.injectParentGroup(map), string));
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2) {
        return this.manageChildGroup(super.createMVCGroup(this.injectParentGroup(map), string, string2));
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull Map<String, Object> map) {
        return this.manageChildGroup(super.createMVCGroup(string, this.injectParentGroup(map)));
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map) {
        return this.manageChildGroup(super.createMVCGroup(string, string2, this.injectParentGroup(map)));
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return this.manageChildGroup(super.createMVC(this.injectParentGroup(map), string));
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2) {
        return this.manageChildGroup(super.createMVC(this.injectParentGroup(map), string, string2));
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull Map<String, Object> map) {
        return this.manageChildGroup(super.createMVC(string, this.injectParentGroup(map)));
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map) {
        return this.manageChildGroup(super.createMVC(string, string2, this.injectParentGroup(map)));
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        super.withMVC(this.injectParentGroup(map), string, new MVCFunctionDecorator(mVCFunction));
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        super.withMVC(this.injectParentGroup(map), string, string2, new MVCFunctionDecorator(mVCFunction));
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        super.withMVC(string, this.injectParentGroup(map), new MVCFunctionDecorator(mVCFunction));
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        super.withMVC(string, string2, this.injectParentGroup(map), new MVCFunctionDecorator(mVCFunction));
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        super.withMVC(string, this.injectParentGroup(), new MVCFunctionDecorator(mVCFunction));
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull String string2, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        super.withMVC(string, string2, this.injectParentGroup(), new MVCFunctionDecorator(mVCFunction));
    }

    @Override
    public void withMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull MVCGroupFunction mVCGroupFunction) {
        super.withMVCGroup(this.injectParentGroup(map), string, (MVCGroupFunction)new MVCGroupFunctionDecorator(mVCGroupFunction));
    }

    @Override
    public void withMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2, @Nonnull MVCGroupFunction mVCGroupFunction) {
        super.withMVCGroup(this.injectParentGroup(map), string, string2, (MVCGroupFunction)new MVCGroupFunctionDecorator(mVCGroupFunction));
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull MVCGroupFunction mVCGroupFunction) {
        super.withMVCGroup(string, this.injectParentGroup(map), (MVCGroupFunction)new MVCGroupFunctionDecorator(mVCGroupFunction));
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map, @Nonnull MVCGroupFunction mVCGroupFunction) {
        super.withMVCGroup(string, string2, this.injectParentGroup(map), (MVCGroupFunction)new MVCGroupFunctionDecorator(mVCGroupFunction));
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull MVCGroupFunction mVCGroupFunction) {
        super.withMVCGroup(string, this.injectParentGroup(), (MVCGroupFunction)new MVCGroupFunctionDecorator(mVCGroupFunction));
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull MVCGroupFunction mVCGroupFunction) {
        super.withMVCGroup(string, string2, this.injectParentGroup(), (MVCGroupFunction)new MVCGroupFunctionDecorator(mVCGroupFunction));
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull String string2) {
        return this.manageChildGroup(super.createMVC(string, string2, this.injectParentGroup()));
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string) {
        return this.manageChildGroup(super.createMVC(string, this.injectParentGroup()));
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull String string2) {
        return this.manageChildGroup(super.createMVCGroup(string, string2, this.injectParentGroup()));
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string) {
        return this.manageChildGroup(super.createMVCGroup(string, this.injectParentGroup()));
    }

    @Nonnull
    private MVCGroup manageChildGroup(@Nonnull MVCGroup mVCGroup) {
        this.children.put(mVCGroup.getMvcId(), mVCGroup);
        return mVCGroup;
    }

    @Nonnull
    private List<? extends GriffonMvcArtifact> manageChildGroup(@Nonnull List<? extends GriffonMvcArtifact> list) {
        MVCGroup mVCGroup = null;
        for (GriffonMvcArtifact griffonMvcArtifact : list) {
            if (griffonMvcArtifact == null) continue;
            mVCGroup = griffonMvcArtifact.getMvcGroup();
            break;
        }
        if (mVCGroup != null) {
            this.children.put(mVCGroup.getMvcId(), mVCGroup);
        }
        return list;
    }

    @Override
    @Nonnull
    public Map<String, MVCGroup> getChildrenGroups() {
        return Collections.unmodifiableMap(this.children);
    }

    @Nonnull
    private Map<String, Object> injectParentGroup() {
        return this.injectParentGroup(new LinkedHashMap<String, Object>());
    }

    @Nonnull
    private Map<String, Object> injectParentGroup(@Nonnull Map<String, Object> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("parentGroup", this);
        linkedHashMap.putAll(map);
        return linkedHashMap;
    }

    private final class MVCGroupFunctionDecorator
    implements MVCGroupFunction {
        private final MVCGroupFunction delegate;

        private MVCGroupFunctionDecorator(MVCGroupFunction mVCGroupFunction) {
            this.delegate = mVCGroupFunction;
        }

        @Override
        public void apply(@Nullable MVCGroup mVCGroup) {
            AbstractMVCGroup.this.children.put(mVCGroup.getMvcId(), mVCGroup);
            this.delegate.apply(mVCGroup);
            AbstractMVCGroup.this.children.remove(mVCGroup.getMvcId());
        }
    }

    private final class MVCFunctionDecorator<M extends GriffonModel, V extends GriffonView, C extends GriffonController>
    implements MVCFunction<M, V, C> {
        private final MVCFunction<M, V, C> delegate;

        private MVCFunctionDecorator(MVCFunction<M, V, C> mVCFunction) {
            this.delegate = mVCFunction;
        }

        @Override
        public void apply(@Nullable M m, @Nullable V v, @Nullable C c) {
            MVCGroup mVCGroup = null;
            if (m != null) {
                mVCGroup = m.getMvcGroup();
            }
            if (v != null) {
                mVCGroup = v.getMvcGroup();
            }
            if (c != null) {
                mVCGroup = c.getMvcGroup();
            }
            if (mVCGroup != null) {
                AbstractMVCGroup.this.children.put(mVCGroup.getMvcId(), mVCGroup);
            }
            this.delegate.apply(m, v, c);
            if (mVCGroup != null) {
                AbstractMVCGroup.this.children.remove(mVCGroup.getMvcId());
            }
        }
    }
}

