/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.mvc;

import griffon.core.mvc.MVCGroup;
import griffon.core.mvc.MVCGroupConfiguration;
import griffon.util.GriffonNameUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMVCGroupConfiguration
implements MVCGroupConfiguration {
    private static final String ERROR_MEMBERS_NULL = "Argument 'members' must not be null";
    private static final String ERROR_ARGS_NULL = "Argument 'args' must not be null";
    protected final Map<String, String> members = new LinkedHashMap<String, String>();
    protected final Map<String, Object> config = new LinkedHashMap<String, Object>();
    protected final String mvcType;

    public AbstractMVCGroupConfiguration(@Nonnull String string, @Nonnull Map<String, String> map, @Nonnull Map<String, Object> map2) {
        this.mvcType = GriffonNameUtils.requireNonBlank(string, "Argument 'mvcType' must not be blank");
        this.members.putAll(Objects.requireNonNull(map, ERROR_MEMBERS_NULL));
        this.config.putAll(Objects.requireNonNull(map2, "Argument 'config' must not be null"));
    }

    public String toString() {
        return "MVCGroupConfiguration{mvcType='" + this.mvcType + '\'' + ", members=" + this.members + ", config=" + this.config + '}';
    }

    @Override
    @Nonnull
    public String getMvcType() {
        return this.mvcType;
    }

    @Override
    @Nonnull
    public Map<String, String> getMembers() {
        return Collections.unmodifiableMap(this.members);
    }

    @Override
    @Nonnull
    public Map<String, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    @Override
    @Nonnull
    public MVCGroup create() {
        return this.create(null, Collections.emptyMap());
    }

    @Override
    @Nonnull
    public MVCGroup create(@Nullable String string) {
        return this.create(string, Collections.emptyMap());
    }

    @Override
    @Nonnull
    public MVCGroup create(@Nonnull Map<String, Object> map) {
        return this.create(null, map);
    }

    @Override
    @Nonnull
    public MVCGroup create(@Nullable String string, @Nonnull Map<String, Object> map) {
        Objects.requireNonNull(map, ERROR_ARGS_NULL);
        return this.instantiateMVCGroup(string, map);
    }

    @Nonnull
    protected abstract MVCGroup instantiateMVCGroup(@Nullable String var1, @Nonnull Map<String, Object> var2);
}

