/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.mvc;

import griffon.core.Context;
import griffon.core.ContextFactory;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.core.artifact.GriffonController;
import griffon.core.artifact.GriffonModel;
import griffon.core.artifact.GriffonMvcArtifact;
import griffon.core.artifact.GriffonView;
import griffon.core.mvc.MVCFunction;
import griffon.core.mvc.MVCGroup;
import griffon.core.mvc.MVCGroupConfiguration;
import griffon.core.mvc.MVCGroupConfigurationFactory;
import griffon.core.mvc.MVCGroupFactory;
import griffon.core.mvc.MVCGroupFunction;
import griffon.core.mvc.MVCGroupManager;
import griffon.exceptions.ArtifactNotFoundException;
import griffon.exceptions.MVCGroupConfigurationException;
import griffon.util.GriffonNameUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMVCGroupManager
implements MVCGroupManager {
    protected static final String ERROR_MVCTYPE_BLANK = "Argument 'mvcType' must not be blank";
    protected static final String ERROR_MVCID_BLANK = "Argument 'mvcId' must not be blank";
    protected static final String ERROR_CONFIGURATION_NULL = "Argument 'configuration' must not be null";
    protected static final String ERROR_GROUP_NULL = "Argument 'group' must not be null";
    protected static final String ERROR_CONFIG_NULL = "Argument 'config' must not be null";
    protected static final String ERROR_ARGS_NULL = "Argument 'args' must not be null";
    protected static final String ERROR_NAME_BLANK = "Argument 'name' cannot be blank";
    protected static final String ERROR_TYPE_NULL = "Argument 'type' cannot be null";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMVCGroupManager.class);
    private final GriffonApplication application;
    private final Map<String, MVCGroupConfiguration> configurations = new LinkedHashMap<String, MVCGroupConfiguration>();
    private final Map<String, MVCGroup> groups = new LinkedHashMap<String, MVCGroup>();
    private final Object lock = new Object[0];
    private boolean initialized;
    @Inject
    private MVCGroupConfigurationFactory mvcGroupConfigurationFactory;
    @Inject
    private MVCGroupFactory mvcGroupFactory;
    @Inject
    private ContextFactory contextFactory;

    @Inject
    public AbstractMVCGroupManager(@Nonnull GriffonApplication griffonApplication) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
    }

    @Override
    public GriffonApplication getApplication() {
        return this.application;
    }

    @Override
    @Nonnull
    public MVCGroupConfiguration newMVCGroupConfiguration(@Nonnull String string, @Nonnull Map<String, String> map, @Nonnull Map<String, Object> map2) {
        return this.mvcGroupConfigurationFactory.create(string, map, map2);
    }

    @Override
    @Nonnull
    public MVCGroup newMVCGroup(@Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nullable String string, @Nonnull Map<String, Object> map, @Nullable MVCGroup mVCGroup) {
        return this.mvcGroupFactory.create(mVCGroupConfiguration, string, map, mVCGroup);
    }

    @Override
    @Nonnull
    public Context newContext(@Nullable MVCGroup mVCGroup) {
        Context context = mVCGroup != null ? mVCGroup.getContext() : this.getApplication().getContext();
        return this.contextFactory.create(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<String, MVCGroupConfiguration> getConfigurations() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.configurations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<String, MVCGroup> getGroups() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public MVCGroupConfiguration findConfiguration(@Nonnull String string) {
        MVCGroupConfiguration mVCGroupConfiguration;
        GriffonNameUtils.requireNonBlank(string, ERROR_MVCTYPE_BLANK);
        Object object = this.lock;
        synchronized (object) {
            mVCGroupConfiguration = this.configurations.get(string);
        }
        if (mVCGroupConfiguration == null) {
            throw new MVCGroupConfigurationException("Unknown MVC type '" + string + "'. Known types are " + this.configurations.keySet(), string);
        }
        return mVCGroupConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MVCGroup findGroup(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_MVCID_BLANK);
        Object object = this.lock;
        synchronized (object) {
            LOG.debug("Searching group {}", (Object)string);
            return this.groups.get(string);
        }
    }

    @Override
    @Nullable
    public MVCGroup getAt(@Nonnull String string) {
        return this.findGroup(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initialize(@Nonnull Map<String, MVCGroupConfiguration> map) {
        Objects.requireNonNull(map, "Argument 'configurations' must not be null");
        if (map.isEmpty()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                this.doInitialize(map);
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfiguration(@Nonnull MVCGroupConfiguration mVCGroupConfiguration) {
        Objects.requireNonNull(mVCGroupConfiguration, ERROR_CONFIGURATION_NULL);
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized && this.configurations.get(mVCGroupConfiguration.getMvcType()) != null) {
                return;
            }
            this.configurations.put(mVCGroupConfiguration.getMvcType(), mVCGroupConfiguration);
        }
    }

    @Override
    public void removeConfiguration(@Nonnull MVCGroupConfiguration mVCGroupConfiguration) {
        Objects.requireNonNull(mVCGroupConfiguration, ERROR_CONFIGURATION_NULL);
        this.removeConfiguration(mVCGroupConfiguration.getMvcType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfiguration(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'name' must not be blank");
        if (!GriffonNameUtils.isBlank(string)) {
            Object object = this.lock;
            synchronized (object) {
                this.configurations.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addGroup(@Nonnull MVCGroup mVCGroup) {
        Objects.requireNonNull(mVCGroup, ERROR_GROUP_NULL);
        Object object = this.lock;
        synchronized (object) {
            LOG.debug("Adding group {}:{}", (Object)mVCGroup.getMvcId(), (Object)mVCGroup);
            this.groups.put(mVCGroup.getMvcId(), mVCGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeGroup(@Nonnull MVCGroup mVCGroup) {
        Objects.requireNonNull(mVCGroup, ERROR_GROUP_NULL);
        Object object = this.lock;
        synchronized (object) {
            LOG.debug("Removing group {}:{}", (Object)mVCGroup.getMvcId(), (Object)mVCGroup);
            this.groups.remove(mVCGroup.getMvcId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final Map<String, ? extends GriffonModel> getModels() {
        LinkedHashMap<String, GriffonModel> linkedHashMap = new LinkedHashMap<String, GriffonModel>();
        Object object = this.lock;
        synchronized (object) {
            for (MVCGroup mVCGroup : this.groups.values()) {
                GriffonModel griffonModel = mVCGroup.getModel();
                if (griffonModel == null) continue;
                linkedHashMap.put(mVCGroup.getMvcId(), griffonModel);
            }
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final Map<String, ? extends GriffonView> getViews() {
        LinkedHashMap<String, GriffonView> linkedHashMap = new LinkedHashMap<String, GriffonView>();
        Object object = this.lock;
        synchronized (object) {
            for (MVCGroup mVCGroup : this.groups.values()) {
                GriffonView griffonView = mVCGroup.getView();
                if (griffonView == null) continue;
                linkedHashMap.put(mVCGroup.getMvcId(), griffonView);
            }
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final Map<String, ? extends GriffonController> getControllers() {
        LinkedHashMap<String, GriffonController> linkedHashMap = new LinkedHashMap<String, GriffonController>();
        Object object = this.lock;
        synchronized (object) {
            for (MVCGroup mVCGroup : this.groups.values()) {
                GriffonController griffonController = mVCGroup.getController();
                if (griffonController == null) continue;
                linkedHashMap.put(mVCGroup.getMvcId(), griffonController);
            }
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    @Nonnull
    public MVCGroupConfiguration cloneMVCGroupConfiguration(@Nonnull String string, @Nonnull Map<String, Object> map) {
        GriffonNameUtils.requireNonBlank(string, ERROR_MVCTYPE_BLANK);
        Objects.requireNonNull(map, ERROR_CONFIG_NULL);
        MVCGroupConfiguration mVCGroupConfiguration = this.findConfiguration(string);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.putAll(mVCGroupConfiguration.getConfig());
        linkedHashMap.putAll(map);
        return this.newMVCGroupConfiguration(string, mVCGroupConfiguration.getMembers(), linkedHashMap);
    }

    @Nonnull
    protected List<? extends GriffonMvcArtifact> createMVC(@Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nullable String string, @Nonnull Map<String, Object> map) {
        MVCGroup mVCGroup = this.createMVCGroup(this.findConfiguration(mVCGroupConfiguration.getMvcType()), string, map);
        return Arrays.asList(mVCGroup.getModel(), mVCGroup.getView(), mVCGroup.getController());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(@Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nullable String string, @Nonnull Map<String, Object> map, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        MVCGroup mVCGroup = null;
        try {
            mVCGroup = this.createMVCGroup(mVCGroupConfiguration, string, map);
            mVCFunction.apply(mVCGroup.getModel(), mVCGroup.getView(), mVCGroup.getController());
        }
        catch (Throwable throwable) {
            try {
                if (mVCGroup != null) {
                    this.destroyMVCGroup(mVCGroup.getMvcId());
                }
            }
            catch (Exception exception) {
                LOG.warn("Could not destroy group [{}] of type {}", new Object[]{string, mVCGroupConfiguration.getMvcType(), GriffonExceptionHandler.sanitize(exception)});
            }
            throw throwable;
        }
        try {
            if (mVCGroup != null) {
                this.destroyMVCGroup(mVCGroup.getMvcId());
            }
        }
        catch (Exception exception) {
            LOG.warn("Could not destroy group [{}] of type {}", new Object[]{string, mVCGroupConfiguration.getMvcType(), GriffonExceptionHandler.sanitize(exception)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withMVCGroup(@Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nullable String string, @Nonnull Map<String, Object> map, @Nonnull MVCGroupFunction mVCGroupFunction) {
        MVCGroup mVCGroup = null;
        try {
            mVCGroup = this.createMVCGroup(mVCGroupConfiguration, string, map);
            mVCGroupFunction.apply(mVCGroup);
        }
        catch (Throwable throwable) {
            try {
                if (mVCGroup != null) {
                    this.destroyMVCGroup(mVCGroup.getMvcId());
                }
            }
            catch (Exception exception) {
                LOG.warn("Could not destroy group [{}] of type {}", new Object[]{string, mVCGroupConfiguration.getMvcType(), GriffonExceptionHandler.sanitize(exception)});
            }
            throw throwable;
        }
        try {
            if (mVCGroup != null) {
                this.destroyMVCGroup(mVCGroup.getMvcId());
            }
        }
        catch (Exception exception) {
            LOG.warn("Could not destroy group [{}] of type {}", new Object[]{string, mVCGroupConfiguration.getMvcType(), GriffonExceptionHandler.sanitize(exception)});
        }
    }

    @Nonnull
    protected abstract MVCGroup createMVCGroup(@Nonnull MVCGroupConfiguration var1, @Nullable String var2, @Nonnull Map<String, Object> var3);

    protected abstract void doInitialize(@Nonnull Map<String, MVCGroupConfiguration> var1);

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string) {
        return this.createMVCGroup(this.findConfiguration(string), null, Collections.emptyMap());
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull String string2) {
        return this.createMVCGroup(this.findConfiguration(string), string2, Collections.emptyMap());
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return this.createMVCGroup(this.findConfiguration(string), null, map);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull Map<String, Object> map) {
        return this.createMVCGroup(this.findConfiguration(string), null, map);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2) {
        return this.createMVCGroup(this.findConfiguration(string), string2, map);
    }

    @Override
    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map) {
        return this.createMVCGroup(this.findConfiguration(string), string2, map);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string) {
        return this.createMVC(this.findConfiguration(string), null, Collections.emptyMap());
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull Map<String, Object> map, @Nonnull String string) {
        return this.createMVC(this.findConfiguration(string), null, map);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull Map<String, Object> map) {
        return this.createMVC(this.findConfiguration(string), null, map);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull String string2) {
        return this.createMVC(this.findConfiguration(string), string2, Collections.emptyMap());
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2) {
        return this.createMVC(this.findConfiguration(string), string2, map);
    }

    @Override
    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map) {
        return this.createMVC(this.findConfiguration(string), string2, map);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.withMVCGroup(this.findConfiguration(string), null, Collections.emptyMap(), mVCFunction);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull String string2, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.withMVCGroup(this.findConfiguration(string), string2, Collections.emptyMap(), mVCFunction);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.withMVCGroup(this.findConfiguration(string), string2, map, mVCFunction);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.withMVCGroup(this.findConfiguration(string), string2, map, mVCFunction);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.withMVCGroup(this.findConfiguration(string), null, map, mVCFunction);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull MVCFunction<M, V, C> mVCFunction) {
        this.withMVCGroup(this.findConfiguration(string), null, map, mVCFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.withMVCGroup(this.findConfiguration(string), null, Collections.emptyMap(), mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.withMVCGroup(this.findConfiguration(string), string2, Collections.emptyMap(), mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, Object> map, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.withMVCGroup(this.findConfiguration(string), string2, map, mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull String string2, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.withMVCGroup(this.findConfiguration(string), string2, map, mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.withMVCGroup(this.findConfiguration(string), null, map, mVCGroupFunction);
    }

    @Override
    public void withMVCGroup(@Nonnull Map<String, Object> map, @Nonnull String string, @Nonnull MVCGroupFunction mVCGroupFunction) {
        this.withMVCGroup(this.findConfiguration(string), null, map, mVCGroupFunction);
    }

    @Override
    @Nonnull
    public <C extends GriffonController> C getController(@Nonnull String string, @Nonnull Class<C> clazz) throws ArtifactNotFoundException {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        GriffonController griffonController = this.getControllers().get(string);
        if (griffonController != null) {
            return (C)((GriffonController)clazz.cast(griffonController));
        }
        throw new ArtifactNotFoundException(clazz, string);
    }

    @Override
    @Nonnull
    public <M extends GriffonModel> M getModel(@Nonnull String string, @Nonnull Class<M> clazz) throws ArtifactNotFoundException {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        GriffonModel griffonModel = this.getModels().get(string);
        if (griffonModel != null) {
            return (M)((GriffonModel)clazz.cast(griffonModel));
        }
        throw new ArtifactNotFoundException(clazz, string);
    }

    @Override
    @Nonnull
    public <V extends GriffonView> V getView(@Nonnull String string, @Nonnull Class<V> clazz) throws ArtifactNotFoundException {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        GriffonView griffonView = this.getViews().get(string);
        if (griffonView != null) {
            return (V)((GriffonView)clazz.cast(griffonView));
        }
        throw new ArtifactNotFoundException(clazz, string);
    }

    @Override
    @Nullable
    public <C extends GriffonController> C findController(@Nonnull String string, @Nonnull Class<C> clazz) {
        try {
            return this.getController(string, clazz);
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return null;
        }
    }

    @Override
    @Nullable
    public <M extends GriffonModel> M findModel(@Nonnull String string, @Nonnull Class<M> clazz) {
        try {
            return this.getModel(string, clazz);
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return null;
        }
    }

    @Override
    @Nullable
    public <V extends GriffonView> V findView(@Nonnull String string, @Nonnull Class<V> clazz) {
        try {
            return this.getView(string, clazz);
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return null;
        }
    }
}

