/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.mvc;

import griffon.core.ApplicationClassLoader;
import griffon.core.ApplicationEvent;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.core.artifact.GriffonArtifact;
import griffon.core.artifact.GriffonClass;
import griffon.core.artifact.GriffonController;
import griffon.core.artifact.GriffonMvcArtifact;
import griffon.core.artifact.GriffonView;
import griffon.core.mvc.MVCGroup;
import griffon.core.mvc.MVCGroupConfiguration;
import griffon.exceptions.FieldException;
import griffon.exceptions.GriffonException;
import griffon.exceptions.MVCGroupInstantiationException;
import griffon.exceptions.NewInstanceException;
import griffon.inject.Contextual;
import griffon.inject.MVCMember;
import griffon.util.AnnotationUtils;
import griffon.util.CollectionUtils;
import griffon.util.ConfigUtils;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.injection.InjectionUnitOfWork;
import org.codehaus.griffon.runtime.core.mvc.AbstractMVCGroup;
import org.codehaus.griffon.runtime.core.mvc.AbstractMVCGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMVCGroupManager
extends AbstractMVCGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMVCGroupManager.class);
    private static final String CONFIG_KEY_COMPONENT = "component";
    private static final String CONFIG_KEY_EVENTS_LIFECYCLE = "events.lifecycle";
    private static final String CONFIG_KEY_EVENTS_INSTANTIATION = "events.instantiation";
    private static final String CONFIG_KEY_EVENTS_DESTRUCTION = "events.destruction";
    private static final String CONFIG_KEY_EVENTS_LISTENER = "events.listener";
    private static final String KEY_PARENT_GROUP = "parentGroup";
    private final ApplicationClassLoader applicationClassLoader;

    @Inject
    public DefaultMVCGroupManager(@Nonnull GriffonApplication griffonApplication, @Nonnull ApplicationClassLoader applicationClassLoader) {
        super(griffonApplication);
        this.applicationClassLoader = Objects.requireNonNull(applicationClassLoader, "Argument 'applicationClassLoader' must not be null");
    }

    @Override
    protected void doInitialize(@Nonnull Map<String, MVCGroupConfiguration> map) {
        Objects.requireNonNull(map, "Argument 'configurations' must not be null");
        for (MVCGroupConfiguration mVCGroupConfiguration : map.values()) {
            this.addConfiguration(mVCGroupConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected MVCGroup createMVCGroup(@Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nullable String string, @Nonnull Map<String, Object> map) {
        GriffonController griffonController;
        Object illegalStateException;
        Object object;
        Objects.requireNonNull(mVCGroupConfiguration, "Argument 'configuration' must not be null");
        Objects.requireNonNull(map, "Argument 'args' must not be null");
        string = this.resolveMvcId(mVCGroupConfiguration, string);
        this.checkIdIsUnique(string, mVCGroupConfiguration);
        LOG.debug("Building MVC group '{}' with name '{}'", (Object)mVCGroupConfiguration.getMvcType(), (Object)string);
        Map<String, Object> map2 = this.copyAndConfigureArguments(map, mVCGroupConfiguration, string);
        LinkedHashMap<String, ClassHolder> linkedHashMap = new LinkedHashMap<String, ClassHolder>();
        for (Map.Entry<String, String> object32 : mVCGroupConfiguration.getMembers().entrySet()) {
            object = object32.getKey();
            illegalStateException = object32.getValue();
            this.selectClassesPerMember((String)object, (String)illegalStateException, linkedHashMap);
        }
        boolean bl = this.getApplication().getEventRouter().isEventPublishingEnabled();
        this.getApplication().getEventRouter().setEventPublishingEnabled(this.isConfigFlagEnabled(mVCGroupConfiguration, CONFIG_KEY_EVENTS_INSTANTIATION));
        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
        object = new ArrayList();
        try {
            InjectionUnitOfWork.start();
        }
        catch (IllegalStateException illegalStateException2) {
            throw new MVCGroupInstantiationException("Can not instantiate MVC group '" + mVCGroupConfiguration.getMvcType() + "' with id '" + string + "'", mVCGroupConfiguration.getMvcType(), string, illegalStateException2);
        }
        try {
            linkedHashMap2.putAll(this.instantiateMembers(linkedHashMap, map2));
        }
        finally {
            this.getApplication().getEventRouter().setEventPublishingEnabled(bl);
            try {
                object.addAll(InjectionUnitOfWork.finish());
            }
            catch (IllegalStateException illegalStateException3) {
                throw new MVCGroupInstantiationException("Can not instantiate MVC group '" + mVCGroupConfiguration.getMvcType() + "' with id '" + string + "'", mVCGroupConfiguration.getMvcType(), string, illegalStateException3);
            }
        }
        illegalStateException = this.newMVCGroup(mVCGroupConfiguration, string, linkedHashMap2, (MVCGroup)map.get(KEY_PARENT_GROUP));
        this.adjustMvcArguments((MVCGroup)illegalStateException, map2);
        boolean bl2 = this.isConfigFlagEnabled(mVCGroupConfiguration, CONFIG_KEY_EVENTS_LIFECYCLE);
        if (bl2) {
            this.getApplication().getEventRouter().publishEvent(ApplicationEvent.INITIALIZE_MVC_GROUP.getName(), Arrays.asList(mVCGroupConfiguration, illegalStateException));
        }
        if (this.isConfigFlagEnabled(illegalStateException.getConfiguration(), CONFIG_KEY_EVENTS_LISTENER) && (griffonController = illegalStateException.getController()) != null) {
            this.getApplication().getEventRouter().addEventListener(griffonController);
        }
        this.fillReferencedProperties((MVCGroup)illegalStateException, map2);
        this.doAddGroup((MVCGroup)illegalStateException);
        this.initializeMembers((MVCGroup)illegalStateException, map2);
        if (illegalStateException instanceof AbstractMVCGroup) {
            ((AbstractMVCGroup)illegalStateException).getInjectedInstances().addAll((Collection<Object>)object);
        }
        if (bl2) {
            this.getApplication().getEventRouter().publishEvent(ApplicationEvent.CREATE_MVC_GROUP.getName(), Arrays.asList(illegalStateException));
        }
        return illegalStateException;
    }

    protected void adjustMvcArguments(@Nonnull MVCGroup mVCGroup, @Nonnull Map<String, Object> map) {
        map.put("mvcId", mVCGroup.getMvcId());
        map.put("mvcGroup", mVCGroup);
        map.put("application", this.getApplication());
    }

    @Nonnull
    protected String resolveMvcId(@Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nullable String string) {
        boolean bl = ConfigUtils.getConfigValueAsBoolean(mVCGroupConfiguration.getConfig(), CONFIG_KEY_COMPONENT, false);
        if (GriffonNameUtils.isBlank(string)) {
            string = bl ? mVCGroupConfiguration.getMvcType() + "-" + System.nanoTime() : mVCGroupConfiguration.getMvcType();
        }
        return string;
    }

    protected void selectClassesPerMember(@Nonnull String string, @Nonnull String string2, @Nonnull Map<String, ClassHolder> map) {
        GriffonClass griffonClass = this.getApplication().getArtifactManager().findGriffonClass(string2);
        ClassHolder classHolder = new ClassHolder();
        if (griffonClass != null) {
            classHolder.artifactClass = griffonClass.getClazz();
        } else {
            classHolder.regularClass = this.loadClass(string2);
        }
        map.put(string, classHolder);
    }

    @Nonnull
    protected Map<String, Object> copyAndConfigureArguments(@Nonnull Map<String, Object> map, @Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nonnull String string) {
        CollectionUtils.MapBuilder<String, Object> mapBuilder = CollectionUtils.map().e("application", this.getApplication()).e("mvcType", (GriffonApplication)((Object)mVCGroupConfiguration.getMvcType())).e("mvcId", (GriffonApplication)((Object)string)).e("configuration", (GriffonApplication)((Object)mVCGroupConfiguration));
        if (map.containsKey(KEY_PARENT_GROUP) && map.get(KEY_PARENT_GROUP) instanceof MVCGroup) {
            MVCGroup mVCGroup = (MVCGroup)map.get(KEY_PARENT_GROUP);
            for (Map.Entry<String, Object> entry : mVCGroup.getMembers().entrySet()) {
                map.put("parent" + GriffonNameUtils.capitalize(entry.getKey()), entry.getValue());
            }
        }
        mapBuilder.putAll(map);
        return mapBuilder;
    }

    protected void checkIdIsUnique(@Nonnull String string, @Nonnull MVCGroupConfiguration mVCGroupConfiguration) {
        if (this.findGroup(string) != null) {
            String string2 = this.getApplication().getConfiguration().getAsString("griffon.mvcid.collision", "exception");
            if ("warning".equalsIgnoreCase(string2)) {
                LOG.warn("A previous instance of MVC group '{}' with id '{}' exists. Destroying the old instance first.", (Object)mVCGroupConfiguration.getMvcType(), (Object)string);
                this.destroyMVCGroup(string);
            } else {
                throw new MVCGroupInstantiationException("Can not instantiate MVC group '" + mVCGroupConfiguration.getMvcType() + "' with id '" + string + "' because a previous instance with that name exists and was not disposed off properly.", mVCGroupConfiguration.getMvcType(), string);
            }
        }
    }

    @Nonnull
    protected Map<String, Object> instantiateMembers(@Nonnull Map<String, ClassHolder> map, @Nonnull Map<String, Object> map2) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ClassHolder> entry : map.entrySet()) {
            Object object;
            Class<GriffonArtifact> clazz;
            String string = entry.getKey();
            if (map2.containsKey(string)) {
                linkedHashMap.put(string, map2.get(string));
                continue;
            }
            ClassHolder classHolder = entry.getValue();
            if (classHolder.artifactClass != null) {
                clazz = classHolder.artifactClass;
                object = this.getApplication().getArtifactManager();
                GriffonClass griffonClass = object.findGriffonClass(clazz);
                Object a = object.newInstance(griffonClass);
                linkedHashMap.put(string, a);
                map2.put(string, a);
                continue;
            }
            clazz = classHolder.regularClass;
            try {
                object = clazz.newInstance();
                this.getApplication().getInjector().injectMembers(object);
                linkedHashMap.put(string, object);
                map2.put(string, object);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                LOG.error("Can't create member {} with {}", (Object)string, clazz);
                throw new NewInstanceException(clazz, (Throwable)reflectiveOperationException);
            }
        }
        return linkedHashMap;
    }

    protected void initializeMembers(@Nonnull MVCGroup mVCGroup, @Nonnull Map<String, Object> map) {
        LOG.debug("Initializing each MVC member of group '{}'", (Object)mVCGroup.getMvcId());
        for (Map.Entry<String, Object> entry : mVCGroup.getMembers().entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof GriffonArtifact) {
                this.initializeArtifactMember(mVCGroup, string, (GriffonArtifact)object, map);
                continue;
            }
            this.initializeNonArtifactMember(mVCGroup, string, object, map);
        }
    }

    protected void initializeArtifactMember(@Nonnull MVCGroup mVCGroup, @Nonnull String string, final @Nonnull GriffonArtifact griffonArtifact, final @Nonnull Map<String, Object> map) {
        if (griffonArtifact instanceof GriffonView) {
            this.getApplication().getUIThreadManager().runInsideUISync(new Runnable(){

                @Override
                public void run() {
                    try {
                        GriffonView griffonView = (GriffonView)griffonArtifact;
                        griffonView.initUI();
                        griffonView.mvcGroupInit(map);
                    }
                    catch (RuntimeException runtimeException) {
                        throw (RuntimeException)GriffonExceptionHandler.sanitize(runtimeException);
                    }
                }
            });
        } else if (griffonArtifact instanceof GriffonMvcArtifact) {
            ((GriffonMvcArtifact)griffonArtifact).mvcGroupInit(map);
        }
    }

    protected void initializeNonArtifactMember(@Nonnull MVCGroup mVCGroup, @Nonnull String string, @Nonnull Object object, @Nonnull Map<String, Object> map) {
    }

    protected void fillReferencedProperties(@Nonnull MVCGroup mVCGroup, @Nonnull Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : mVCGroup.getMembers().entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map);
            LinkedHashMap<String, Field> linkedHashMap2 = new LinkedHashMap<String, Field>();
            for (Field field : GriffonClassUtils.getAllDeclaredFields(object.getClass())) {
                linkedHashMap2.put(field.getName(), field);
            }
            LinkedHashMap linkedHashMap3 = new LinkedHashMap();
            for (PropertyDescriptor propertyDescriptor : GriffonClassUtils.getPropertyDescriptors(object.getClass())) {
                Method method = propertyDescriptor.getWriteMethod();
                if (method == null || this.isInjectable(method)) continue;
                boolean bl = AnnotationUtils.findAnnotation(AnnotationUtils.annotationsOfMethodParameter(method, 0), Nonnull.class) == null;
                InjectionPoint.Type type = this.resolveType(method);
                Field field = (Field)linkedHashMap2.get(propertyDescriptor.getName());
                if (field != null && type == InjectionPoint.Type.OTHER) {
                    type = this.resolveType(field);
                    bl = field.getAnnotation(Nonnull.class) == null;
                }
                linkedHashMap3.put(propertyDescriptor.getName(), new MethodInjectionPoint(propertyDescriptor.getName(), bl, type, method));
            }
            for (Field field : GriffonClassUtils.getAllDeclaredFields(object.getClass())) {
                if (Modifier.isStatic(field.getModifiers()) || this.isInjectable(field) || linkedHashMap3.containsKey(field.getName())) continue;
                boolean bl = field.getAnnotation(Nonnull.class) == null;
                InjectionPoint.Type type = this.resolveType(field);
                linkedHashMap3.put(field.getName(), new FieldInjectionPoint(field.getName(), bl, type, field));
            }
            for (InjectionPoint injectionPoint : linkedHashMap3.values()) {
                injectionPoint.apply(mVCGroup, string, object, map);
                linkedHashMap.remove(injectionPoint.name);
            }
            GriffonClassUtils.setPropertiesOrFieldsNoException(object, linkedHashMap);
        }
    }

    @Nonnull
    protected InjectionPoint.Type resolveType(@Nonnull AnnotatedElement annotatedElement) {
        if (this.isContextual(annotatedElement)) {
            return InjectionPoint.Type.CONTEXTUAL;
        }
        if (this.isMvcMember(annotatedElement)) {
            return InjectionPoint.Type.MEMBER;
        }
        return InjectionPoint.Type.OTHER;
    }

    protected boolean isContextual(AnnotatedElement annotatedElement) {
        return annotatedElement != null && annotatedElement.getAnnotation(Contextual.class) != null;
    }

    protected boolean isInjectable(AnnotatedElement annotatedElement) {
        return annotatedElement != null && annotatedElement.getAnnotation(Inject.class) != null;
    }

    protected boolean isMvcMember(AnnotatedElement annotatedElement) {
        return annotatedElement != null && annotatedElement.getAnnotation(MVCMember.class) != null;
    }

    protected void doAddGroup(@Nonnull MVCGroup mVCGroup) {
        this.addGroup(mVCGroup);
    }

    @Override
    public void destroyMVCGroup(@Nonnull String string) {
        GriffonController griffonController;
        MVCGroup mVCGroup = this.findGroup(string);
        LOG.debug("Group '{}' points to {}", (Object)string, (Object)mVCGroup);
        if (mVCGroup == null) {
            return;
        }
        LOG.debug("Destroying MVC group identified by '{}'", (Object)string);
        if (this.isConfigFlagEnabled(mVCGroup.getConfiguration(), CONFIG_KEY_EVENTS_LISTENER) && (griffonController = mVCGroup.getController()) != null) {
            this.getApplication().getEventRouter().removeEventListener(griffonController);
        }
        boolean bl = this.isConfigFlagEnabled(mVCGroup.getConfiguration(), CONFIG_KEY_EVENTS_DESTRUCTION);
        this.destroyMembers(mVCGroup, bl);
        this.doRemoveGroup(mVCGroup);
        mVCGroup.destroy();
        if (this.isConfigFlagEnabled(mVCGroup.getConfiguration(), CONFIG_KEY_EVENTS_LIFECYCLE)) {
            this.getApplication().getEventRouter().publishEvent(ApplicationEvent.DESTROY_MVC_GROUP.getName(), Arrays.asList(mVCGroup));
        }
    }

    protected void destroyMembers(@Nonnull MVCGroup mVCGroup, boolean bl) {
        Object object;
        for (Map.Entry<String, Object> entry : mVCGroup.getMembers().entrySet()) {
            object = entry.getValue();
            if (object instanceof GriffonArtifact) {
                this.destroyArtifactMember((String)entry.getKey(), (GriffonArtifact)object, bl);
                continue;
            }
            this.destroyNonArtifactMember((String)entry.getKey(), object, bl);
        }
        if (mVCGroup instanceof AbstractMVCGroup) {
            Map.Entry<String, Object> entry;
            List<Object> list = ((AbstractMVCGroup)mVCGroup).getInjectedInstances();
            entry = list.iterator();
            while (entry.hasNext()) {
                object = entry.next();
                this.getApplication().getInjector().release(object);
            }
            list.clear();
        }
    }

    protected void destroyArtifactMember(@Nonnull String string, @Nonnull GriffonArtifact griffonArtifact, boolean bl) {
        if (griffonArtifact instanceof GriffonMvcArtifact) {
            final GriffonMvcArtifact griffonMvcArtifact = (GriffonMvcArtifact)griffonArtifact;
            if (bl) {
                this.getApplication().getEventRouter().publishEvent(ApplicationEvent.DESTROY_INSTANCE.getName(), Arrays.asList(griffonArtifact.getClass(), griffonMvcArtifact));
            }
            if (griffonMvcArtifact instanceof GriffonView) {
                this.getApplication().getUIThreadManager().runInsideUISync(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            griffonMvcArtifact.mvcGroupDestroy();
                        }
                        catch (RuntimeException runtimeException) {
                            throw (RuntimeException)GriffonExceptionHandler.sanitize(runtimeException);
                        }
                    }
                });
            } else {
                griffonMvcArtifact.mvcGroupDestroy();
            }
            for (String string2 : new String[]{"parentModel", "parentView", "parentController", KEY_PARENT_GROUP}) {
                GriffonClassUtils.setPropertyOrFieldValueNoException(griffonArtifact, string2, null);
            }
        }
        this.destroyContextualMemberProperties(string, griffonArtifact);
    }

    protected void destroyContextualMemberProperties(@Nonnull String string, @Nonnull GriffonArtifact griffonArtifact) {
        for (Field field : GriffonClassUtils.getAllDeclaredFields(griffonArtifact.getClass())) {
            if (!this.isContextual(field)) continue;
            try {
                GriffonClassUtils.setFieldValue(griffonArtifact, field.getName(), null);
            }
            catch (FieldException fieldException) {
                throw new IllegalStateException("Could not nullify field " + field.getName() + "' in " + string + " (" + griffonArtifact.getClass().getName() + ")", fieldException);
            }
        }
    }

    protected void destroyNonArtifactMember(@Nonnull String string, @Nonnull Object object, boolean bl) {
    }

    protected void doRemoveGroup(@Nonnull MVCGroup mVCGroup) {
        this.removeGroup(mVCGroup);
    }

    protected boolean isConfigFlagEnabled(@Nonnull MVCGroupConfiguration mVCGroupConfiguration, @Nonnull String string) {
        return ConfigUtils.getConfigValueAsBoolean(mVCGroupConfiguration.getConfig(), string, true);
    }

    @Nullable
    protected Class<?> loadClass(@Nonnull String string) {
        try {
            return this.applicationClassLoader.get().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GriffonException(classNotFoundException.toString(), classNotFoundException);
        }
    }

    protected static final class ClassHolder {
        protected Class<?> regularClass;
        protected Class<? extends GriffonArtifact> artifactClass;

        protected ClassHolder() {
        }
    }

    protected static class MethodInjectionPoint
    extends InjectionPoint {
        protected final Method method;

        protected MethodInjectionPoint(String string, boolean bl, InjectionPoint.Type type, Method method) {
            super(string, bl, type);
            this.method = method;
        }

        @Override
        protected void apply(@Nonnull MVCGroup mVCGroup, @Nonnull String string, @Nonnull Object object, @Nonnull Map<String, Object> map) {
            if (this.type == InjectionPoint.Type.CONTEXTUAL) {
                Object[] objectArray = AnnotationUtils.namesFor(this.method);
                Object object2 = map.get(this.name);
                for (String string2 : objectArray) {
                    if (!mVCGroup.getContext().containsKey(string2)) continue;
                    object2 = mVCGroup.getContext().get(string2);
                    break;
                }
                if (object2 == null && !this.nullable) {
                    throw new IllegalStateException("Could not find an instance of type " + this.method.getParameterTypes()[0].getName() + " under keys '" + Arrays.toString(objectArray) + "' in the context of MVCGroup[" + mVCGroup.getMvcType() + ":" + mVCGroup.getMvcId() + "] to be injected on property '" + this.name + "' in " + (Object)((Object)this.type) + " (" + object.getClass().getName() + "). Property does not accept null values.");
                }
                try {
                    this.method.invoke(object, object2);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    throw new MVCGroupInstantiationException(mVCGroup.getMvcType(), mVCGroup.getMvcId(), reflectiveOperationException);
                }
            }
            Object object3 = map.get(this.name);
            if (object3 == null) {
                if (!this.nullable && this.type == InjectionPoint.Type.MEMBER) {
                    throw new IllegalStateException("Could not inject argument on property '" + this.name + "' in " + string + " (" + object.getClass().getName() + "). Property does not accept null values.");
                }
                return;
            }
            try {
                this.method.invoke(object, object3);
                if (this.type == InjectionPoint.Type.OTHER) {
                    LOG.warn("Property '" + this.name + "' in " + string + " (" + object.getClass().getName() + ") must be annotated with @" + MVCMember.class.getName() + ".");
                }
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new MVCGroupInstantiationException(mVCGroup.getMvcType(), mVCGroup.getMvcId(), reflectiveOperationException);
            }
        }
    }

    protected static class FieldInjectionPoint
    extends InjectionPoint {
        protected final Field field;

        protected FieldInjectionPoint(String string, boolean bl, InjectionPoint.Type type, Field field) {
            super(string, bl, type);
            this.field = field;
        }

        @Override
        protected void apply(@Nonnull MVCGroup mVCGroup, @Nonnull String string, @Nonnull Object object, @Nonnull Map<String, Object> map) {
            Object[] objectArray = AnnotationUtils.namesFor(this.field);
            Object object2 = map.get(this.name);
            if (this.type == InjectionPoint.Type.CONTEXTUAL) {
                for (String string2 : objectArray) {
                    if (!mVCGroup.getContext().containsKey(string2)) continue;
                    object2 = mVCGroup.getContext().get(string2);
                    break;
                }
            }
            if (object2 == null) {
                if (!this.nullable) {
                    if (this.type == InjectionPoint.Type.CONTEXTUAL) {
                        throw new IllegalStateException("Could not find an instance of type " + this.field.getType().getName() + " under keys '" + Arrays.toString(objectArray) + "' in the context of MVCGroup[" + mVCGroup.getMvcType() + ":" + mVCGroup.getMvcId() + "] to be injected on field '" + this.field.getName() + "' in " + (Object)((Object)this.type) + " (" + object.getClass().getName() + "). Field does not accept null values.");
                    }
                    if (this.type == InjectionPoint.Type.MEMBER) {
                        throw new IllegalStateException("Could not inject argument on field '" + this.name + "' in " + string + " (" + object.getClass().getName() + "). Field does not accept null values.");
                    }
                }
                return;
            }
            try {
                GriffonClassUtils.setFieldValue(object, this.name, object2);
                if (this.type == InjectionPoint.Type.OTHER) {
                    LOG.warn("Field '" + this.name + "' in " + string + " (" + object.getClass().getName() + ") must be annotated with @" + MVCMember.class.getName() + ".");
                }
            }
            catch (FieldException fieldException) {
                throw new MVCGroupInstantiationException(mVCGroup.getMvcType(), mVCGroup.getMvcId(), fieldException);
            }
        }
    }

    protected static abstract class InjectionPoint {
        protected final String name;
        protected final boolean nullable;
        protected final Type type;

        protected InjectionPoint(String string, boolean bl, Type type) {
            this.name = string;
            this.nullable = bl;
            this.type = type;
        }

        protected abstract void apply(@Nonnull MVCGroup var1, @Nonnull String var2, @Nonnull Object var3, @Nonnull Map<String, Object> var4);

        protected static enum Type {
            MEMBER,
            CONTEXTUAL,
            OTHER;

        }
    }
}

