/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.resources;

import griffon.core.GriffonExceptionHandler;
import griffon.core.editors.ExtendedPropertyEditor;
import griffon.core.editors.PropertyEditorResolver;
import griffon.core.resources.InjectedResource;
import griffon.core.resources.ResourceInjector;
import griffon.exceptions.InstanceMethodInvocationException;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceInjector
implements ResourceInjector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResourceInjector.class);
    protected static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    protected static final String ERROR_METHOD_NULL = "Argument 'method' must not be null";
    protected static final String ERROR_FIELD_NULL = "Argument 'field' must not be null";
    protected static final String ERROR_CLASS_NULL = "Argument 'klass' must not be null";
    protected static final String ERROR_TYPE_NULL = "Argument 'type' must not be null";
    protected static final String ERROR_VALUE_NULL = "Argument 'value' must not be null";
    protected static final String ERROR_FULLY_QUALIFIED_NAME_BLANK = "Argument 'fqName' must not be blank";
    protected static final String ERROR_FULLY_QUALIFIED_FIELD_NAME_BLANK = "Argument 'fqFieldName' must not be blank";

    @Override
    public void injectResources(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_INSTANCE_NULL);
        Class<?> clazz = object.getClass();
        do {
            this.doResourceInjection(clazz, object);
        } while (null != (clazz = clazz.getSuperclass()));
    }

    protected boolean doResourceInjection(@Nonnull Class<?> clazz, @Nonnull Object object) {
        Object object2;
        String[] stringArray;
        Object[] objectArray;
        Object[] objectArray2;
        Object object3;
        Object object4;
        Object object5;
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        Objects.requireNonNull(object, ERROR_INSTANCE_NULL);
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PropertyDescriptor[] propertyDescriptorArray = GriffonClassUtils.getPropertyDescriptors(clazz);
        for (PropertyDescriptor object6 : propertyDescriptorArray) {
            Object object7;
            object5 = object6.getWriteMethod();
            if (null == object5 || Modifier.isStatic(((Method)object5).getModifiers()) || null == (object4 = ((Method)object5).getAnnotation(InjectedResource.class))) continue;
            object3 = object6.getName();
            objectArray2 = ((Method)object5).getDeclaringClass().getName().replace('$', '.') + "." + (String)object3;
            objectArray = object4.key();
            stringArray = object4.args();
            object2 = object4.defaultValue();
            String string = object4.format();
            if (GriffonNameUtils.isBlank((String)objectArray)) {
                objectArray = objectArray2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Property " + (String)object3 + " of instance " + object + " [key='" + (String)objectArray + "', args='" + Arrays.toString(stringArray) + "', defaultValue='" + (String)object2 + "', format='" + string + "'] is marked for resource injection.");
            }
            if (null != (object7 = GriffonNameUtils.isBlank((String)object2) ? this.resolveResource((String)objectArray, stringArray) : this.resolveResource((String)objectArray, stringArray, (String)object2))) {
                Class<?> clazz2 = ((Method)object5).getParameterTypes()[0];
                if (!clazz2.isAssignableFrom(object7.getClass())) {
                    object7 = this.convertValue(clazz2, object7, string);
                }
                this.setPropertyValue(object, (Method)object5, object7, (String)objectArray2);
            }
            arrayList.add(object3);
            bl = true;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.isSynthetic() || arrayList.contains(field.getName()) || null == (object5 = field.getAnnotation(InjectedResource.class))) continue;
            object4 = field.getDeclaringClass().getName().replace('$', '.') + "." + field.getName();
            object3 = object5.key();
            objectArray2 = object5.args();
            objectArray = object5.defaultValue();
            stringArray = object5.format();
            if (GriffonNameUtils.isBlank((String)object3)) {
                object3 = object4;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Field " + (String)object4 + " of instance " + object + " [key='" + (String)object3 + "', args='" + Arrays.toString(objectArray2) + "', defaultValue='" + (String)objectArray + "', format='" + (String)stringArray + "'] is marked for resource injection.");
            }
            if (null != (object2 = GriffonNameUtils.isBlank((String)objectArray) ? this.resolveResource((String)object3, (String[])objectArray2) : this.resolveResource((String)object3, (String[])objectArray2, (String)objectArray))) {
                if (!field.getType().isAssignableFrom(object2.getClass())) {
                    object2 = this.convertValue(field.getType(), object2, (String)stringArray);
                }
                this.setFieldValue(object, field, object2, (String)object4);
            }
            bl = true;
        }
        return bl;
    }

    @Nullable
    protected abstract Object resolveResource(@Nonnull String var1, @Nonnull String[] var2);

    @Nullable
    protected abstract Object resolveResource(@Nonnull String var1, @Nonnull String[] var2, @Nonnull String var3);

    @Nonnull
    protected Object convertValue(@Nonnull Class<?> clazz, @Nonnull Object object, @Nullable String string) {
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        Objects.requireNonNull(object, ERROR_VALUE_NULL);
        PropertyEditor propertyEditor = this.resolvePropertyEditor(clazz, string);
        if (null == propertyEditor) {
            return object;
        }
        if (object instanceof CharSequence) {
            propertyEditor.setAsText(String.valueOf(object));
        } else {
            propertyEditor.setValue(object);
        }
        return propertyEditor.getValue();
    }

    @Nullable
    protected PropertyEditor resolvePropertyEditor(@Nonnull Class<?> clazz, @Nullable String string) {
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(clazz);
        if (propertyEditor instanceof ExtendedPropertyEditor) {
            ((ExtendedPropertyEditor)propertyEditor).setFormat(string);
        }
        return propertyEditor;
    }

    protected void setPropertyValue(@Nonnull Object object, @Nonnull Method method, @Nullable Object object2, @Nonnull String string) {
        block2: {
            Objects.requireNonNull(object, ERROR_INSTANCE_NULL);
            Objects.requireNonNull(method, ERROR_METHOD_NULL);
            GriffonNameUtils.requireNonBlank(string, ERROR_FULLY_QUALIFIED_NAME_BLANK);
            try {
                method.invoke(object, object2);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("Cannot set value on property " + string + " of instance " + object, GriffonExceptionHandler.sanitize(reflectiveOperationException));
            }
        }
    }

    protected void setFieldValue(@Nonnull Object object, @Nonnull Field field, @Nullable Object object2, @Nonnull String string) {
        Objects.requireNonNull(object, ERROR_INSTANCE_NULL);
        Objects.requireNonNull(field, ERROR_FIELD_NULL);
        GriffonNameUtils.requireNonBlank(string, ERROR_FULLY_QUALIFIED_FIELD_NAME_BLANK);
        String string2 = GriffonNameUtils.getSetterName(field.getName());
        try {
            GriffonClassUtils.invokeExactInstanceMethod(object, string2, object2);
        }
        catch (InstanceMethodInvocationException instanceMethodInvocationException) {
            try {
                field.setAccessible(true);
                field.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOG.warn("Cannot set value on field {} of instance {}", new Object[]{string, object, GriffonExceptionHandler.sanitize(illegalAccessException)});
            }
        }
    }
}

